/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.teiid.client.lob.LobChunk;
import org.teiid.client.lob.LobChunkProducer;
import org.teiid.core.CorePlugin;

public class ByteLobChunkStream
implements LobChunkProducer {
    private PushbackInputStream stream;
    private int chunkSize;
    private boolean closed;

    public ByteLobChunkStream(InputStream stream, int chunkSize) {
        this.stream = new PushbackInputStream(stream);
        this.chunkSize = chunkSize;
    }

    public LobChunk getNextChunk() throws IOException {
        int next;
        if (this.closed) {
            throw new IllegalStateException(CorePlugin.Util.getString("stream_closed"));
        }
        byte[] cbuf = new byte[this.chunkSize];
        int start = 0;
        int read = 0;
        while (true) {
            int currentRead;
            if ((currentRead = this.stream.read(cbuf, start, cbuf.length - start)) == -1) {
                if (start != 0) break;
                return new LobChunk(new byte[0], true);
            }
            if ((read += currentRead) >= this.chunkSize) break;
            start = read;
        }
        boolean isLast = false;
        if (read != this.chunkSize) {
            byte[] buf = new byte[read];
            System.arraycopy(cbuf, 0, buf, 0, read);
            cbuf = buf;
        }
        if ((next = this.stream.read()) == -1) {
            isLast = true;
        } else {
            this.stream.unread(next);
        }
        return new LobChunk(cbuf, isLast);
    }

    public void close() throws IOException {
        this.closed = true;
        this.stream.close();
    }
}

