/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.capabilities;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.translator.ExecutionFactory;

public class BasicSourceCapabilities
implements SourceCapabilities,
Serializable {
    private static final long serialVersionUID = -1779069588746365579L;
    private Map<SourceCapabilities.Capability, Boolean> capabilityMap = new HashMap<SourceCapabilities.Capability, Boolean>();
    private Map<String, Boolean> functionMap = new TreeMap<String, Boolean>(String.CASE_INSENSITIVE_ORDER);
    private Map<SourceCapabilities.Capability, Object> propertyMap = new HashMap<SourceCapabilities.Capability, Object>();
    private ExecutionFactory<?, ?> translator;

    @Override
    public boolean supportsCapability(SourceCapabilities.Capability capability) {
        Boolean supports = this.capabilityMap.get((Object)capability);
        return supports == null ? false : supports;
    }

    @Override
    public boolean supportsFunction(String functionName) {
        Boolean supports = this.functionMap.get(functionName);
        return supports == null ? false : supports;
    }

    public void setCapabilitySupport(SourceCapabilities.Capability capability, boolean supports) {
        if (supports && capability == SourceCapabilities.Capability.QUERY_AGGREGATES) {
            this.capabilityMap.put(SourceCapabilities.Capability.QUERY_GROUP_BY, true);
            this.capabilityMap.put(SourceCapabilities.Capability.QUERY_HAVING, true);
        } else {
            this.capabilityMap.put(capability, supports);
        }
    }

    public void setFunctionSupport(String function, boolean supports) {
        this.functionMap.put(function, supports);
    }

    public String toString() {
        return "BasicSourceCapabilities<caps=" + this.capabilityMap + ", funcs=" + this.functionMap + ">";
    }

    public void setSourceProperty(SourceCapabilities.Capability propertyName, Object value) {
        this.propertyMap.put(propertyName, value);
    }

    @Override
    public Object getSourceProperty(SourceCapabilities.Capability propertyName) {
        return this.propertyMap.get((Object)propertyName);
    }

    @Override
    public boolean supportsConvert(int sourceType, int targetType) {
        if (this.translator == null) {
            return true;
        }
        return this.translator.supportsConvert(sourceType, targetType);
    }

    public void setTranslator(ExecutionFactory<?, ?> translator) {
        this.translator = translator;
    }

    @Override
    public boolean supportsFormatLiteral(String literal, ExecutionFactory.Format format) {
        if (this.translator == null) {
            return false;
        }
        return this.translator.supportsFormatLiteral(literal, format);
    }
}

