/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TupleBatch {
    public static final byte NOT_TERMINATED = 0;
    public static final byte TERMINATED = 1;
    public static final byte ITERATION_TERMINATED = 2;
    private long rowOffset;
    protected List<List<?>> tuples;
    private byte terminationFlag = 0;

    public TupleBatch() {
    }

    public TupleBatch(long beginRow, List<?>[] tuples) {
        this.rowOffset = beginRow;
        this.tuples = Arrays.asList(tuples);
    }

    public TupleBatch(long beginRow, List<? extends List<?>> listOfTupleLists) {
        this.rowOffset = beginRow;
        this.tuples = new ArrayList(listOfTupleLists);
    }

    public long getBeginRow() {
        return this.rowOffset;
    }

    public long getEndRow() {
        return this.rowOffset + (long)this.tuples.size() - 1L;
    }

    public int getRowCount() {
        return this.tuples.size();
    }

    public List<?> getTuple(long rowIndex) {
        long base = rowIndex - this.rowOffset;
        int intVal = (int)base;
        if (base != (long)intVal) {
            throw new AssertionError((Object)("rowIndex overflow " + rowIndex));
        }
        return this.tuples.get(intVal);
    }

    public List<List<?>> getTuples() {
        return this.tuples;
    }

    public List<?>[] getAllTuples() {
        return this.tuples.toArray(new List[this.tuples.size()]);
    }

    public boolean getTerminationFlag() {
        return this.terminationFlag == 1;
    }

    public void setTerminationFlag(boolean terminationFlag) {
        this.terminationFlag = terminationFlag ? (byte)1 : 0;
    }

    public void setTermination(byte val) {
        this.terminationFlag = val;
    }

    public byte getTermination() {
        return this.terminationFlag;
    }

    public boolean containsRow(long row) {
        return this.rowOffset <= row && this.getEndRow() >= row;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("TupleBatch; beginning row=");
        s.append(this.rowOffset);
        s.append(", number of rows=");
        s.append(this.tuples.size());
        s.append(", lastBatch=");
        s.append(this.terminationFlag);
        return s.toString();
    }

    public void setRowOffset(long rowOffset) {
        this.rowOffset = rowOffset;
    }
}

