/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;

public class DirectQueryMetadataRepository
extends MetadataRepository {
    public void loadMetadata(MetadataFactory factory, ExecutionFactory executionFactory, Object connectionFactory) throws TranslatorException {
        if (executionFactory != null && executionFactory.supportsDirectQueryProcedure() && factory.getSchema().getProcedure(executionFactory.getDirectQueryProcedureName()) == null) {
            Procedure p = factory.addProcedure(executionFactory.getDirectQueryProcedureName());
            p.setAnnotation("Invokes translator with a native query that returns results in an array of values");
            ProcedureParameter param = factory.addProcedureParameter("request", "string", ProcedureParameter.Type.In, p);
            param.setAnnotation("The native query to execute");
            param.setNullType(BaseColumn.NullType.No_Nulls);
            param = factory.addProcedureParameter("variable", "object", ProcedureParameter.Type.In, p);
            param.setAnnotation("Any number of varaibles; usage will vary by translator");
            param.setNullType(BaseColumn.NullType.Nullable);
            param.setVarArg(true);
            factory.addProcedureResultSetColumn("tuple", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)TypeFacility.RUNTIME_TYPES.OBJECT)), p);
        }
    }
}

