/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.FilteredCommand;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.visitor.CorrelatedReferenceCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.ValidationVisitor;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;

public class RowBasedSecurityHelper {
    public static boolean applyRowSecurity(QueryMetadataInterface metadata, GroupSymbol group, CommandContext cc) throws QueryMetadataException, TeiidComponentException {
        Map<String, DataPolicy> policies = cc.getAllowedDataPolicies();
        if (policies == null || policies.isEmpty()) {
            return false;
        }
        String fullName = metadata.getFullName(group.getMetadataID());
        for (Map.Entry<String, DataPolicy> entry : policies.entrySet()) {
            DataPolicyMetadata dpm = (DataPolicyMetadata)entry.getValue();
            if (!dpm.hasRowSecurity(fullName)) continue;
            return true;
        }
        return false;
    }

    public static Criteria getRowBasedFilters(QueryMetadataInterface metadata, GroupSymbol group, CommandContext cc, boolean constraintsOnly) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        Expression ex;
        Map<String, DataPolicy> policies = cc.getAllowedDataPolicies();
        if (policies == null || policies.isEmpty()) {
            return null;
        }
        boolean user = false;
        ArrayList<Criteria> crits = null;
        Object metadataID = group.getMetadataID();
        String fullName = metadata.getFullName(metadataID);
        for (Map.Entry<String, DataPolicy> entry : policies.entrySet()) {
            String filterString;
            DataPolicyMetadata dpm = (DataPolicyMetadata)entry.getValue();
            DataPolicyMetadata.PermissionMetaData pmd = (DataPolicyMetadata.PermissionMetaData)dpm.getPermissionMap().get(fullName);
            if (pmd == null || (filterString = pmd.getCondition()) == null || constraintsOnly && Boolean.FALSE.equals(pmd.getConstraint())) continue;
            Criteria filter = RowBasedSecurityHelper.resolveCondition(metadata, group, fullName, entry, pmd, filterString);
            if (!dpm.isAnyAuthenticated()) {
                user = true;
            }
            if (crits == null) {
                crits = new ArrayList<Criteria>(2);
            }
            crits.add(filter);
        }
        if (crits == null || crits.isEmpty()) {
            return null;
        }
        Criteria result = null;
        result = crits.size() == 1 ? (Criteria)crits.get(0) : new CompoundCriteria(1, crits);
        if (group.getDefinition() != null) {
            RecontextVisitor emv = new RecontextVisitor(group);
            PreOrPostOrderNavigator.doVisit(result, emv, true, true);
        }
        if (user) {
            cc.setDeterminismLevel(FunctionMethod.Determinism.USER_DETERMINISTIC);
        }
        if ((ex = QueryRewriter.rewriteExpression(result, cc, metadata, true)) instanceof Criteria) {
            return (Criteria)ex;
        }
        return QueryRewriter.rewriteCriteria(new ExpressionCriteria(ex), cc, metadata);
    }

    static Criteria resolveCondition(QueryMetadataInterface metadata, GroupSymbol group, String fullName, Map.Entry<String, DataPolicy> entry, DataPolicyMetadata.PermissionMetaData pmd, String filterString) throws QueryMetadataException {
        Criteria filter = (Criteria)pmd.getResolvedCondition();
        if (filter == null) {
            try {
                filter = QueryParser.getQueryParser().parseCriteria(filterString);
                GroupSymbol gs = group;
                if (group.getDefinition() != null) {
                    gs = new GroupSymbol(fullName);
                    gs.setMetadataID(group.getMetadataID());
                }
                List<GroupSymbol> groups = Arrays.asList(gs);
                for (SubqueryContainer<?> container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(filter)) {
                    ((Command)container.getCommand()).pushNewResolvingContext(groups);
                    QueryResolver.resolveCommand(container.getCommand(), metadata, false);
                }
                ResolverVisitor.resolveLanguageObject(filter, groups, metadata);
                ValidatorReport report = Validator.validate(filter, metadata, new ValidationVisitor());
                if (report.hasItems()) {
                    ValidatorFailure firstFailure = (ValidatorFailure)report.getItems().iterator().next();
                    throw new QueryMetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31129, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31129, new Object[]{entry.getKey(), fullName}) + " " + firstFailure);
                }
                pmd.setResolvedCondition(filter.clone());
            }
            catch (QueryMetadataException e) {
                throw e;
            }
            catch (TeiidException e) {
                throw new QueryMetadataException(QueryPlugin.Event.TEIID31129, e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31129, new Object[]{entry.getKey(), fullName}));
            }
        } else {
            filter = (Criteria)filter.clone();
        }
        return filter;
    }

    public static Command checkUpdateRowBasedFilters(ProcedureContainer container, Command procedure, RelationalPlanner planner) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException, QueryResolverException {
        Update update;
        Collection<ElementSymbol> elems;
        if (container instanceof StoredProcedure) {
            return procedure;
        }
        Criteria filter = RowBasedSecurityHelper.getRowBasedFilters(planner.metadata, container.getGroup(), planner.context, false);
        if (filter == null) {
            return procedure;
        }
        RowBasedSecurityHelper.addFilter(container, planner, filter);
        if (procedure != null) {
            return procedure;
        }
        filter = RowBasedSecurityHelper.getRowBasedFilters(planner.metadata, container.getGroup(), planner.context, true);
        if (filter == null) {
            return procedure;
        }
        HashMap<ElementSymbol, Expression> values = null;
        boolean compensate = false;
        if (container instanceof Update) {
            elems = ElementCollectorVisitor.getElements((LanguageObject)filter, true);
            values = new HashMap<ElementSymbol, Expression>();
            update = (Update)container;
            boolean constraintApplicable = false;
            for (SetClause clause : update.getChangeList().getClauses()) {
                if (!elems.contains(clause.getSymbol())) continue;
                constraintApplicable = true;
                if (EvaluatableVisitor.isFullyEvaluatable(clause.getValue(), true)) {
                    values.put(clause.getSymbol(), clause.getValue());
                    continue;
                }
                if (compensate || EvaluatableVisitor.isFullyEvaluatable(clause.getValue(), false)) continue;
                compensate = true;
            }
            if (!constraintApplicable) {
                return procedure;
            }
        } else if (container instanceof Insert) {
            Insert insert = (Insert)container;
            if (insert.getQueryExpression() == null) {
                values = new HashMap();
                List<ElementSymbol> insertElmnts = ResolverUtil.resolveElementsInGroup(insert.getGroup(), planner.metadata);
                for (ElementSymbol elementSymbol : insertElmnts) {
                    Expression value = null;
                    int index = insert.getVariables().indexOf(elementSymbol);
                    if (index == -1) {
                        value = ResolverUtil.getDefault(elementSymbol, planner.metadata);
                        values.put(elementSymbol, value);
                        continue;
                    }
                    value = (Expression)insert.getValues().get(index);
                    if (!EvaluatableVisitor.isFullyEvaluatable(value, true)) continue;
                    values.put(elementSymbol, value);
                }
            } else {
                RowBasedSecurityHelper.validateAndPlanSubqueries(filter, container.getGroup(), planner);
                insert.setConstraint(filter);
            }
        }
        if (values != null) {
            if (!values.isEmpty()) {
                ExpressionMappingVisitor.mapExpressions(filter, values);
                filter = QueryRewriter.rewriteCriteria(filter, planner.context, planner.metadata);
            }
            if (filter != QueryRewriter.TRUE_CRITERIA) {
                if (filter == QueryRewriter.FALSE_CRITERIA || filter == QueryRewriter.UNKNOWN_CRITERIA) {
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31130, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31130, new Object[]{container}));
                }
                if (container instanceof Update) {
                    elems = ElementCollectorVisitor.getElements((LanguageObject)filter, true);
                    if (!Collections.disjoint(elems, (update = (Update)container).getChangeList().getClauseMap().keySet())) {
                        RowBasedSecurityHelper.validateAndPlanSubqueries(filter, container.getGroup(), planner);
                        update.setConstraint(filter);
                        if (compensate) {
                            try {
                                planner.validateRowProcessing(container);
                            }
                            catch (QueryPlannerException e) {
                                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31131, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31131, new Object[]{container}));
                            }
                            return QueryRewriter.createUpdateProcedure((Update)container, planner.metadata, planner.context);
                        }
                    }
                } else if (container instanceof Insert) {
                    RowBasedSecurityHelper.validateAndPlanSubqueries(filter, container.getGroup(), planner);
                    ((Insert)container).setConstraint(filter);
                }
            }
        }
        return procedure;
    }

    private static void validateAndPlanSubqueries(LanguageObject object, GroupSymbol gs, RelationalPlanner planner) throws QueryValidatorException, QueryPlannerException, QueryMetadataException, TeiidComponentException {
        List<SubqueryContainer<?>> subqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(object);
        if (subqueries.isEmpty()) {
            return;
        }
        Set<GroupSymbol> groups = Collections.singleton(gs);
        planner.planSubqueries(groups, null, subqueries, true);
        LinkedList<Reference> refs = new LinkedList<Reference>();
        CorrelatedReferenceCollectorVisitor.collectReferences(object, groups, refs, planner.metadata);
        if (!refs.isEmpty()) {
            throw new QueryValidatorException((BundleUtil.Event)QueryPlugin.Event.TEIID31142, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31142, new Object[]{object, gs}));
        }
    }

    private static void addFilter(ProcedureContainer container, RelationalPlanner planner, Criteria filter) {
        if (container instanceof FilteredCommand) {
            FilteredCommand fc = (FilteredCommand)((Object)container);
            if (fc.getCriteria() == null) {
                fc.setCriteria(filter);
            } else {
                fc.setCriteria(QueryRewriter.optimizeCriteria(new CompoundCriteria(Arrays.asList(fc.getCriteria(), filter)), planner.metadata));
            }
        }
    }

    public static void checkConstraints(Command atomicCommand, Evaluator eval) throws ExpressionEvaluationException, BlockedException, TeiidComponentException, QueryProcessingException {
        Criteria constraint = null;
        HashMap<ElementSymbol, Expression> values = null;
        int rows = -1;
        if (atomicCommand instanceof Update) {
            Update update = (Update)atomicCommand;
            constraint = update.getConstraint();
            if (constraint != null) {
                values = new HashMap<ElementSymbol, Expression>();
                for (SetClause clause : update.getChangeList().getClauses()) {
                    values.put(clause.getSymbol(), clause.getValue());
                    if (rows != -1) continue;
                    rows = RowBasedSecurityHelper.getMultiValuedSize(clause.getValue());
                }
            }
        } else if (atomicCommand instanceof Insert) {
            Insert insert = (Insert)atomicCommand;
            constraint = insert.getConstraint();
            if (constraint != null) {
                values = new HashMap();
                if (insert.getQueryExpression() == null) {
                    for (int i = 0; i < insert.getVariables().size(); ++i) {
                        ElementSymbol symbol = insert.getVariables().get(i);
                        Expression value = (Expression)insert.getValues().get(i);
                        values.put(symbol, value);
                        if (rows != -1) continue;
                        rows = RowBasedSecurityHelper.getMultiValuedSize(value);
                    }
                }
            }
        } else if (atomicCommand instanceof BatchedUpdateCommand) {
            BatchedUpdateCommand buc = (BatchedUpdateCommand)atomicCommand;
            List<Command> commands = buc.getUpdateCommands();
            for (Command command : commands) {
                RowBasedSecurityHelper.checkConstraints(command, eval);
            }
            return;
        }
        if (constraint == null) {
            return;
        }
        if (rows != -1) {
            HashMap<ElementSymbol, Expression> currentValues = new HashMap<ElementSymbol, Expression>();
            for (int i = 0; i < rows; ++i) {
                currentValues.clear();
                for (Map.Entry<ElementSymbol, Expression> entry : values.entrySet()) {
                    ElementSymbol symbol = entry.getKey();
                    Expression value = entry.getValue();
                    if (value instanceof Constant && ((Constant)value).isMultiValued()) {
                        Object obj = ((List)((Constant)value).getValue()).get(i);
                        value = new Constant(obj, symbol.getType());
                    }
                    currentValues.put(symbol, value);
                }
                RowBasedSecurityHelper.evaluateConstraint(atomicCommand, eval, constraint, currentValues);
            }
        } else {
            RowBasedSecurityHelper.evaluateConstraint(atomicCommand, eval, constraint, values);
        }
    }

    private static void evaluateConstraint(Command atomicCommand, Evaluator eval, Criteria constraint, Map<ElementSymbol, Expression> values) throws BlockedException, TeiidComponentException, QueryProcessingException {
        Criteria clone = (Criteria)constraint.clone();
        ExpressionMappingVisitor.mapExpressions(clone, values);
        try {
            if (!eval.evaluate(clone, null)) {
                throw new QueryProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31130, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31130, new Object[]{atomicCommand}));
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new QueryProcessingException(QueryPlugin.Event.TEIID31130, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31130, new Object[]{atomicCommand}));
        }
    }

    private static int getMultiValuedSize(Expression value) {
        if (value instanceof Constant && ((Constant)value).isMultiValued()) {
            return ((List)((Constant)value).getValue()).size();
        }
        return 1;
    }

    static class RecontextVisitor
    extends ExpressionMappingVisitor {
        private final GroupSymbol group;
        private final String definition;

        RecontextVisitor(GroupSymbol group) {
            super(null);
            this.group = group;
            this.definition = group.getDefinition();
        }

        @Override
        public Expression replaceExpression(Expression element) {
            ElementSymbol es;
            if (element instanceof ElementSymbol && (es = (ElementSymbol)element).getGroupSymbol().getDefinition() == null && es.getGroupSymbol().getName().equalsIgnoreCase(this.definition)) {
                es.getGroupSymbol().setDefinition(this.group.getDefinition());
                es.getGroupSymbol().setName(this.group.getName());
            }
            return element;
        }
    }
}

