/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.xa.XATransactionException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.TranslatorBatchException;

public class BatchedUpdatePlan
extends ProcessorPlan {
    private ProcessorPlan[] updatePlans;
    private boolean[] planOpened;
    private boolean[] startTxn;
    private TransactionContext[] planContexts;
    private List[] updateCounts;
    private int planIndex = 0;
    private int commandIndex = 0;
    private List<VariableContext> contexts;
    private boolean singleResult;

    public BatchedUpdatePlan(List<? extends ProcessorPlan> childPlans, int commandsInBatch, List<VariableContext> contexts, boolean singleResult) {
        this.updatePlans = childPlans.toArray(new ProcessorPlan[childPlans.size()]);
        this.planOpened = new boolean[this.updatePlans.length];
        this.startTxn = new boolean[this.updatePlans.length];
        this.planContexts = new TransactionContext[this.updatePlans.length];
        this.updateCounts = new List[commandsInBatch];
        this.contexts = contexts;
        this.singleResult = singleResult;
    }

    @Override
    public BatchedUpdatePlan clone() {
        ArrayList<ProcessorPlan> clonedPlans = new ArrayList<ProcessorPlan>(this.updatePlans.length);
        clonedPlans.add(this.updatePlans[0].clone());
        for (int i = 1; i < this.updatePlans.length; ++i) {
            if (this.contexts == null) {
                clonedPlans.add(this.updatePlans[1].clone());
                continue;
            }
            clonedPlans.add((ProcessorPlan)clonedPlans.get(0));
        }
        BatchedUpdatePlan clone = new BatchedUpdatePlan(clonedPlans, this.updateCounts.length, this.contexts, this.singleResult);
        return clone;
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        context = context.clone();
        context.setVariableContext(new VariableContext());
        this.setContext(context);
        for (int i = 0; i < this.getPlanCount(); ++i) {
            this.updatePlans[i].initialize(context, dataMgr, bufferMgr);
        }
    }

    @Override
    public List getOutputElements() {
        return Command.getUpdateCommandSymbol();
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        try {
            this.openPlan();
        }
        catch (BlockedException e) {
            throw e;
        }
        catch (TeiidComponentException | TeiidProcessingException e) {
            if (this.singleResult) {
                throw e;
            }
            Throwable cause = e;
            if (e.getCause() instanceof TranslatorBatchException) {
                TranslatorBatchException tbe = (TranslatorBatchException)e.getCause();
                for (int i = 0; i < tbe.getUpdateCounts().length; ++i) {
                    this.updateCounts[this.commandIndex++] = Arrays.asList(this.updateCounts[i]);
                }
            }
            this.updateCounts = Arrays.copyOf(this.updateCounts, this.commandIndex);
            this.getContext().setBatchUpdateException(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        int i;
        while (this.planIndex < this.updatePlans.length && (this.getContext() == null || this.getContext().getBatchUpdateException() == null)) {
            try {
                if (!this.planOpened[this.planIndex]) {
                    this.openPlan();
                } else if (this.planContexts[this.planIndex] != null) {
                    this.getContext().getTransactionServer().resume(this.planContexts[this.planIndex]);
                }
                TupleBatch nextBatch = null;
                do {
                    nextBatch = this.updatePlans[this.planIndex].nextBatch();
                    List<List<?>> currentBatch = nextBatch.getTuples();
                    i = 0;
                    while (i < currentBatch.size()) {
                        this.updateCounts[this.commandIndex] = currentBatch.get(i);
                        ++i;
                        ++this.commandIndex;
                    }
                } while (!nextBatch.getTerminationFlag());
                this.updatePlans[this.planIndex].close();
                if (this.planContexts[this.planIndex] != null) {
                    TransactionService ts = this.getContext().getTransactionServer();
                    ts.commit(this.planContexts[this.planIndex]);
                    this.planContexts[this.planIndex] = null;
                }
                ++this.planIndex;
            }
            catch (BlockedException e) {
                throw e;
            }
            catch (TeiidComponentException | TeiidProcessingException e) {
                if (this.singleResult) {
                    throw e;
                }
                Throwable cause = e;
                if (e.getCause() instanceof TranslatorBatchException) {
                    TranslatorBatchException tbe = (TranslatorBatchException)e.getCause();
                    for (int i2 = 0; i2 < tbe.getUpdateCounts().length; ++i2) {
                        this.updateCounts[this.commandIndex++] = Arrays.asList(tbe.getUpdateCounts()[i2]);
                    }
                }
                this.updateCounts = Arrays.copyOf(this.updateCounts, this.commandIndex);
                this.getContext().setBatchUpdateException(cause);
            }
            finally {
                if (this.planIndex >= this.updatePlans.length || this.planContexts[this.planIndex] == null) continue;
                this.getContext().getTransactionServer().suspend(this.planContexts[this.planIndex]);
            }
        }
        if (this.singleResult) {
            long result = 0L;
            for (i = 0; i < this.updateCounts.length; ++i) {
                int value = (Integer)this.updateCounts[i].get(0);
                if (value == -3) {
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31199, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31198, new Object[0]));
                }
                if (value <= 0) continue;
                result += (long)value;
            }
            TupleBatch batch = new TupleBatch(1L, new List[]{Arrays.asList((int)Math.min(Integer.MAX_VALUE, result))});
            batch.setTerminationFlag(true);
            return batch;
        }
        TupleBatch batch = new TupleBatch(1L, this.updateCounts);
        batch.setTerminationFlag(true);
        return batch;
    }

    private void openPlan() throws TeiidComponentException, TeiidProcessingException {
        this.updatePlans[this.planIndex].reset();
        if (this.contexts != null && !this.contexts.isEmpty()) {
            CommandContext context = this.updatePlans[this.planIndex].getContext();
            VariableContext vc = context.getVariableContext();
            while (vc.getParentContext() != null) {
                vc = vc.getParentContext();
            }
            vc.clear();
            VariableContext currentValues = this.contexts.get(this.planIndex);
            vc.putAll(currentValues);
        }
        TransactionContext tc = this.getContext().getTransactionContext();
        if (this.startTxn[this.planIndex] && tc != null && tc.getTransactionType() == TransactionContext.Scope.NONE) {
            this.getContext().getTransactionServer().begin(tc);
            this.planContexts[this.planIndex] = tc;
        }
        this.updatePlans[this.planIndex].open();
        this.planOpened[this.planIndex] = true;
    }

    @Override
    public void close() throws TeiidComponentException {
        TransactionService ts = this.getContext().getTransactionServer();
        if (this.planIndex < this.updatePlans.length && this.planOpened[this.planIndex]) {
            try {
                this.updatePlans[this.planIndex].close();
            }
            catch (TeiidComponentException e) {
                LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)e.getMessage());
            }
            if (this.planContexts[this.planIndex] != null) {
                try {
                    ts.resume(this.planContexts[this.planIndex]);
                    ts.rollback(this.planContexts[this.planIndex]);
                }
                catch (XATransactionException e) {
                    LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)e.getMessage());
                }
                this.planContexts[this.planIndex] = null;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i < this.updatePlans.length; ++i) {
            this.updatePlans[i].reset();
            this.planOpened[i] = false;
            this.updateCounts[i] = null;
            this.planContexts[i] = null;
        }
        this.planIndex = 0;
        this.commandIndex = 0;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        for (int i = 0; i < this.getPlanCount(); ++i) {
            props.addProperty("Batch Plan " + i, this.updatePlans[i].getDescriptionProperties());
        }
        return props;
    }

    public String toString() {
        StringBuffer val = new StringBuffer("BatchedUpdatePlan {\n");
        for (int i = 0; i < this.getPlanCount(); ++i) {
            val.append(this.updatePlans[i]).append("\n");
        }
        val.append("}\n");
        return val.toString();
    }

    private int getPlanCount() {
        return this.contexts != null ? 1 : this.updatePlans.length;
    }

    public List getUpdatePlans() {
        return Arrays.asList(this.updatePlans);
    }

    @Override
    public Boolean requiresTransaction(boolean transactionalReads) {
        if (!this.singleResult) {
            for (int i = 0; i < this.updatePlans.length; ++i) {
                Boolean requires = this.updatePlans[i].requiresTransaction(transactionalReads);
                if (requires == null || !requires.booleanValue()) continue;
                this.startTxn[i] = true;
            }
            return false;
        }
        boolean possible = false;
        for (int i = 0; i < this.updatePlans.length; ++i) {
            Boolean requires = this.updatePlans[i].requiresTransaction(transactionalReads);
            if (requires != null) {
                if (!requires.booleanValue()) continue;
                return true;
            }
            if (possible) {
                return true;
            }
            possible = true;
        }
        if (possible) {
            return null;
        }
        return false;
    }

    public void setSingleResult(boolean singleResult) {
        this.singleResult = singleResult;
    }
}

