/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.query.util.CommandContext;

public class TestFunction {
    @Before
    public void setUp() {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-5"));
    }

    @After
    public void tearDown() {
        TimestampWithTimezone.resetCalendar(null);
    }

    private void helpConcat(String s1, String s2, Object expected) {
        String actual = FunctionMethods.concat((String)s1, (String)s2);
        Assert.assertEquals((String)("concat(" + s1 + ", " + s2 + ") failed."), (Object)expected, (Object)actual);
    }

    public static void helpTrim(String str, boolean left, Object expected) {
        Object actual = null;
        if (left) {
            actual = FunctionMethods.leftTrim((String)str);
            Assert.assertEquals((String)("ltrim(" + str + ") failed."), (Object)expected, (Object)actual);
        } else {
            actual = FunctionMethods.rightTrim((String)str);
            Assert.assertEquals((String)("rtrim(" + str + ") failed."), (Object)expected, (Object)actual);
        }
    }

    public static void helpLeft(String str, int count, Object expected) throws FunctionExecutionException {
        Object actual = FunctionMethods.left((String)str, (Integer)new Integer(count));
        Assert.assertEquals((String)("left(" + str + ") failed."), (Object)expected, (Object)actual);
    }

    public static void helpRight(String str, int count, Object expected) throws FunctionExecutionException {
        Object actual = FunctionMethods.right((String)str, (Integer)new Integer(count));
        Assert.assertEquals((String)("right(" + str + ") failed."), (Object)expected, (Object)actual);
    }

    public static void helpReplace(String str, String sub, String replace, Object expected) {
        Object actual = FunctionMethods.replace((String)str, (String)sub, (String)replace);
        Assert.assertEquals((String)("replace(" + str + "," + sub + "," + replace + ") failed."), (Object)expected, (Object)actual);
    }

    public static void helpSubstring(String str, Integer start, Integer length, Object expected) {
        Object actual = FunctionMethods.substring((String)str, (Integer)start, (Integer)length);
        Assert.assertEquals((String)("substring(" + str + "," + start + "," + length + ") failed."), (Object)expected, (Object)actual);
    }

    public static void helpSubstring(String str, Integer start, Object expected) {
        Object actual = FunctionMethods.substring((String)str, (Integer)start);
        Assert.assertEquals((String)("substring(" + str + "," + start + ") failed."), (Object)expected, (Object)actual);
    }

    public static void helpConvert(Object src, String tgtType, Object expected) throws FunctionExecutionException {
        Object actual = FunctionMethods.convert(null, (Object)src, (String)tgtType);
        Assert.assertEquals((String)("convert(" + src + "," + tgtType + ") failed."), (Object)expected, (Object)actual);
    }

    public static void helpConvertFail(Object src, String tgtType) {
        try {
            FunctionMethods.convert(null, (Object)src, (String)tgtType);
            Assert.fail((String)("Expected convert(" + src + "," + tgtType + ") to throw FunctionExecutionException, but it did not."));
        }
        catch (FunctionExecutionException functionExecutionException) {
            // empty catch block
        }
    }

    public static void helpTestInitCap(String input, String expected) {
        String actual = (String)FunctionMethods.initCap((String)input);
        Assert.assertEquals((String)"Didn't get expected result from initCap", (Object)expected, (Object)actual);
    }

    public static void helpTestLpad(String input, int length, String expected) throws FunctionExecutionException {
        String actual = (String)FunctionMethods.lpad((String)input, (Integer)new Integer(length));
        Assert.assertEquals((String)"Didn't get expected result from lpad", (Object)expected, (Object)actual);
    }

    public static void helpTestLpad(String input, int length, String pad, String expected) throws FunctionExecutionException {
        String actual = (String)FunctionMethods.lpad((String)input, (Integer)new Integer(length), (String)pad);
        Assert.assertEquals((String)"Didn't get expected result from lpad", (Object)expected, (Object)actual);
    }

    public static void helpTestRpad(String input, int length, String expected) throws FunctionExecutionException {
        String actual = (String)FunctionMethods.rpad((String)input, (Integer)new Integer(length));
        Assert.assertEquals((String)"Didn't get expected result from rpad", (Object)expected, (Object)actual);
    }

    public static void helpTestRpad(String input, int length, String c, String expected) throws FunctionExecutionException {
        String actual = (String)FunctionMethods.rpad((String)input, (Integer)new Integer(length), (String)c);
        Assert.assertEquals((String)"Didn't get expected result from rpad", (Object)expected, (Object)actual);
    }

    public static void helpTestTranslate(String input, String src, String dest, String expected) throws FunctionExecutionException {
        String actual = (String)FunctionMethods.translate((String)input, (String)src, (String)dest);
        Assert.assertEquals((String)"Didn't get expected result from translate", (Object)expected, (Object)actual);
    }

    public static void helpTestLocate(String locateString, String input, int expectedLocation) {
        Integer location = (Integer)FunctionMethods.locate((String)locateString, (String)input);
        int actualLocation = location;
        Assert.assertEquals((String)"Didn't get expected result from locate", (long)expectedLocation, (long)actualLocation);
    }

    public static void helpTestEndssWith(String locateString, String input, Boolean expected) {
        Boolean actual = (Boolean)FunctionMethods.endsWith((String)locateString, (String)input);
        Assert.assertEquals((String)"Didn't get expected result from startsWith", (Object)expected, (Object)actual);
    }

    public static void helpTestLocate(String locateString, String input, Integer start, int expectedLocation) {
        Integer location = (Integer)FunctionMethods.locate((String)locateString, (String)input, (Integer)start);
        int actualLocation = location;
        Assert.assertEquals((String)"Didn't get expected result from locate", (long)expectedLocation, (long)actualLocation);
    }

    public static void helpTestRound(Integer number, Integer places, Object expected) {
        Integer actual = FunctionMethods.round((int)number, (int)places);
        Assert.assertEquals((String)("round(" + number + "," + places + ") failed."), (Object)expected, (Object)actual);
    }

    public static void helpTestRound(Float number, Integer places, Object expected) {
        Float actual = Float.valueOf(FunctionMethods.round((float)number.floatValue(), (int)places));
        Assert.assertEquals((String)("round(" + number + "," + places + ") failed."), (Object)expected, (Object)actual);
    }

    public static void helpTestRound(Double number, Integer places, Object expected) {
        Double actual = FunctionMethods.round((double)number, (int)places);
        Assert.assertEquals((String)("round(" + number + "," + places + ") failed."), (Object)expected, (Object)actual);
    }

    public static void helpTestRound(BigDecimal number, Integer places, Object expected) {
        BigDecimal actual = FunctionMethods.round((BigDecimal)number, (int)places);
        Assert.assertEquals((String)("round(" + number + "," + places + ") failed."), (Object)expected, (Object)actual);
    }

    public static void helpTestHour1(String timeStr, int expected) {
        Time t = Time.valueOf(timeStr);
        Object actual = FunctionMethods.hour((java.util.Date)t);
        Assert.assertEquals((String)("hour(" + t + ") failed"), (Object)new Integer(expected), (Object)actual);
    }

    public static void helpTestHour2(String timestampStr, int expected) {
        Timestamp ts = Timestamp.valueOf(timestampStr);
        Object actual = FunctionMethods.hour((java.util.Date)ts);
        Assert.assertEquals((String)("hour(" + ts + ") failed"), (Object)new Integer(expected), (Object)actual);
    }

    public static void helpTestTimestampCreate(Date date, Time time, String expected) {
        Object actual = FunctionMethods.timestampCreate((Date)date, (Time)time);
        Assert.assertEquals((String)("timestampCreate(" + date + ", " + time + ") failed"), (Object)expected, (Object)actual.toString());
    }

    public static void helpTestTimestampDiff(String intervalType, Timestamp timeStamp1, Timestamp timeStamp2, Long expected) throws FunctionExecutionException {
        Long actual = FunctionMethods.timestampDiff((String)intervalType, (Timestamp)timeStamp1, (Timestamp)timeStamp2);
        Assert.assertEquals((String)("timestampDiff(" + intervalType + ", " + timeStamp1 + ", " + timeStamp2 + ") failed"), (Object)expected, (Object)actual);
        Long expected2 = new Long(0L - expected);
        Long actual2 = FunctionMethods.timestampDiff((String)intervalType, (Timestamp)timeStamp2, (Timestamp)timeStamp1);
        Assert.assertEquals((String)("timestampDiff(" + intervalType + ", " + timeStamp2 + ", " + timeStamp1 + ") failed"), (Object)expected2, (Object)actual2);
    }

    public static void helpTestParseTimestamp(String tsStr, String format, String expected) throws FunctionExecutionException {
        Timestamp actual = FunctionMethods.parseTimestamp((CommandContext)new CommandContext(), (String)tsStr, (String)format);
        Assert.assertEquals((String)("parseTimestamp(" + tsStr + ", " + format + ") failed"), (Object)expected.toString(), (Object)new Constant((Object)actual).toString());
    }

    @Test
    public void testConcat1() throws Exception {
        this.helpConcat("x", "y", "xy");
    }

    @Test
    public void testConcat5() throws Exception {
        this.helpConcat("", "", "");
    }

    @Test
    public void testTrim3() throws Exception {
        TestFunction.helpTrim("", true, "");
    }

    @Test
    public void testTrim4() throws Exception {
        TestFunction.helpTrim("", false, "");
    }

    @Test
    public void testTrim5() throws Exception {
        TestFunction.helpTrim("x", true, "x");
    }

    @Test
    public void testTrim6() throws Exception {
        TestFunction.helpTrim("x", false, "x");
    }

    @Test
    public void testTrim7() throws Exception {
        TestFunction.helpTrim("  x", true, "x");
    }

    @Test
    public void testTrim8() throws Exception {
        TestFunction.helpTrim(" x ", true, "x ");
    }

    @Test
    public void testTrim9() throws Exception {
        TestFunction.helpTrim("x  ", false, "x");
    }

    @Test
    public void testTrim10() throws Exception {
        TestFunction.helpTrim(" x x ", false, " x x");
    }

    @Test
    public void testTrim11() throws Exception {
        TestFunction.helpTrim("  ", true, "");
    }

    @Test
    public void testTrim12() throws Exception {
        TestFunction.helpTrim("  ", false, "");
    }

    @Test
    public void testLeft1() throws Exception {
        TestFunction.helpLeft("abcd", 0, "");
    }

    @Test
    public void testLeft2() throws Exception {
        TestFunction.helpLeft("abcd", 3, "abc");
    }

    @Test
    public void testLeft4() throws Exception {
        TestFunction.helpLeft("", 0, "");
    }

    @Test
    public void testLeft5() throws Exception {
        TestFunction.helpLeft("", 2, "");
    }

    @Test
    public void testLeft6() throws Exception {
        TestFunction.helpLeft("abcd", 5, "abcd");
    }

    @Test
    public void testLeft7() throws Exception {
        TestFunction.helpLeft("abcd", 4, "abcd");
    }

    @Test
    public void testRight1() throws Exception {
        TestFunction.helpRight("abcd", 0, "");
    }

    @Test
    public void testRight2() throws Exception {
        TestFunction.helpRight("abcd", 3, "bcd");
    }

    @Test
    public void testRight4() throws Exception {
        TestFunction.helpRight("", 0, "");
    }

    @Test
    public void testRight5() throws Exception {
        TestFunction.helpRight("", 2, "");
    }

    @Test
    public void testRight6() throws Exception {
        TestFunction.helpRight("abcd", 5, "abcd");
    }

    @Test
    public void testRight7() throws Exception {
        TestFunction.helpRight("abcd", 4, "abcd");
    }

    @Test
    public void testSubstring1() throws Exception {
        TestFunction.helpSubstring("abc", new Integer(1), new Integer(1), "a");
    }

    @Test
    public void testSubstring2() throws Exception {
        TestFunction.helpSubstring("abc", new Integer(2), new Integer(2), "bc");
    }

    @Test
    public void testSubstring3() throws Exception {
        TestFunction.helpSubstring("abc", new Integer(3), new Integer(3), "c");
    }

    @Test
    public void testSubstring4() throws Exception {
        TestFunction.helpSubstring("abc", new Integer(3), new Integer(0), "");
    }

    @Test
    public void testSubstring6() throws Exception {
        TestFunction.helpSubstring("abc", new Integer(3), "c");
    }

    @Test
    public void testSubstring7() throws Exception {
        TestFunction.helpSubstring("abc", new Integer(1), "abc");
    }

    @Test
    public void testSubstring8() throws Exception {
        TestFunction.helpSubstring("abc", new Integer(-1), "c");
    }

    @Test
    public void testSubstring9() throws Exception {
        TestFunction.helpSubstring("abc", new Integer(-3), "abc");
    }

    @Test
    public void testSubstring10() throws Exception {
        TestFunction.helpSubstring("abc", new Integer(-4), null);
    }

    @Test
    public void testSubstring11() throws Exception {
        TestFunction.helpSubstring("abc", new Integer(-1), new Integer(2), "c");
    }

    @Test
    public void testSubstring12() throws Exception {
        TestFunction.helpSubstring("abc", new Integer(-3), new Integer(2), "ab");
    }

    @Test
    public void testSubstring13() throws Exception {
        TestFunction.helpSubstring("abc", new Integer(0), new Integer(2), "ab");
    }

    @Test
    public void testReplace1() throws Exception {
        TestFunction.helpReplace("", "x", "y", "");
    }

    @Test
    public void testReplace2() throws Exception {
        TestFunction.helpReplace("", "", "z", "");
    }

    @Test
    public void testReplace3() throws Exception {
        TestFunction.helpReplace("x", "x", "y", "y");
    }

    @Test
    public void testReplace4() throws Exception {
        TestFunction.helpReplace("xx", "x", "y", "yy");
    }

    @Test
    public void testReplace5() throws Exception {
        TestFunction.helpReplace("x x", "x", "y", "y y");
    }

    @Test
    public void testReplace6() throws Exception {
        TestFunction.helpReplace("x x", "x", "", " ");
    }

    @Test
    public void testReplace7() throws Exception {
        TestFunction.helpReplace("x x", "x", "yz", "yz yz");
    }

    @Test
    public void testReplace8() throws Exception {
        TestFunction.helpReplace("xx xx", "xx", "y", "y y");
    }

    @Test
    public void testConvertStringBoolean1() throws Exception {
        TestFunction.helpConvert("true", "boolean", Boolean.TRUE);
    }

    @Test
    public void testConvertStringBoolean2() throws Exception {
        TestFunction.helpConvert("false", "boolean", Boolean.FALSE);
    }

    @Test
    public void testConvertStringBoolean3() throws Exception {
        TestFunction.helpConvert("x", "boolean", Boolean.TRUE);
    }

    @Test
    public void testConvertStringBoolean4() throws Exception {
        TestFunction.helpConvert("TrUe", "boolean", Boolean.TRUE);
    }

    @Test
    public void testConvertStringBoolean5() throws Exception {
        TestFunction.helpConvert("FAlsE", "boolean", Boolean.FALSE);
    }

    @Test
    public void testConvertStringChar1() throws Exception {
        TestFunction.helpConvert("a", "char", new Character('a'));
    }

    @Test
    public void testConvertStringChar2() throws Exception {
        TestFunction.helpConvert("xx", "char", new Character('x'));
    }

    @Test
    public void testConvertStringByte1() throws Exception {
        TestFunction.helpConvert("5", "byte", new Byte(5));
    }

    @Test
    public void testConvertStringShort1() throws Exception {
        TestFunction.helpConvert("5", "short", new Short(5));
    }

    @Test
    public void testConvertStringInteger1() throws Exception {
        TestFunction.helpConvert("5", "integer", new Integer(5));
    }

    @Test
    public void testConvertStringInteger2() throws Exception {
        TestFunction.helpConvertFail("21474836471", "integer");
    }

    @Test
    public void testConvertStringInteger3() throws Exception {
        TestFunction.helpConvertFail("5.99", "integer");
    }

    @Test
    public void testConvertStringLong1() throws Exception {
        TestFunction.helpConvert("5", "long", new Long(5L));
    }

    @Test
    public void testConvertStringBigInteger1() throws Exception {
        TestFunction.helpConvert("5", "biginteger", new BigInteger("5"));
    }

    @Test
    public void testConvertStringBigInteger2() throws Exception {
        String bigInt = "2147483647111";
        TestFunction.helpConvert(bigInt, "biginteger", new BigInteger(bigInt));
    }

    @Test
    public void testConvertStringFloat1() throws Exception {
        TestFunction.helpConvert("5.2", "float", new Float(5.2f));
    }

    @Test
    public void testConvertStringDouble1() throws Exception {
        TestFunction.helpConvert("5.2", "double", new Double(5.2));
    }

    @Test
    public void testConvertStringBigDecimal1() throws Exception {
        TestFunction.helpConvert("5.2", "bigdecimal", new BigDecimal("5.2"));
    }

    @Test
    public void testConvertDoubleBigInteger() throws Exception {
        TestFunction.helpConvert(new Double(1.0), "biginteger", new BigInteger("1"));
    }

    @Test
    public void testConvertFloatBigInteger() throws Exception {
        TestFunction.helpConvert(new Float(1.0), "biginteger", new BigInteger("1"));
    }

    @Test
    public void testConvertBigDecimalBigInteger() throws Exception {
        TestFunction.helpConvert(new BigDecimal("1.0"), "biginteger", new BigInteger("1"));
    }

    @Test
    public void testConvertDoubleLong() throws Exception {
        TestFunction.helpConvert(new Double(1.0), "long", new Long("1"));
    }

    @Test
    public void testConvertTimestampString() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)103, (int)7, (int)22, (int)22, (int)43, (int)53, (int)3333333);
        TestFunction.helpConvert(ts, "string", "2003-08-22 22:43:53.003333333");
    }

    @Test
    public void testAscii2() throws Exception {
        Integer code = FunctionMethods.ascii((String)" ");
        Assert.assertEquals((String)"Didn't get expected code", (long)32L, (long)code.intValue());
    }

    @Test
    public void testAscii4() throws Exception {
        Assert.assertNull((Object)FunctionMethods.ascii((String)""));
    }

    @Test
    public void testAscii5() throws Exception {
        Integer code = FunctionMethods.ascii((String)"abc");
        Assert.assertEquals((String)"Didn't get expected code", (long)97L, (long)code.intValue());
    }

    @Test
    public void testChr1() throws Exception {
        Character chr = (Character)FunctionMethods.chr((int)new Integer(32));
        Assert.assertEquals((String)"Didn't get expected character", (long)32L, (long)chr.charValue());
    }

    @Test
    public void testNvl1() throws Exception {
        String ret = (String)FunctionMethods.ifnull((Object)"x", (Object)"y");
        Assert.assertEquals((String)"Didn't get expected value", (Object)"x", (Object)ret);
    }

    @Test
    public void testNvl2() throws Exception {
        String ret = (String)FunctionMethods.ifnull(null, (Object)"y");
        Assert.assertEquals((String)"Didn't get expected value", (Object)"y", (Object)ret);
    }

    @Test
    public void testNvl3() throws Exception {
        String ret = (String)FunctionMethods.ifnull(null, null);
        Assert.assertEquals((String)"Didn't get expected value", null, (Object)ret);
    }

    @Test
    public void testInitCap2() throws Exception {
        TestFunction.helpTestInitCap("abc", "Abc");
    }

    @Test
    public void testInitCap3() throws Exception {
        TestFunction.helpTestInitCap(" test    some\tweird\rspaces\nhere", " Test    Some\tWeird\rSpaces\nHere");
    }

    @Test
    public void testInitCap4() throws Exception {
        TestFunction.helpTestInitCap("x y ", "X Y ");
    }

    @Test
    public void testInitCap5() throws Exception {
        TestFunction.helpTestInitCap("cows are FUN", "Cows Are Fun");
    }

    @Test
    public void testLpad1() throws Exception {
        TestFunction.helpTestLpad("x", 4, "   x");
    }

    @Test
    public void testLpad3() throws Exception {
        TestFunction.helpTestLpad("x", 1, "x");
    }

    @Test
    public void testLpad4() throws Exception {
        TestFunction.helpTestLpad("xx", 1, "x");
    }

    @Test
    public void testLpad5() throws Exception {
        TestFunction.helpTestLpad("", 4, "x", "xxxx");
    }

    @Test
    public void testLpad6() throws Exception {
        TestFunction.helpTestLpad("10", 6, "0", "000010");
    }

    @Test
    public void testLpad7() throws Exception {
        TestFunction.helpTestLpad("x", 4, "yq", "qyqx");
    }

    @Test
    public void testRpad1() throws Exception {
        TestFunction.helpTestRpad("x", 4, "x   ");
    }

    @Test
    public void testRpad3() throws Exception {
        TestFunction.helpTestRpad("x", 1, "x");
    }

    @Test
    public void testRpad4() throws Exception {
        TestFunction.helpTestRpad("xx", 1, "x");
    }

    @Test
    public void testRpad5() throws Exception {
        TestFunction.helpTestRpad("", 4, "x", "xxxx");
    }

    @Test
    public void testRpad6() throws Exception {
        TestFunction.helpTestRpad("10", 6, "0", "100000");
    }

    @Test
    public void testTranslate1() throws Exception {
        TestFunction.helpTestTranslate("This is my test", "ty", "yt", "This is mt yesy");
    }

    @Test
    public void testTranslate2() throws Exception {
        TestFunction.helpTestTranslate("", "ty", "yt", "");
    }

    @Test
    public void testTranslate3() throws Exception {
        try {
            FunctionMethods.translate((String)"test", (String)"x", (String)"yz");
            Assert.fail((String)"Did not get expected exception on differing src and dest lengths");
        }
        catch (FunctionExecutionException functionExecutionException) {
            // empty catch block
        }
    }

    @Test
    public void testTranslate4() throws Exception {
        TestFunction.helpTestTranslate("test", "xy", "ab", "test");
    }

    @Test
    public void testLocate1() throws Exception {
        TestFunction.helpTestLocate(",", "Metamatrix, John Quincy", 11);
    }

    @Test
    public void testLocate2() throws Exception {
        TestFunction.helpTestLocate(" ", "Metamatrix, John Quincy", 12);
    }

    @Test
    public void testLocate3() throws Exception {
        TestFunction.helpTestLocate("x", "xx", 1);
    }

    @Test
    public void testLocate4() throws Exception {
        TestFunction.helpTestLocate("y", "xx", 0);
    }

    @Test
    public void testLocate5() throws Exception {
        TestFunction.helpTestLocate("b", "abab", 3, 4);
    }

    @Test
    public void testLocate6() throws Exception {
        TestFunction.helpTestLocate("z", "abab", 0, 0);
    }

    @Test
    public void testLocate7() throws Exception {
        TestFunction.helpTestLocate("z", "abab", null, 0);
    }

    @Test
    public void testLocate8() throws Exception {
        TestFunction.helpTestLocate("z", "abab", -1, 0);
    }

    @Test
    public void testEndsWith1() throws Exception {
        TestFunction.helpTestEndssWith("z", "abab", false);
    }

    @Test
    public void testEndsWith2() throws Exception {
        TestFunction.helpTestEndssWith("b", "abab", true);
    }

    @Test
    public void testBitand() throws Exception {
        Integer result = (Integer)FunctionMethods.bitand((int)new Integer(4095), (int)new Integer(240));
        Assert.assertNotNull((String)"Result should not be null", (Object)result);
        Assert.assertEquals((String)"result should be 0x0F0", (long)240L, (long)result.intValue());
    }

    @Test
    public void testBitor() throws Exception {
        Integer result = (Integer)FunctionMethods.bitor((int)new Integer(4095), (int)new Integer(240));
        Assert.assertNotNull((String)"Result should not be null", (Object)result);
        Assert.assertEquals((String)"result should be 0xFFF", (long)4095L, (long)result.intValue());
    }

    @Test
    public void testBitxor() throws Exception {
        Integer result = (Integer)FunctionMethods.bitxor((int)new Integer(4095), (int)new Integer(240));
        Assert.assertNotNull((String)"Result should not be null", (Object)result);
        Assert.assertEquals((String)"result should be 0xF0F", (long)3855L, (long)result.intValue());
    }

    @Test
    public void testBitnot() throws Exception {
        Integer result = FunctionMethods.bitnot((int)3855);
        Assert.assertNotNull((String)"Result should not be null", (Object)result);
        Assert.assertEquals((String)"result should be 0xFFFFF0F0", (long)-3856L, (long)result.intValue());
    }

    @Test
    public void testRoundInteger1() throws Exception {
        TestFunction.helpTestRound(new Integer(1928), new Integer(0), (Object)new Integer(1928));
    }

    @Test
    public void testRoundInteger2() throws Exception {
        TestFunction.helpTestRound(new Integer(1928), new Integer(-1), (Object)new Integer(1930));
    }

    @Test
    public void testRoundInteger3() throws Exception {
        TestFunction.helpTestRound(new Integer(1928), new Integer(-2), (Object)new Integer(1900));
    }

    @Test
    public void testRoundInteger4() throws Exception {
        TestFunction.helpTestRound(new Integer(1928), new Integer(-3), (Object)new Integer(2000));
    }

    @Test
    public void testRoundInteger5() throws Exception {
        TestFunction.helpTestRound(new Integer(1928), new Integer(-4), (Object)new Integer(0));
    }

    @Test
    public void testRoundInteger6() throws Exception {
        TestFunction.helpTestRound(new Integer(1928), new Integer(-5), (Object)new Integer(0));
    }

    @Test
    public void testRoundInteger7() throws Exception {
        TestFunction.helpTestRound(new Integer(1928), new Integer(1), (Object)new Integer(1928));
    }

    @Test
    public void testRoundFloat1() throws Exception {
        TestFunction.helpTestRound(new Float(123.456f), new Integer(4), (Object)new Float(123.456f));
    }

    @Test
    public void testRoundFloat2() throws Exception {
        TestFunction.helpTestRound(new Float(123.456f), new Integer(3), (Object)new Float(123.456f));
    }

    @Test
    public void testRoundFloat3() throws Exception {
        TestFunction.helpTestRound(new Float(123.456f), new Integer(2), (Object)new Float(123.46f));
    }

    @Test
    public void testRoundFloat4() throws Exception {
        TestFunction.helpTestRound(new Float(123.456f), new Integer(1), (Object)new Float(123.5f));
    }

    @Test
    public void testRoundFloat5() throws Exception {
        TestFunction.helpTestRound(new Float(123.456f), new Integer(0), (Object)new Float(123.0f));
    }

    @Test
    public void testRoundFloat6() throws Exception {
        TestFunction.helpTestRound(new Float(123.456f), new Integer(-1), (Object)new Float(120.0f));
    }

    @Test
    public void testRoundFloat7() throws Exception {
        TestFunction.helpTestRound(new Float(123.456f), new Integer(-2), (Object)new Float(100.0f));
    }

    @Test
    public void testRoundFloat8() throws Exception {
        TestFunction.helpTestRound(new Float(123.456f), new Integer(-3), (Object)new Float(0.0f));
    }

    @Test
    public void testRoundFloat9() throws Exception {
        TestFunction.helpTestRound(new Float(123.456f), new Integer(-4), (Object)new Float(0.0f));
    }

    @Test
    public void testRoundFloat10() throws Exception {
        TestFunction.helpTestRound(new Float(123.456f), new Integer(4000), (Object)new Float(123.456f));
    }

    @Test
    public void testRoundDouble1() throws Exception {
        TestFunction.helpTestRound(new Double(123.456), new Integer(4), (Object)new Double(123.456));
    }

    @Test
    public void testRoundDouble2() throws Exception {
        TestFunction.helpTestRound(new Double(123.456), new Integer(3), (Object)new Double(123.456));
    }

    @Test
    public void testRoundDouble3() throws Exception {
        TestFunction.helpTestRound(new Double(123.456), new Integer(2), (Object)new Double(123.46));
    }

    @Test
    public void testRoundDouble4() throws Exception {
        TestFunction.helpTestRound(new Double(123.456), new Integer(1), (Object)new Double(123.5));
    }

    @Test
    public void testRoundDouble5() throws Exception {
        TestFunction.helpTestRound(new Double(123.456), new Integer(0), (Object)new Double(123.0));
    }

    @Test
    public void testRoundDouble6() throws Exception {
        TestFunction.helpTestRound(new Double(123.456), new Integer(-1), (Object)new Double(120.0));
    }

    @Test
    public void testRoundDouble7() throws Exception {
        TestFunction.helpTestRound(new Double(123.456), new Integer(-2), (Object)new Double(100.0));
    }

    @Test
    public void testRoundDouble8() throws Exception {
        TestFunction.helpTestRound(new Double(123.456), new Integer(-3), (Object)new Double(0.0));
    }

    @Test
    public void testRoundDouble9() throws Exception {
        TestFunction.helpTestRound(new Double(123.456), new Integer(-4), (Object)new Double(0.0));
    }

    @Test
    public void testRoundDouble10() throws Exception {
        TestFunction.helpTestRound(new Double(-3.5), new Integer(0), (Object)new Double(-4.0));
    }

    @Test
    public void testRoundBigDecimal1() throws Exception {
        TestFunction.helpTestRound(new BigDecimal("123.456"), new Integer(4), (Object)new BigDecimal("123.456"));
    }

    @Test
    public void testRoundBigDecimal2() throws Exception {
        TestFunction.helpTestRound(new BigDecimal("123.456"), new Integer(3), (Object)new BigDecimal("123.456"));
    }

    @Test
    public void testRoundBigDecimal3() throws Exception {
        TestFunction.helpTestRound(new BigDecimal("123.456"), new Integer(2), (Object)new BigDecimal("123.460"));
    }

    @Test
    public void testRoundBigDecimal4() throws Exception {
        TestFunction.helpTestRound(new BigDecimal("123.456"), new Integer(1), (Object)new BigDecimal("123.500"));
    }

    @Test
    public void testRoundBigDecimal5() throws Exception {
        TestFunction.helpTestRound(new BigDecimal("123.456"), new Integer(0), (Object)new BigDecimal("123.000"));
    }

    @Test
    public void testRoundBigDecimal6() throws Exception {
        TestFunction.helpTestRound(new BigDecimal("123.456"), new Integer(-1), (Object)new BigDecimal("120.000"));
    }

    @Test
    public void testRoundBigDecimal7() throws Exception {
        TestFunction.helpTestRound(new BigDecimal("123.456"), new Integer(-2), (Object)new BigDecimal("100.000"));
    }

    @Test
    public void testRoundBigDecimal8() throws Exception {
        TestFunction.helpTestRound(new BigDecimal("123.456"), new Integer(-3), (Object)new BigDecimal("0.000"));
    }

    @Test
    public void testRoundBigDecimal9() throws Exception {
        TestFunction.helpTestRound(new BigDecimal("123.456"), new Integer(-4), (Object)new BigDecimal("0.000"));
    }

    @Test
    public void testHour1() throws Exception {
        TestFunction.helpTestHour1("00:00:00", 0);
    }

    @Test
    public void testHour2() throws Exception {
        TestFunction.helpTestHour1("11:00:00", 11);
    }

    @Test
    public void testHour3() throws Exception {
        TestFunction.helpTestHour1("12:00:00", 12);
    }

    @Test
    public void testHour4() throws Exception {
        TestFunction.helpTestHour1("13:00:00", 13);
    }

    @Test
    public void testHour5() throws Exception {
        TestFunction.helpTestHour1("23:59:59", 23);
    }

    @Test
    public void testHour6() throws Exception {
        TestFunction.helpTestHour2("2002-01-01 00:00:00", 0);
    }

    @Test
    public void testHour7() throws Exception {
        TestFunction.helpTestHour2("2002-01-01 11:00:00", 11);
    }

    @Test
    public void testHour8() throws Exception {
        TestFunction.helpTestHour2("2002-01-01 12:00:00", 12);
    }

    @Test
    public void testHour9() throws Exception {
        TestFunction.helpTestHour2("2002-01-01 13:00:00", 13);
    }

    @Test
    public void testHour10() throws Exception {
        TestFunction.helpTestHour2("2002-01-01 23:59:59", 23);
    }

    @Test
    public void testTimestampCreate1() throws Exception {
        TestFunction.helpTestTimestampCreate(TimestampUtil.createDate((int)103, (int)11, (int)1), TimestampUtil.createTime((int)23, (int)59, (int)59), "2003-12-01 23:59:59.0");
    }

    @Test
    public void testTimestampAdd2() throws Exception {
        Assert.assertEquals((Object)TimestampUtil.createTimestamp((int)103, (int)11, (int)1, (int)18, (int)20, (int)30, (int)0), (Object)FunctionMethods.timestampAdd((String)"SQL_TSI_HOUR", (Integer)3, (Timestamp)TimestampUtil.createTimestamp((int)103, (int)11, (int)1, (int)15, (int)20, (int)30, (int)0)));
    }

    @Test
    public void testTimestampDiffTimeStamp_FracSec_1() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_FRAC_SECOND", TimestampUtil.createTimestamp((int)101, (int)5, (int)21, (int)3, (int)9, (int)35, (int)1), TimestampUtil.createTimestamp((int)101, (int)5, (int)21, (int)3, (int)9, (int)35, (int)100000000), new Long(99999999L));
    }

    @Test
    public void testTimestampDiffTimeStamp_FracSec_2() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_FRAC_SECOND", TimestampUtil.createTimestamp((int)101, (int)5, (int)21, (int)3, (int)9, (int)35, (int)2), TimestampUtil.createTimestamp((int)101, (int)5, (int)22, (int)3, (int)9, (int)35, (int)3), new Long(86400000000001L));
    }

    @Test
    public void testTimestampDiffTimeStamp_FracSec_3() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_FRAC_SECOND", TimestampUtil.createTimestamp((int)101, (int)5, (int)22, (int)3, (int)9, (int)35, (int)2), TimestampUtil.createTimestamp((int)101, (int)5, (int)21, (int)3, (int)9, (int)35, (int)3), new Long(-86399999999999L));
    }

    @Test
    public void testTimestampDiffTimeStamp_FracSec_4() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_FRAC_SECOND", TimestampUtil.createTimestamp((int)101, (int)5, (int)21, (int)0, (int)0, (int)0, (int)1), TimestampUtil.createTimestamp((int)101, (int)5, (int)21, (int)0, (int)0, (int)0, (int)3), new Long(2L));
    }

    @Test
    public void testTimestampDiffTimeStamp_FracSec_5() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_FRAC_SECOND", TimestampUtil.createTimestamp((int)104, (int)5, (int)22, (int)0, (int)0, (int)0, (int)1), TimestampUtil.createTimestamp((int)104, (int)5, (int)22, (int)0, (int)0, (int)0, (int)10), new Long(9L));
    }

    @Test
    public void testTimestampDiffTimeStamp_FracSec_6() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_FRAC_SECOND", TimestampUtil.createTimestamp((int)101, (int)5, (int)22, (int)0, (int)0, (int)0, (int)2), TimestampUtil.createTimestamp((int)101, (int)5, (int)22, (int)0, (int)0, (int)0, (int)3), new Long(1L));
    }

    @Test
    public void testTimestampDiffTimeStamp_FracSec_7() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_FRAC_SECOND", TimestampUtil.createTimestamp((int)104, (int)5, (int)22, (int)3, (int)9, (int)35, (int)2), TimestampUtil.createTimestamp((int)104, (int)5, (int)22, (int)3, (int)9, (int)35, (int)3), new Long(1L));
    }

    @Test
    public void testTimestampDiffTimeStamp_FracSec_8() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_FRAC_SECOND", TimestampUtil.createTimestamp((int)104, (int)5, (int)22, (int)3, (int)9, (int)35, (int)3), TimestampUtil.createTimestamp((int)104, (int)5, (int)22, (int)3, (int)9, (int)35, (int)2), new Long(-1L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Min_1() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_MINUTE", TimestampUtil.createTimestamp((int)0, (int)0, (int)0, (int)2, (int)34, (int)12, (int)0), TimestampUtil.createTimestamp((int)0, (int)0, (int)0, (int)12, (int)0, (int)0, (int)0), new Long(565L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Min_2() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_MINUTE", TimestampUtil.createTimestamp((int)101, (int)0, (int)0, (int)2, (int)0, (int)0, (int)0), TimestampUtil.createTimestamp((int)101, (int)0, (int)0, (int)0, (int)33, (int)12, (int)0), new Long(-87L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Min_3() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_MINUTE", TimestampUtil.createTimestamp((int)101, (int)8, (int)26, (int)12, (int)7, (int)58, (int)65497), TimestampUtil.createTimestamp((int)101, (int)8, (int)29, (int)11, (int)25, (int)42, (int)483219), new Long(4278L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Min_4() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_MINUTE", TimestampUtil.createTimestamp((int)101, (int)8, (int)26, (int)12, (int)7, (int)58, (int)0), TimestampUtil.createTimestamp((int)101, (int)8, (int)29, (int)11, (int)25, (int)42, (int)0), new Long(4278L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Min_5() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_MINUTE", TimestampUtil.createTimestamp((int)101, (int)8, (int)26, (int)12, (int)0, (int)0, (int)1), TimestampUtil.createTimestamp((int)101, (int)8, (int)26, (int)12, (int)0, (int)0, (int)0), new Long(0L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Hour_1() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_HOUR", TimestampUtil.createTimestamp((int)104, (int)8, (int)26, (int)12, (int)0, (int)0, (int)0), TimestampUtil.createTimestamp((int)104, (int)8, (int)26, (int)12, (int)59, (int)59, (int)999999999), new Long(0L));
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("Pacific/Marquesas"));
        try {
            TestFunction.helpTestTimestampDiff("SQL_TSI_HOUR", TimestampUtil.createTimestamp((int)104, (int)8, (int)26, (int)12, (int)0, (int)0, (int)0), TimestampUtil.createTimestamp((int)104, (int)8, (int)26, (int)12, (int)59, (int)59, (int)999999999), new Long(0L));
        }
        finally {
            TimestampWithTimezone.resetCalendar(null);
        }
    }

    @Test
    public void testTimestampDiffTimeStamp_Week_1() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_WEEK", TimestampUtil.createTimestamp((int)101, (int)5, (int)21, (int)3, (int)9, (int)35, (int)100), TimestampUtil.createTimestamp((int)101, (int)4, (int)2, (int)5, (int)19, (int)35, (int)500), new Long(-7L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Month_1() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_MONTH", TimestampUtil.createTimestamp((int)104, (int)4, (int)19, (int)0, (int)0, (int)0, (int)0), TimestampUtil.createTimestamp((int)104, (int)11, (int)20, (int)12, (int)0, (int)0, (int)0), new Long(7L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Month_2() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_MONTH", TimestampUtil.createTimestamp((int)104, (int)5, (int)1, (int)0, (int)0, (int)0, (int)1000000), TimestampUtil.createTimestamp((int)104, (int)11, (int)1, (int)12, (int)0, (int)0, (int)1), new Long(6L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Month_3() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_MONTH", TimestampUtil.createTimestamp((int)104, (int)4, (int)19, (int)0, (int)0, (int)0, (int)1), TimestampUtil.createTimestamp((int)104, (int)11, (int)18, (int)12, (int)0, (int)0, (int)1000000), new Long(7L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Month_4() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_MONTH", TimestampUtil.createTimestamp((int)104, (int)4, (int)1, (int)0, (int)0, (int)0, (int)1000000), TimestampUtil.createTimestamp((int)104, (int)11, (int)1, (int)0, (int)0, (int)0, (int)0), new Long(7L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Month_5() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_MONTH", TimestampUtil.createTimestamp((int)104, (int)4, (int)1, (int)0, (int)0, (int)1, (int)0), TimestampUtil.createTimestamp((int)104, (int)11, (int)1, (int)0, (int)0, (int)0, (int)0), new Long(7L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Month_6() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_MONTH", TimestampUtil.createTimestamp((int)104, (int)4, (int)1, (int)0, (int)0, (int)1, (int)0), TimestampUtil.createTimestamp((int)104, (int)11, (int)1, (int)0, (int)0, (int)2, (int)0), new Long(7L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Day_1() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_DAY", TimestampUtil.createTimestamp((int)104, (int)4, (int)1, (int)0, (int)0, (int)0, (int)0), TimestampUtil.createTimestamp((int)104, (int)5, (int)1, (int)0, (int)0, (int)0, (int)0), new Long(31L));
    }

    @Test
    public void testTimestampDiffTimeStamp_Day_2() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_DAY", TimestampUtil.createTimestamp((int)104, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0), TimestampUtil.createTimestamp((int)104, (int)2, (int)1, (int)0, (int)0, (int)0, (int)0), new Long(29L));
    }

    @Test
    public void testTimestampDiffTime_Hour_1() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_HOUR", new Timestamp(TimestampUtil.createTime((int)3, (int)4, (int)45).getTime()), new Timestamp(TimestampUtil.createTime((int)5, (int)5, (int)36).getTime()), new Long(2L));
    }

    @Test
    public void testTimestampDiffTime_Hour_2() throws Exception {
        TestFunction.helpTestTimestampDiff("SQL_TSI_HOUR", new Timestamp(TimestampUtil.createTime((int)5, (int)0, (int)30).getTime()), new Timestamp(TimestampUtil.createTime((int)3, (int)0, (int)31).getTime()), new Long(-2L));
    }

    @Test
    public void testParseTimestamp1() throws Exception {
        TestFunction.helpTestParseTimestamp("1993-04-24 3:59:59 PM", "yyyy-MM-dd hh:mm:ss aa", "{ts'1993-04-24 15:59:59.0'}");
    }

    public void helpTestModifyTimeZone(String tsStr, String tzStart, String tzEnd, String expectedStr) throws Exception {
        Timestamp ts = tsStr != null ? Timestamp.valueOf(tsStr) : null;
        Timestamp actual = null;
        actual = tzStart == null ? (Timestamp)FunctionMethods.modifyTimeZone((CommandContext)new CommandContext(), (Timestamp)ts, (String)tzEnd) : (Timestamp)FunctionMethods.modifyTimeZone((Timestamp)ts, (String)tzStart, (String)tzEnd);
        String actualStr = null;
        if (actual != null) {
            actualStr = actual.toString();
        }
        Assert.assertEquals((String)"Did not get expected output timestamp", (Object)expectedStr, (Object)actualStr);
    }

    @Test
    public void testModifyTimeZoneGMT() throws Exception {
        this.helpTestModifyTimeZone("2004-10-03 15:19:59.123456789", "GMT+00:00", "GMT-01:00", "2004-10-03 16:19:59.123456789");
    }

    @Test
    public void testModifyTimeZoneGMTPartialHour() throws Exception {
        this.helpTestModifyTimeZone("2004-10-03 15:30:59.123456789", "GMT+00:00", "GMT-01:45", "2004-10-03 17:15:59.123456789");
    }

    @Test
    public void testModifyTimeZoneNamedTZ() throws Exception {
        this.helpTestModifyTimeZone("2004-10-03 15:19:59.123456789", "America/New_York", "America/Chicago", "2004-10-03 16:19:59.123456789");
    }

    @Test
    public void testModifyTimeZoneNamedTZ2() throws Exception {
        this.helpTestModifyTimeZone("2004-10-03 15:19:59.123456789", "America/Chicago", "America/New_York", "2004-10-03 14:19:59.123456789");
    }

    @Test
    public void testModifyTimeZoneStartLocal() throws Exception {
        this.helpTestModifyTimeZone("2004-10-03 15:19:59.123456789", "America/Chicago", "America/Los_Angeles", "2004-10-03 17:19:59.123456789");
    }

    @Test
    public void testCurrentDate() throws Exception {
        Date curDate = (Date)FunctionMethods.currentDate();
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(curDate);
        Assert.assertEquals((long)cal1.get(11), (long)0L);
        Assert.assertEquals((long)cal1.get(12), (long)0L);
        Assert.assertEquals((long)cal1.get(13), (long)0L);
        Assert.assertEquals((long)cal1.get(14), (long)0L);
    }

    @Test
    public void testCurrentTime() throws Exception {
        Time curDate = (Time)FunctionMethods.currentTime();
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(curDate);
        Assert.assertEquals((long)cal1.get(1), (long)1970L);
        Assert.assertEquals((long)cal1.get(2), (long)0L);
        Assert.assertEquals((long)cal1.get(5), (long)1L);
    }

    @Test
    public void testRand() throws Exception {
        Double d = (Double)FunctionMethods.rand((CommandContext)new CommandContext(), (Integer)new Integer(100));
        Assert.assertEquals((Object)new Double(0.7220096548596434), (Object)d);
        FunctionMethods.rand((CommandContext)new CommandContext());
    }

    @Test
    public void testEnv() throws Exception {
        String systemProperty = "SystemProperty";
        System.setProperty(systemProperty, systemProperty);
        System.setProperty(systemProperty.toLowerCase(), systemProperty + "_lowercase");
        Assert.assertEquals((Object)systemProperty, (Object)FunctionMethods.env((String)systemProperty));
        Assert.assertEquals((Object)(systemProperty + "_lowercase"), (Object)FunctionMethods.env((String)systemProperty.toUpperCase()));
    }

    @Test(expected=FunctionExecutionException.class)
    public void testParseIntStrictness() throws Exception {
        FunctionMethods.parseBigDecimal((CommandContext)new CommandContext(), (String)"a 1 a", (String)"#");
    }

    @Test
    public void testParseDateStrictness() throws Exception {
        Assert.assertEquals((Object)TimestampUtil.createTimestamp((int)108, (int)0, (int)1, (int)0, (int)0, (int)0, (int)0), (Object)FunctionMethods.parseTimestamp((CommandContext)new CommandContext(), (String)" 2007-13-01", (String)"yyyy-MM"));
    }

    @Test
    public void testParseTimeWhitespace() throws Exception {
        Assert.assertEquals((Object)TimestampUtil.createTime((int)15, (int)0, (int)0), (Object)FunctionMethods.parseTimestamp((CommandContext)new CommandContext(), (String)" 15:00:00 ", (String)"HH:mm:ss"));
    }

    @Test
    public void testMod() {
        Assert.assertEquals((Object)new BigDecimal("-1.1"), (Object)FunctionMethods.mod((BigDecimal)new BigDecimal("-3.1"), (BigDecimal)new BigDecimal("2")));
    }

    @Test
    public void testMod1() {
        Assert.assertEquals((Object)new BigDecimal("-1.1"), (Object)FunctionMethods.mod((BigDecimal)new BigDecimal("-3.1"), (BigDecimal)new BigDecimal("-2")));
    }

    @Test
    public void testMod2() {
        Assert.assertEquals((float)-40.0f, (float)FunctionMethods.mod((int)-340, (int)60), (float)0.0f);
    }

    @Test
    public void testMod3() {
        Assert.assertEquals((float)-40.0f, (float)FunctionMethods.mod((int)-340, (int)-60), (float)0.0f);
    }

    @Test
    public void testMod4() {
        Assert.assertEquals((Object)new BigInteger("-1"), (Object)FunctionMethods.mod((BigInteger)new BigInteger("-3"), (BigInteger)new BigInteger("2")));
    }

    @Test
    public void testMod5() {
        Assert.assertEquals((Object)new BigInteger("-1"), (Object)FunctionMethods.mod((BigInteger)new BigInteger("-3"), (BigInteger)new BigInteger("-2")));
    }
}

