/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.jboss.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.arquillian.SampleFunctions;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestDDL
extends AbstractMMQueryTestCase {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9990, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testDDL() throws Exception {
        String ddl = "create database foo version '1';use database foo version '1';create foreign data wrapper loopback;create server NONE type 'NONE' foreign data wrapper loopback;create schema test server NONE;set schema test;CREATE FOREIGN TABLE G1 (e1 integer PRIMARY KEY, e2 varchar(25), e3 double)";
        this.admin.deploy("foo-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl.getBytes()), false);
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:foo@mm://localhost:31000;user=user;password=user;autoFailover=true", null);
        this.execute("SELECT * FROM test.G1");
        this.assertRowCount(1);
        try {
            this.execute("SELECT * FROM test.G2");
            Assert.fail((String)"should have failed as there is no G2 Table");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ddl = ddl + "CREATE FOREIGN TABLE G2 (e1 integer PRIMARY KEY, e2 varchar(25), e3 double)";
        this.admin.deploy("foo-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl.getBytes()), false);
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:foo@mm://localhost:31000;user=user;password=user;autoFailover=true", null);
        this.execute("SELECT * FROM test.G2");
        this.assertRowCount(1);
        this.printResults();
        this.closeConnection();
        this.admin.undeploy("foo-vdb.ddl");
    }

    @Test
    public void testOverrideTranslator() throws Exception {
        String ddl = "create database foo;use database foo version '1';create foreign data wrapper loopy type loopback OPTIONS(IncrementRows true, RowCount 500);create server serverOne type 'NONE' foreign data wrapper loopy;create schema test server serverOne;set schema test;CREATE FOREIGN TABLE G1 (e1 integer PRIMARY KEY, e2 varchar(25), e3 double);";
        this.admin.deploy("foo-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl.getBytes()), false);
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:foo@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT * FROM test.G1");
        this.assertRowCount(500);
        this.closeConnection();
        this.admin.undeploy("foo-vdb.ddl");
    }

    @Test
    public void testVDBImport() throws Exception {
        String ddl = "create database foo;use database foo version '1';create foreign data wrapper loopy type loopback OPTIONS(IncrementRows true, RowCount 500);create server serverOne type 'NONE' foreign data wrapper loopy;create schema test server serverOne;set schema test;CREATE FOREIGN TABLE G1 (e1 integer PRIMARY KEY, e2 varchar(25), e3 double);";
        String bar = "create database BAR;IMPORT database foo VERSION '1';";
        this.admin.deploy("foo-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl.getBytes()), false);
        this.admin.deploy("bar-vdb.ddl", (InputStream)new ByteArrayInputStream(bar.getBytes()), false);
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:BAR@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT * FROM test.G1");
        this.assertRowCount(500);
        this.closeConnection();
        this.admin.undeploy("bar-vdb.ddl");
        this.admin.undeploy("foo-vdb.ddl");
    }

    @Test
    public void testUdfClasspath() throws Exception {
        JavaArchive jar = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"func.jar")).addClasses(new Class[]{SampleFunctions.class});
        this.admin.deploy("func.jar", ((ZipExporter)jar.as(ZipExporter.class)).exportAsInputStream());
        String ddl = "create database \"dynamic-func\" OPTIONS(lib 'deployment.func.jar');USE DATABASE \"dynamic-func\" version '1';CREATE VIRTUAL schema test;SET SCHEMA test;CREATE function func (val string) returns integer options (JAVA_CLASS 'org.teiid.arquillian.SampleFunctions',  JAVA_METHOD 'doSomething');";
        this.admin.deploy("dynamic-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl.getBytes()), false);
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:dynamic-func@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT func('a')");
        this.assertRowCount(1);
        this.admin.undeploy("dynamic-vdb.ddl");
        this.closeConnection();
    }

    @Test(expected=SQLException.class)
    public void testDDLOverJDBCNoAuth() throws Exception {
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:foo2@mm://localhost:31000;user=dummy;password=user;autoFailover=true;vdbEdit=true", null);
    }
}

