/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.Collection;
import java.util.Map;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.metadata.FunctionMetadataValidator;
import org.teiid.query.function.source.SystemSource;
import org.teiid.query.validator.ValidatorReport;

public class SystemFunctionManager {
    private FunctionTree systemFunctionTree;
    private Map<String, Datatype> types;

    public SystemFunctionManager(Map<String, Datatype> typeMap) {
        this.types = typeMap;
        SystemSource systemSource = new SystemSource();
        ValidatorReport report = new ValidatorReport("Function Validation");
        Collection<FunctionMethod> functionMethods = systemSource.getFunctionMethods();
        FunctionMetadataValidator.validateFunctionMethods(functionMethods, report, this.types);
        if (report.hasItems()) {
            System.err.println(QueryPlugin.Util.getString("ERR.015.001.0005", new Object[]{report}));
        }
        this.systemFunctionTree = new FunctionTree("SYS", systemSource, true);
    }

    public FunctionTree getSystemFunctions() {
        return this.systemFunctionTree;
    }

    public FunctionLibrary getSystemFunctionLibrary() {
        return new FunctionLibrary(this.getSystemFunctions(), new FunctionTree[0]);
    }
}

