/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.Serializable;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.impl.SizeUtility;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManager;

public class TestSizeUtility {
    public void helpTestGetStaticSize(Object obj, long expectedSize) {
        this.helpTestGetSize(obj, expectedSize);
    }

    public void helpTestGetSize(Object obj, long expectedSize) {
        long actualSize = SizeUtility.getSize((Object)obj, (boolean)false);
        Assert.assertEquals((String)"Got unexpected size: ", (long)expectedSize, (long)actualSize);
    }

    @Test
    public void testGetSizeChar() {
        this.helpTestGetStaticSize(new Character('a'), 10L);
    }

    @Test
    public void testGetSizeBoolean() {
        this.helpTestGetStaticSize(Boolean.TRUE, 1L);
    }

    @Test
    public void testGetSizeByte() {
        this.helpTestGetStaticSize(new Byte(0), 1L);
    }

    @Test
    public void testGetSizeShort() {
        this.helpTestGetStaticSize(new Short(0), 10L);
    }

    @Test
    public void testGetSizeInteger() {
        this.helpTestGetStaticSize(new Integer(0), 12L);
    }

    @Test
    public void testGetSizeLong() {
        this.helpTestGetStaticSize(new Long(0L), 16L);
    }

    @Test
    public void testGetSizeFloat() {
        this.helpTestGetStaticSize(new Float(0.0f), 12L);
    }

    @Test
    public void testGetSizeDouble() {
        this.helpTestGetStaticSize(new Double(0.0), 16L);
    }

    @Test
    public void testGetSizeTimestamp() {
        this.helpTestGetStaticSize(new Timestamp(0xBBB5EBL), 28L);
    }

    @Test
    public void testGetSizeDate() {
        this.helpTestGetStaticSize(new Date(0xBBB5EBL), 28L);
    }

    @Test
    public void testGetSizeTime() {
        this.helpTestGetStaticSize(new Time(0xBBB5EBL), 28L);
    }

    @Test
    public void testGetSizeEmptyString() {
        this.helpTestGetSize("", 40L);
    }

    @Test
    public void testGetSizeShortString() {
        this.helpTestGetSize("abcdefghij", 64L);
    }

    @Test
    public void testGetSizeObject() {
        this.helpTestGetStaticSize(new SomeObject(null), 16L);
        this.helpTestGetStaticSize(new SomeObject("Hello world"), 56L);
    }

    @Test
    public void testGetSizeRow1() {
        ArrayList<Integer> row = new ArrayList<Integer>(1);
        row.add(new Integer(0));
        this.helpTestGetStaticSize(row, 36L);
    }

    @Test
    public void testGetSizeRow2() {
        ArrayList<Constable> row = new ArrayList<Constable>(4);
        row.add(new Integer(0));
        row.add(new Integer(101));
        row.add(Boolean.TRUE);
        row.add(new Double(1091203.0));
        this.helpTestGetStaticSize(row, 89L);
    }

    @Test
    public void testGetSizeRows1() {
        this.helpTestGetStaticSize(new List[0], 16L);
    }

    @Test
    public void testGetSizeRows2() {
        ArrayList<Integer> row1 = new ArrayList<Integer>(2);
        row1.add(new Integer(0));
        row1.add(new Integer(100));
        ArrayList<Integer> row2 = new ArrayList<Integer>(2);
        row2.add(new Integer(0));
        row2.add(new Integer(100));
        this.helpTestGetStaticSize(new List[]{row1, row2}, 144L);
    }

    @Test
    public void testGetSizeBigInteger() {
        BigInteger b = BigInteger.ONE;
        this.helpTestGetStaticSize(b, 48L);
    }

    @Test
    public void testGetSizeBigDecimal() {
        BigDecimal bd = new BigDecimal("1.0");
        this.helpTestGetStaticSize(bd, 96L);
    }

    @Test
    public void testGetSizeByteArray() {
        byte[] bytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        this.helpTestGetSize(new BinaryType(bytes), 32L);
    }

    @Test
    public void testResultSet() {
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), "a", new Integer(0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), "a", new Integer(0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), "a", new Integer(0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), "a", new Integer(0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), "a", new Integer(3)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), "a", new Integer(3)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0), "a", new Integer(0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0), "a", new Integer(0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0), "a", new Integer(3)), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0), "b", new Integer(2)), Arrays.asList("c", new Integer(1), Boolean.FALSE, new Double(0.0), "c", new Integer(1))};
        Class[] types = new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.BOOLEAN, DataTypeManager.DefaultDataClasses.DOUBLE, DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER};
        long actualSize = new SizeUtility(types).getBatchSize(false, Arrays.asList(expected));
        Assert.assertEquals((String)"Got unexpected size: ", (long)2667L, (long)actualSize);
    }

    private static class SomeObject
    implements Serializable {
        private String state;

        public SomeObject(String state) {
            this.state = state;
        }
    }
}

