/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.queue;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.resource.spi.work.Work;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;
import org.teiid.common.queue.FakeWorkItem;
import org.teiid.dqp.internal.process.FutureWork;
import org.teiid.dqp.internal.process.ThreadReuseExecutor;

public class TestThreadReuseExecutor {
    ThreadReuseExecutor pool = null;

    @After
    public void tearDown() {
        if (this.pool != null) {
            this.pool.shutdownNow();
        }
    }

    @Test
    public void testQueuing() throws Exception {
        long SINGLE_WAIT = 50L;
        int WORK_ITEMS = 10;
        int MAX_THREADS = 5;
        this.pool = new ThreadReuseExecutor("test", 5);
        for (int i = 0; i < 10; ++i) {
            this.pool.execute((Runnable)((Object)new FakeWorkItem(50L)));
        }
        this.pool.shutdown();
        this.pool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)this.pool.isTerminated());
        WorkerPoolStatisticsMetadata stats = this.pool.getStats();
        Assert.assertEquals((long)10L, (long)stats.getTotalCompleted());
        Assert.assertEquals((String)"Expected threads to be maxed out", (long)5L, (long)stats.getHighestActiveThreads());
    }

    @Test
    public void testThreadReuse() throws Exception {
        long SINGLE_WAIT = 50L;
        long NUM_THREADS = 5L;
        this.pool = new ThreadReuseExecutor("test", 5);
        int i = 0;
        while ((long)i < 5L) {
            this.pool.execute((Runnable)((Object)new FakeWorkItem(50L)));
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        this.pool.shutdown();
        WorkerPoolStatisticsMetadata stats = this.pool.getStats();
        Assert.assertTrue((String)"Expected approximately 1 thread for serial execution", (stats.getHighestActiveThreads() <= 2 ? 1 : 0) != 0);
        this.pool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=RejectedExecutionException.class)
    public void testShutdown() throws Exception {
        this.pool = new ThreadReuseExecutor("test", 5);
        this.pool.shutdown();
        this.pool.execute((Runnable)((Object)new FakeWorkItem(1L)));
    }

    @Test
    public void testFailingWork() throws Exception {
        this.pool = new ThreadReuseExecutor("test", 5);
        final Semaphore signal = new Semaphore(1);
        this.pool.execute((Runnable)new Work(){

            public void run() {
                signal.release();
                throw new RuntimeException();
            }

            public void release() {
            }
        });
        Assert.assertTrue((boolean)signal.tryAcquire(2L, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPriorities() throws Exception {
        this.pool = new ThreadReuseExecutor("test", 1);
        FutureWork work1 = new FutureWork((Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                ThreadReuseExecutor threadReuseExecutor = TestThreadReuseExecutor.this.pool;
                synchronized (threadReuseExecutor) {
                    while (TestThreadReuseExecutor.this.pool.getSubmittedCount() < 4) {
                        TestThreadReuseExecutor.this.pool.wait();
                    }
                }
                return true;
            }
        }, 0);
        final ConcurrentLinkedQueue order = new ConcurrentLinkedQueue();
        FutureWork work2 = new FutureWork((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                order.add(2);
                return true;
            }
        }, 2);
        FutureWork work3 = new FutureWork((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                order.add(3);
                return false;
            }
        }, 1);
        Thread.sleep(20L);
        FutureWork work4 = new FutureWork((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                order.add(4);
                return false;
            }
        }, 2);
        this.pool.execute((Runnable)work1);
        this.pool.execute((Runnable)work2);
        this.pool.execute((Runnable)work3);
        this.pool.execute((Runnable)work4);
        ThreadReuseExecutor threadReuseExecutor = this.pool;
        synchronized (threadReuseExecutor) {
            this.pool.notifyAll();
        }
        work1.get();
        work2.get();
        work3.get();
        work4.get();
        Assert.assertEquals((Object)3, order.remove());
        Assert.assertEquals((Object)2, order.remove());
        Assert.assertEquals((Object)4, order.remove());
    }
}

