/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.List;
import junit.framework.TestCase;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.util.SymbolMap;

public class TestJoinWithFunction
extends TestCase {
    public void testNonDeterministicPostJoin() throws Exception {
        String leftQuery = "SELECT pm1.g1.e1 as ID, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1";
        String rightQuery = "SELECT pm2.g2.e1 as ID, pm2.g2.e2, pm2.g2.e3, pm2.g2.e4 FROM pm2.g2";
        String sql = "SELECT l.ID, l.e2, l.e3, l.e4, r.ID, r.e2, r.e3, r.e4, RAND() AS RandomTop FROM (" + leftQuery + ") AS l, (" + rightQuery + ") AS r WHERE l.ID = r.ID";
        String[] expected = new String[]{"SELECT g_0.e1 AS c_0, g_0.e2 AS c_1, g_0.e3 AS c_2, g_0.e4 AS c_3 FROM pm1.g1 AS g_0 ORDER BY c_0", "SELECT g_0.e1 AS c_0, g_0.e2 AS c_1, g_0.e3 AS c_2, g_0.e4 AS c_3 FROM pm2.g2 AS g_0 ORDER BY c_0"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestOptimizer.example1(), expected, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    public void testNonDeterministicPreJoin() throws Exception {
        String leftQuery = "SELECT pm1.g1.e1 as ID, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4, RAND() AS RandomLeft FROM pm1.g1";
        String rightQuery = "SELECT pm1.g2.e1 as ID, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM pm1.g2";
        String sql = "SELECT l.ID, l.e2, l.e3, l.e4, r.ID, r.e2, r.e3, r.e4, l.RandomLeft FROM (" + leftQuery + ") AS l, (" + rightQuery + ") AS r WHERE l.ID = r.ID";
        String[] expected = new String[]{"SELECT g_0.e1, g_0.e2, g_0.e3, g_0.e4 FROM pm1.g1 AS g_0", "SELECT g_0.e1 AS c_0, g_0.e2 AS c_1, g_0.e3 AS c_2, g_0.e4 AS c_3 FROM pm1.g2 AS g_0 ORDER BY c_0"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestOptimizer.example1(), expected, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0});
    }

    public void testNonDeterministicPreJoin1() throws Exception {
        String leftQuery = "SELECT pm1.g1.e1 as ID, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4, RAND() AS RandomLeft FROM pm1.g1";
        String rightQuery = "SELECT pm1.g2.e1 as ID, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM pm1.g2";
        String sql = "SELECT l.ID, l.e2, l.e3, l.e4, r.ID, r.e2, r.e3, r.e4 FROM (" + leftQuery + ") AS l, (" + rightQuery + ") AS r WHERE l.ID = r.ID";
        String[] expected = new String[]{"SELECT g_0.e1, g_0.e2, g_0.e3, g_0.e4, g_1.e1, g_1.e2, g_1.e3, g_1.e4 FROM pm1.g1 AS g_0, pm1.g2 AS g_1 WHERE g_0.e1 = g_1.e1"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestOptimizer.example1(), expected, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    public void testNonDeterministicPrePostJoin() throws Exception {
        String leftQuery = "SELECT pm1.g1.e1 as ID, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4, RAND() AS RandomLeft FROM pm1.g1";
        String rightQuery = "SELECT pm2.g2.e1 as ID, pm2.g2.e2, pm2.g2.e3, pm2.g2.e4 FROM pm2.g2";
        String sql = "SELECT l.ID, l.e2, l.e3, l.e4, r.ID, r.e2, r.e3, r.e4, l.RandomLeft, RAND() AS RandomTop FROM (" + leftQuery + ") AS l, (" + rightQuery + ") AS r WHERE l.ID = r.ID";
        String[] expected = new String[]{"SELECT g_0.e1, g_0.e2, g_0.e3, g_0.e4 FROM pm1.g1 AS g_0", "SELECT g_0.e1 AS c_0, g_0.e2 AS c_1, g_0.e3 AS c_2, g_0.e4 AS c_3 FROM pm2.g2 AS g_0 ORDER BY c_0"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestOptimizer.example1(), expected, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0});
    }

    public void testDeterministicPostJoin() throws Exception {
        String leftQuery = "SELECT pm1.g1.e1 as ID, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1";
        String rightQuery = "SELECT pm2.g2.e1 as ID, pm2.g2.e2, pm2.g2.e3, pm2.g2.e4 FROM pm2.g2";
        String sql = "SELECT l.ID, l.e2, l.e3, l.e4, r.ID, r.e2, r.e3, r.e4, SQRT(100) AS SqrtTop FROM (" + leftQuery + ") AS l, (" + rightQuery + ") AS r WHERE l.ID = r.ID";
        String[] expected = new String[]{"SELECT g_0.e1 AS c_0, g_0.e2 AS c_1, g_0.e3 AS c_2, g_0.e4 AS c_3 FROM pm1.g1 AS g_0 ORDER BY c_0", "SELECT g_0.e1 AS c_0, g_0.e2 AS c_1, g_0.e3 AS c_2, g_0.e4 AS c_3 FROM pm2.g2 AS g_0 ORDER BY c_0"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestOptimizer.example1(), expected, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        List elem = ((RelationalPlan)plan).getRootNode().getElements();
        Constant expectedConst = new Constant((Object)new Double(10.0));
        TestJoinWithFunction.assertEquals((String)"Did not get expected constant value for SqrtTop in root node of plan: ", (Object)expectedConst, (Object)SymbolMap.getExpression((Expression)((Expression)elem.get(8))));
    }

    public void testDeterministicPreJoin() throws Exception {
        String leftQuery = "SELECT pm1.g1.e1 as ID, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4, SQRT(100) AS SqrtLeft FROM pm1.g1";
        String rightQuery = "SELECT pm2.g2.e1 as ID, pm2.g2.e2, pm2.g2.e3, pm2.g2.e4 FROM pm2.g2";
        String sql = "SELECT l.ID, l.e2, l.e3, l.e4, r.ID, r.e2, r.e3, r.e4, l.SqrtLeft FROM (" + leftQuery + ") AS l, (" + rightQuery + ") AS r WHERE l.ID = r.ID";
        String[] expected = new String[]{"SELECT g_0.e1 AS c_0, g_0.e2 AS c_1, g_0.e3 AS c_2, g_0.e4 AS c_3 FROM pm1.g1 AS g_0 ORDER BY c_0", "SELECT g_0.e1 AS c_0, g_0.e2 AS c_1, g_0.e3 AS c_2, g_0.e4 AS c_3 FROM pm2.g2 AS g_0 ORDER BY c_0"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestOptimizer.example1(), expected, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        List elem = ((RelationalPlan)plan).getRootNode().getElements();
        Constant expectedConst = new Constant((Object)new Double(10.0));
        TestJoinWithFunction.assertEquals((String)"Did not get expected constant value for SqrtLeft in root node of plan: ", (Object)expectedConst, (Object)((ExpressionSymbol)elem.get(8)).getExpression());
    }

    public void testDeterministicPrePostJoin() throws Exception {
        String leftQuery = "SELECT pm1.g1.e1 as ID, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4, SQRT(100) AS SqrtLeft FROM pm1.g1";
        String rightQuery = "SELECT pm2.g2.e1 as ID, pm2.g2.e2, pm2.g2.e3, pm2.g2.e4 FROM pm2.g2";
        String sql = "SELECT l.ID, l.e2, l.e3, l.e4, r.ID, r.e2, r.e3, r.e4, l.SqrtLeft, SQRT(100) AS SqrtTop FROM (" + leftQuery + ") AS l, (" + rightQuery + ") AS r WHERE l.ID = r.ID";
        String[] expected = new String[]{"SELECT g_0.e1 AS c_0, g_0.e2 AS c_1, g_0.e3 AS c_2, g_0.e4 AS c_3 FROM pm1.g1 AS g_0 ORDER BY c_0", "SELECT g_0.e1 AS c_0, g_0.e2 AS c_1, g_0.e3 AS c_2, g_0.e4 AS c_3 FROM pm2.g2 AS g_0 ORDER BY c_0"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestOptimizer.example1(), expected, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        List elem = ((RelationalPlan)plan).getRootNode().getElements();
        Constant expectedConst = new Constant((Object)new Double(10.0));
        TestJoinWithFunction.assertEquals((String)"Did not get expected constant value for SqrtLeft in root node of plan: ", (Object)expectedConst, (Object)SymbolMap.getExpression((Expression)((Expression)elem.get(8))));
        TestJoinWithFunction.assertEquals((String)"Did not get expected constant value for SqrtTop in root node of plan: ", (Object)expectedConst, (Object)SymbolMap.getExpression((Expression)((Expression)elem.get(9))));
    }
}

