/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.FakeDataStore;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestJoinWithFunction
extends TestCase {
    public void testNonDeterministicPostJoin() throws Exception {
        String leftQuery = "SELECT pm1.g1.e1 as ID, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1";
        String rightQuery = "SELECT pm2.g2.e1 as ID, pm2.g2.e2, pm2.g2.e3, pm2.g2.e4 FROM pm2.g2";
        String sql = "SELECT l.ID, l.e2, l.e3, l.e4, r.ID, r.e2, r.e3, r.e4, RAND() AS RandomTop FROM (" + leftQuery + ") AS l, (" + rightQuery + ") AS r WHERE l.ID = r.ID";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), new Boolean(false), new Double(2.0), "a", new Integer(1), new Boolean(true), new Double(2.0), new Double(0.24053641567148587)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(0), new Boolean(false), new Double(0.0), new Double(0.6374174253501083)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(5), new Boolean(true), new Double(2.0), new Double(0.5504370051176339)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(2), new Boolean(false), null, new Double(0.5975452777972018))};
        FakeDataManager dataManager = new FakeDataManager();
        FakeDataStore.sampleData2(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    public void testNonDeterministicPreJoin() throws Exception {
        String leftQuery = "SELECT pm1.g1.e1 as ID, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4, RAND() AS RandomLeft FROM pm1.g1";
        String rightQuery = "SELECT pm2.g2.e1 as ID, pm2.g2.e2, pm2.g2.e3, pm2.g2.e4 FROM pm2.g2";
        String sql = "SELECT l.ID, l.e2, l.e3, l.e4, r.ID, r.e2, r.e3, r.e4, l.RandomLeft FROM (" + leftQuery + ") AS l, (" + rightQuery + ") AS r WHERE l.ID = r.ID";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), new Boolean(false), new Double(2.0), "a", new Integer(1), new Boolean(true), new Double(2.0), new Double(0.24053641567148587)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(0), new Boolean(false), new Double(0.0), new Double(0.6374174253501083)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(5), new Boolean(true), new Double(2.0), new Double(0.6374174253501083)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(2), new Boolean(false), null, new Double(0.6374174253501083))};
        FakeDataManager dataManager = new FakeDataManager();
        FakeDataStore.sampleData2(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    public void testNonDeterministicPrePostJoin() throws Exception {
        String leftQuery = "SELECT pm1.g1.e1 as ID, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4, RAND() AS RandomLeft FROM pm1.g1";
        String rightQuery = "SELECT pm2.g2.e1 as ID, pm2.g2.e2, pm2.g2.e3, pm2.g2.e4 FROM pm2.g2";
        String sql = "SELECT l.ID, l.e2, l.e3, l.e4, r.ID, r.e2, r.e3, r.e4, l.RandomLeft, RAND() AS RandomTop FROM (" + leftQuery + ") AS l, (" + rightQuery + ") AS r WHERE l.ID = r.ID";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), new Boolean(false), new Double(2.0), "a", new Integer(1), new Boolean(true), new Double(2.0), new Double(0.24053641567148587), new Double(0.5975452777972018)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(0), new Boolean(false), new Double(0.0), new Double(0.6374174253501083), new Double(0.3332183994766498)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(5), new Boolean(true), new Double(2.0), new Double(0.6374174253501083), new Double(0.3851891847407185)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(2), new Boolean(false), null, new Double(0.6374174253501083), new Double(0.984841540199809))};
        FakeDataManager dataManager = new FakeDataManager();
        FakeDataStore.sampleData2(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    public void testDeterministicPostJoin() throws Exception {
        String leftQuery = "SELECT pm1.g1.e1 as ID, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1";
        String rightQuery = "SELECT pm2.g2.e1 as ID, pm2.g2.e2, pm2.g2.e3, pm2.g2.e4 FROM pm2.g2";
        String sql = "SELECT l.ID, l.e2, l.e3, l.e4, r.ID, r.e2, r.e3, r.e4, SQRT(100) AS SqrtTop FROM (" + leftQuery + ") AS l, (" + rightQuery + ") AS r WHERE l.ID = r.ID";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), new Boolean(false), new Double(2.0), "a", new Integer(1), new Boolean(true), new Double(2.0), new Double(10.0)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(0), new Boolean(false), new Double(0.0), new Double(10.0)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(5), new Boolean(true), new Double(2.0), new Double(10.0)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(2), new Boolean(false), null, new Double(10.0))};
        FakeDataManager dataManager = new FakeDataManager();
        FakeDataStore.sampleData2(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    public void testDeterministicPreJoin() throws Exception {
        String leftQuery = "SELECT pm1.g1.e1 as ID, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4, SQRT(100) AS SqrtLeft FROM pm1.g1";
        String rightQuery = "SELECT pm2.g2.e1 as ID, pm2.g2.e2, pm2.g2.e3, pm2.g2.e4 FROM pm2.g2";
        String sql = "SELECT l.ID, l.e2, l.e3, l.e4, r.ID, r.e2, r.e3, r.e4, l.SqrtLeft FROM (" + leftQuery + ") AS l, (" + rightQuery + ") AS r WHERE l.ID = r.ID";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), new Boolean(false), new Double(2.0), "a", new Integer(1), new Boolean(true), new Double(2.0), new Double(10.0)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(0), new Boolean(false), new Double(0.0), new Double(10.0)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(5), new Boolean(true), new Double(2.0), new Double(10.0)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(2), new Boolean(false), null, new Double(10.0))};
        FakeDataManager dataManager = new FakeDataManager();
        FakeDataStore.sampleData2(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    public void testDeterministicPrePostJoin() throws Exception {
        String leftQuery = "SELECT pm1.g1.e1 as ID, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4, SQRT(100) AS SqrtLeft FROM pm1.g1";
        String rightQuery = "SELECT pm2.g2.e1 as ID, pm2.g2.e2, pm2.g2.e3, pm2.g2.e4 FROM pm2.g2";
        String sql = "SELECT l.ID, l.e2, l.e3, l.e4, r.ID, r.e2, r.e3, r.e4, l.SqrtLeft, SQRT(100) AS SqrtTop FROM (" + leftQuery + ") AS l, (" + rightQuery + ") AS r WHERE l.ID = r.ID";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), new Boolean(false), new Double(2.0), "a", new Integer(1), new Boolean(true), new Double(2.0), new Double(10.0), new Double(10.0)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(0), new Boolean(false), new Double(0.0), new Double(10.0), new Double(10.0)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(5), new Boolean(true), new Double(2.0), new Double(10.0), new Double(10.0)), Arrays.asList("b", new Integer(1), new Boolean(true), null, "b", new Integer(2), new Boolean(false), null, new Double(10.0), new Double(10.0))};
        FakeDataManager dataManager = new FakeDataManager();
        FakeDataStore.sampleData2(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }
}

