/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.NavigableMap;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.datamgr.LanguageBridgeFactory;
import org.teiid.language.Call;
import org.teiid.metadata.Table;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.CommandCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.TestValidator;

public class TestProcedureResolving {
    private void helpFailUpdateProcedure(String procedure, String userUpdateStr, Table.TriggerEvent procedureType) {
        this.helpFailUpdateProcedure(procedure, userUpdateStr, procedureType, null);
    }

    private void helpFailUpdateProcedure(String procedure, String userUpdateStr, Table.TriggerEvent procedureType, String msg) {
        try {
            this.helpResolveUpdateProcedure(procedure, userUpdateStr, procedureType);
            Assert.fail((String)"Expected a QueryResolverException but got none.");
        }
        catch (QueryResolverException ex) {
            if (msg != null) {
                Assert.assertEquals((Object)msg, (Object)ex.getMessage());
            }
        }
        catch (TeiidComponentException e) {
            throw new RuntimeException(e);
        }
        catch (QueryParserException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testDefect13029_CorrectlySetUpdateProcedureTempGroupIDs() throws Exception {
        StringBuffer proc = new StringBuffer("FOR EACH ROW").append("\nBEGIN").append("\nDECLARE string var1;").append("\nvar1 = '';").append("\n  LOOP ON (SELECT pm1.g1.e1 FROM pm1.g1) AS loopCursor").append("\n  BEGIN").append("\n    LOOP ON (SELECT pm1.g2.e1 FROM pm1.g2 WHERE loopCursor.e1 = pm1.g2.e1) AS loopCursor2").append("\n    BEGIN").append("\n      var1 = CONCAT(var1, CONCAT(' ', loopCursor2.e1));").append("\n    END").append("\n  END").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        TriggerAction command = this.helpResolveUpdateProcedure(proc.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
        NavigableMap tempIDs = command.getTemporaryMetadata().getData();
        Assert.assertNotNull((Object)tempIDs);
        Assert.assertNull(tempIDs.get("LOOPCURSOR"));
        Assert.assertNull(tempIDs.get("LOOPCURSOR2"));
        Command subCommand = (Command)CommandCollectorVisitor.getCommands((Command)command).get(0);
        tempIDs = subCommand.getTemporaryMetadata().getData();
        Assert.assertNotNull((Object)tempIDs);
        Assert.assertNull(tempIDs.get("LOOPCURSOR"));
        Assert.assertNull(tempIDs.get("LOOPCURSOR2"));
        subCommand = (Command)CommandCollectorVisitor.getCommands((Command)command).get(1);
        tempIDs = subCommand.getTemporaryMetadata().getData();
        Assert.assertNotNull((Object)tempIDs);
        Assert.assertNotNull(tempIDs.get("LOOPCURSOR"));
        Assert.assertNull(tempIDs.get("LOOPCURSOR2"));
    }

    private TriggerAction helpResolveUpdateProcedure(String procedure, String userUpdateStr, Table.TriggerEvent procedureType) throws QueryParserException, QueryResolverException, TeiidComponentException {
        TransformationMetadata metadata = RealMetadataFactory.exampleUpdateProc(procedureType, procedure);
        return (TriggerAction)this.resolveProcedure(userUpdateStr, (QueryMetadataInterface)metadata);
    }

    private Command resolveProcedure(String userUpdateStr, QueryMetadataInterface metadata) throws QueryParserException, QueryResolverException, TeiidComponentException, QueryMetadataException {
        ProcedureContainer userCommand = (ProcedureContainer)QueryParser.getQueryParser().parseCommand(userUpdateStr);
        QueryResolver.resolveCommand((Command)userCommand, (QueryMetadataInterface)metadata);
        metadata = new TempMetadataAdapter(metadata, userCommand.getTemporaryMetadata());
        return QueryResolver.expandCommand((ProcedureContainer)userCommand, (QueryMetadataInterface)metadata, null);
    }

    private void helpResolveException(String userUpdateStr, QueryMetadataInterface metadata, String msg) throws QueryParserException, TeiidComponentException {
        try {
            this.helpResolve(userUpdateStr, metadata);
            Assert.fail();
        }
        catch (QueryResolverException e) {
            Assert.assertEquals((Object)msg, (Object)e.getMessage());
        }
    }

    private Command helpResolve(String userUpdateStr, QueryMetadataInterface metadata) throws QueryParserException, QueryResolverException, TeiidComponentException {
        return this.resolveProcedure(userUpdateStr, metadata);
    }

    @Test
    public void testDefect23257() throws Exception {
        CreateProcedureCommand command = (CreateProcedureCommand)this.helpResolve("EXEC pm6.vsp59()", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        CommandStatement cs = (CommandStatement)command.getBlock().getStatements().get(1);
        Insert insert = (Insert)cs.getCommand();
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.SHORT, (Object)((Expression)insert.getValues().get(1)).getType());
    }

    @Test
    public void testProcedureScoping() throws Exception {
        StringBuffer proc = new StringBuffer("FOR EACH ROW").append("\nBEGIN").append("\n  declare integer e1 = 1;").append("\n  e1 = e1;").append("\n  LOOP ON (SELECT pm1.g1.e1 FROM pm1.g1) AS loopCursor").append("\n  BEGIN").append("\n    variables.e1 = convert(e1, integer);").append("\n  END").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        TriggerAction command = this.helpResolveUpdateProcedure(proc.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
        Block block = command.getBlock();
        AssignmentStatement assStmt = (AssignmentStatement)block.getStatements().get(1);
        Assert.assertEquals((Object)"VARIABLES", (Object)assStmt.getVariable().getGroupSymbol().getName());
        Assert.assertEquals((Object)"VARIABLES", (Object)((ElementSymbol)assStmt.getExpression()).getGroupSymbol().getName());
        Block inner = ((LoopStatement)block.getStatements().get(2)).getBlock();
        assStmt = (AssignmentStatement)inner.getStatements().get(0);
        ElementSymbol value = (ElementSymbol)ElementCollectorVisitor.getElements((LanguageObject)assStmt.getExpression(), (boolean)false).iterator().next();
        Assert.assertEquals((Object)"loopCursor", (Object)value.getGroupSymbol().getName());
    }

    @Test(expected=QueryResolverException.class)
    public void testBlockResolving() throws Exception {
        StringBuffer proc = new StringBuffer("FOR EACH ROW").append("\nBEGIN").append("\n  declare integer e1 = 1;").append("\n  BEGIN").append("\n    variables.e1 = e2;").append("\n  END").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(proc.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure4() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE boolean var1;\n";
        procedure = procedure + "if(var1 =1);\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure5() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE boolean var1;\n";
        procedure = procedure + "var1 = var1 + var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1 whwre var1 = var1+var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure6() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(var1 =1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE boolean var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where var1 = pm1.g1.e3;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE, "Variable var1 was previously declared.");
    }

    @Test
    public void testCreateUpdateProcedure7() throws Exception {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(var1 =1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE boolean var2;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where var1 = pm1.g1.e1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure8() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(var1 =1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var2;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where var1 = pm1.g1.e1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "var2 = 1\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure9() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(var1 =1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE boolean var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where var1 = pm1.g1.e3;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "var1 = var1 +1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure24() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var2.var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure26() throws Exception {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer VARIABLES.var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure27() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer VARIABLES.var1.var2;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure28() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure29() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "var1 = 1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure30() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Declare integer var1;\n";
        procedure = procedure + "var1 = 'x' + ROWS_UPDATED;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure31() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Declare integer var1;\n";
        procedure = procedure + "var1 = 'x' + ROWS_UPDATED;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure32() throws Exception {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Declare integer var1;\n";
        procedure = procedure + "Select var1 from pm1.g1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure33() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(var1 =1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE timestamp var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where var1 = pm1.g1.e2;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "var1 = var1 +1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure34() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(pm1.g1.e2 =1 and var1=1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE, "TEIID31119 Symbol pm1.g1.e2 is specified with an unknown group context");
    }

    @Test
    public void testCreateUpdateProcedure36() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(pm1.g1.e2 =1 and var1=1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure39() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(pm1.g1.e2 =1 and var1=1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure53() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = INPUTS.e4;";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure54() throws Exception {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string var1;\n";
        procedure = procedure + "var1 = 1+1;";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testDefect14912_CreateUpdateProcedure57_FunctionWithElementParamInAssignmentStatement() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string var1;\n";
        procedure = procedure + "var1 = badFunction(badElement);";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userCommand = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userCommand, Table.TriggerEvent.UPDATE, "TEIID31118 Element \"badElement\" is not defined by any relevant group.");
    }

    @Test
    public void testCase4624() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE boolean var1;\n";
        procedure = procedure + "var1 = {b'false'};\n";
        procedure = procedure + "IF(var1 = {b 'true'})\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT Rack_ID, RACK_MDT_TYPE INTO #racks FROM Bert_MAP.BERT3.RACK;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userCommand = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userCommand, Table.TriggerEvent.UPDATE, "Group does not exist: Bert_MAP.BERT3.RACK");
    }

    @Test
    public void testCase5474() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer VARIABLES.NLEVELS;\n";
        procedure = procedure + "VARIABLES.NLEVELS = SELECT COUNT(*) FROM (SELECT oi.e1 AS Col1, oi.e2 AS Col2, oi.e3 FROM pm1.g2 AS oi) AS TOBJ, pm2.g2 AS TModel WHERE TModel.e3 = TOBJ.e3;\n";
        procedure = procedure + "END\n";
        TestResolver.helpResolve(procedure, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testProcWithReturn() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "call sptest9(1);\n";
        procedure = procedure + "END\n";
        TestResolver.helpResolve(procedure, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testIssue174102() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  \n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string crit = 'WHERE pm1.sq2.in = \"test\"';\n";
        procedure = procedure + "CREATE LOCAL TEMPORARY TABLE #TTable (e1 string);";
        procedure = procedure + "EXECUTE STRING ('SELECT e1 FROM pm1.sq2 ' || crit ) AS e1 string INTO #TTable;\n";
        procedure = procedure + "END\n";
        TestResolver.helpResolve(procedure, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testDeclareStatement() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer VARIABLES.var1 = VARIABLES.var1;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testDynamicIntoInProc() throws Exception {
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        StringBuffer procedure = new StringBuffer("FOR EACH ROW ").append("BEGIN\n").append("execute string 'SELECT e1, e2, e3, e4 FROM pm1.g2' as e1 string, e2 string, e3 string, e4 string INTO #myTempTable;\n").append("select e1 from #myTempTable;\n").append("END\n");
        this.helpResolveUpdateProcedure(procedure.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testDynamicStatement() throws Exception {
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        StringBuffer procedure = new StringBuffer("FOR EACH ROW ").append("BEGIN\n").append("execute string 'SELECT e1, e2, e3, e4 FROM pm1.g2';\n").append("END\n");
        this.helpResolveUpdateProcedure(procedure.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testDynamicStatementType() {
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        StringBuffer procedure = new StringBuffer("FOR EACH ROW ").append("BEGIN\n").append("DECLARE object VARIABLES.X = null;\n").append("execute string VARIABLES.X;\n").append("ROWS_UPDATED =0;\n").append("END\n");
        this.helpFailUpdateProcedure(procedure.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure1() throws Exception {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = 1, pm1.g1.e2 = var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1=1";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure3() throws Exception {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(var1 =1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testSelectIntoInProc() throws Exception {
        StringBuffer procedure = new StringBuffer("FOR EACH ROW ").append("BEGIN\n").append("SELECT e1, e2, e3, e4 INTO pm1.g1 FROM pm1.g2;\n").append("END\n");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
        procedure = new StringBuffer("FOR EACH ROW ").append("BEGIN\n").append("SELECT e1, e2, e3, e4 INTO #myTempTable FROM pm1.g2;\n").append("END\n");
        this.helpResolveUpdateProcedure(procedure.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testSelectIntoInProcNoFrom() throws Exception {
        StringBuffer procedure = new StringBuffer("FOR EACH ROW ").append("BEGIN\n").append("SELECT 'a', 19, {b'true'}, 13.999 INTO pm1.g1;\n").append("END\n");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
        procedure = new StringBuffer("FOR EACH ROW ").append("BEGIN\n").append("SELECT 'a', 19, {b'true'}, 13.999 INTO #myTempTable;\n").append("END\n");
        this.helpResolveUpdateProcedure(procedure.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testAssignInput() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "INPUTS.e1 = Select pm1.g1.e1 from pm1.g1;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testAssignChanging() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "CHANGING.e1 = Select pm1.g1.e1 from pm1.g1;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testVariableInInsert() {
        String procedure = "FOR EACH ROW  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Insert into pm1.g1 (pm1.g1.e2, var1) values (1, 2);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where e3= 1";
        this.helpFailUpdateProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE, "TEIID30126 Column variables do not reference columns on group \"pm1.g1\": [Unable to resolve 'var1': TEIID31118 Element \"var1\" is not defined by any relevant group.]");
    }

    @Test
    public void testVariableInInsert2() {
        String procedure = "FOR EACH ROW  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Insert into pm1.g1 (pm1.g1.e2, INPUTS.x) values (1, 2);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where e3= 1";
        this.helpFailUpdateProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE, "TEIID30126 Column variables do not reference columns on group \"pm1.g1\": [Unable to resolve 'INPUTS.x': TEIID31119 Symbol INPUTS.x is specified with an unknown group context]");
    }

    @Test
    public void testVariableInInsert3() throws Exception {
        String procedure = "FOR EACH ROW  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer e2;\n";
        procedure = procedure + "Insert into pm1.g1 (e2) values (1);\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where e3= 1";
        this.helpResolveUpdateProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testAmbigousInput() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN ATOMIC\n";
        procedure = procedure + "select e1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE, "TEIID31117 Element \"e1\" is ambiguous and should be qualified, at a single scope it exists in [CHANGING, \"NEW\", \"OLD\"]");
    }

    @Test
    public void testLoopRedefinition() {
        StringBuffer proc = new StringBuffer("FOR EACH ROW").append("\nBEGIN").append("\n  declare string var1;").append("\n  LOOP ON (SELECT pm1.g1.e1 FROM pm1.g1) AS loopCursor").append("\n  BEGIN").append("\n    LOOP ON (SELECT pm1.g2.e1 FROM pm1.g2 WHERE loopCursor.e1 = pm1.g2.e1) AS loopCursor").append("\n    BEGIN").append("\n      var1 = CONCAT(var1, CONCAT(' ', loopCursor.e1));").append("\n    END").append("\n  END").append("\n  END");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(proc.toString(), userUpdateStr, Table.TriggerEvent.UPDATE, "TEIID30124 Loop cursor or exception group name loopCursor already exists.");
    }

    @Test
    public void testTempGroupElementShouldNotBeResolable() {
        StringBuffer proc = new StringBuffer("FOR EACH ROW").append("\nBEGIN").append("\n  select 1 as a into #temp;").append("\n  select #temp.a from pm1.g1;").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(proc.toString(), userUpdateStr, Table.TriggerEvent.UPDATE, "TEIID31119 Symbol #temp.a is specified with an unknown group context");
    }

    @Test
    public void testTempGroupElementShouldNotBeResolable1() {
        StringBuffer proc = new StringBuffer("FOR EACH ROW").append("\nBEGIN").append("\n  select 1 as a into #temp;").append("\n  insert into #temp (a) values (#temp.a);").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(proc.toString(), userUpdateStr, Table.TriggerEvent.UPDATE, "TEIID31119 Symbol #temp.a is specified with an unknown group context");
    }

    @Test
    public void testProcedureCreate() throws Exception {
        StringBuffer proc = new StringBuffer("FOR EACH ROW").append("\nBEGIN").append("\n  create local temporary table t1 (e1 string);").append("\n  select e1 from t1;").append("\n  create local temporary table t1 (e1 string, e2 integer);").append("\n  select e2 from t1;").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(proc.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testProcedureCreate1() {
        StringBuffer proc = new StringBuffer("FOR EACH ROW").append("\nBEGIN").append("\n  LOOP ON (SELECT pm1.g1.e1 FROM pm1.g1) AS loopCursor").append("\n  BEGIN").append("\n  create local temporary table loopCursor (e1 string);").append("\nEND").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(proc.toString(), userUpdateStr, Table.TriggerEvent.UPDATE, "TEIID30118 Cannot create temporary table \"loopCursor\". An object with the same name already exists.");
    }

    @Test
    public void testProcedureCreateDrop() {
        StringBuffer proc = new StringBuffer("FOR EACH ROW").append("\nBEGIN").append("\n drop table t1;").append("\n  create local temporary table t1 (e1 string);").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(proc.toString(), userUpdateStr, Table.TriggerEvent.UPDATE, "Group does not exist: t1");
    }

    @Test
    public void testProcedureCreateDrop1() throws Exception {
        StringBuffer proc = new StringBuffer("FOR EACH ROW").append("\nBEGIN").append("\n  create local temporary table t1 (e1 string);").append("\n  drop table t1;").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(proc.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateAfterImplicitTempTable() throws Exception {
        StringBuffer proc = new StringBuffer("FOR EACH ROW").append("\nBEGIN").append("\n  select e1 into #temp from pm1.g1;").append("\n  create local temporary table #temp (e1 string);").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(proc.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testInsertAfterCreate() throws Exception {
        StringBuffer proc = new StringBuffer("FOR EACH ROW").append("\nBEGIN").append("\n  create local temporary table #temp (e1 string, e2 string);").append("\n  insert into #temp (e1) values ('a');").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(proc.toString(), userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testDefect16451() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN ATOMIC\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where e1 = NEW.e1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "delete from vm1.g1 where e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.DELETE, "TEIID31119 Symbol \"NEW\".e1 is specified with an unknown group context");
    }

    @Test
    public void testInvalidVirtualProcedure3() throws Exception {
        this.helpResolveException("EXEC pm1.vsp18()", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), "Group does not exist: temptable");
    }

    @Test
    public void testCreateUpdateProcedure2() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE boolean var1;\n";
        procedure = procedure + "ROWS_UPDATED = UPDATE pm1.g1 SET pm1.g1.e4 = convert(var1, string), pm1.g1.e1 = var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1=1";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE, "TEIID30082 Cannot set symbol 'pm1.g1.e4' with expected type double to expression 'convert(var1, string)'");
    }

    @Test
    public void testInvalidInputInUpdate() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN ATOMIC\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2, new.e2 from pm1.g1;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = new.e1, pm1.g1.e2 = new.e1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE, "TEIID30082 Cannot set symbol 'pm1.g1.e2' with expected type integer to expression '\"new\".e1'");
    }

    @Test
    public void testVirtualProcedure() throws Exception {
        this.helpResolve("EXEC pm1.vsp1()", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedure2() throws Exception {
        this.helpResolve("EXEC pm1.vsp14()", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedurePartialParameterReference() throws Exception {
        this.helpResolve("EXEC pm1.vsp58(5)", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedureInvalid1() throws Exception {
        this.helpResolveException("EXEC pm1.vsp32()", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), "TEIID30125 Cursor or exception group names cannot begin with \"#\" as that indicates the name of a temporary table: #mycursor.");
    }

    @Test
    public void testVirtualProcedureWithOrderBy() throws Exception {
        this.helpResolve("EXEC pm1.vsp29()", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedureWithTempTableAndOrderBy() throws Exception {
        this.helpResolve("EXEC pm1.vsp33()", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedureWithConstAndOrderBy() throws Exception {
        this.helpResolve("EXEC pm1.vsp34()", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedureWithNoFromAndOrderBy() throws Exception {
        this.helpResolve("EXEC pm1.vsp28()", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidVirtualProcedure2() throws Exception {
        this.helpResolveException("EXEC pm1.vsp12()", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), "TEIID31119 Symbol mycursor.e2 is specified with an unknown group context");
    }

    @Test
    public void testLoopRedefinition2() throws Exception {
        this.helpResolveException("EXEC pm1.vsp11()", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), "TEIID30124 Loop cursor or exception group name mycursor already exists.");
    }

    @Test
    public void testVariableResolutionWithIntervening() throws Exception {
        StringBuffer proc = new StringBuffer("CREATE VIRTUAL PROCEDURE").append("\nBEGIN").append("\n  declare string x;").append("\n  x = '1';").append("\n  declare string y;").append("\n  y = '1';").append("\nEND");
        TestResolver.helpResolve(proc.toString(), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testVDBQualified() throws Exception {
        this.helpResolve("EXEC example1.pm1.vsp29()", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testOptionalParams() throws Exception {
        String ddl = "create foreign procedure proc (x integer, y string);\n";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call proc (1)";
        StoredProcedure sp = (StoredProcedure)TestResolver.helpResolve(sql, (QueryMetadataInterface)tm);
        Assert.assertEquals((Object)new Constant(null, DataTypeManager.DefaultDataClasses.STRING), (Object)sp.getParameter(2).getExpression());
        sql = "call proc (1, 'a')";
        sp = (StoredProcedure)TestResolver.helpResolve(sql, (QueryMetadataInterface)tm);
        Assert.assertEquals((Object)new Constant((Object)"a", DataTypeManager.DefaultDataClasses.STRING), (Object)sp.getParameter(2).getExpression());
    }

    public static TransformationMetadata createMetadata(String ddl) throws Exception {
        return RealMetadataFactory.fromDDL(ddl, "test", "test");
    }

    @Test
    public void testOptionalParams1() throws Exception {
        String ddl = "create foreign procedure proc (x integer, y string NOT NULL, z integer);\n";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call proc (1, 'a')";
        StoredProcedure sp = (StoredProcedure)TestResolver.helpResolve(sql, (QueryMetadataInterface)tm);
        Assert.assertEquals((Object)new Constant((Object)"a", DataTypeManager.DefaultDataClasses.STRING), (Object)sp.getParameter(2).getExpression());
    }

    @Test
    public void testVarArgs() throws Exception {
        String ddl = "create foreign procedure proc (x integer, VARIADIC z integer) returns (x string);\n";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call proc (1, 2, 3)";
        StoredProcedure sp = (StoredProcedure)TestResolver.helpResolve(sql, (QueryMetadataInterface)tm);
        Assert.assertEquals((Object)"EXEC proc(1, 2, 3)", (Object)sp.toString());
        Assert.assertEquals((Object)new Constant((Object)1), (Object)sp.getParameter(1).getExpression());
        Assert.assertEquals((Object)new Array(DataTypeManager.DefaultDataClasses.INTEGER, Arrays.asList(new Constant((Object)2), new Constant((Object)3))), (Object)sp.getParameter(2).getExpression());
        Assert.assertEquals((long)5L, (long)sp.getParameter(3).getParameterType());
        sql = "call proc (1)";
        sp = (StoredProcedure)TestResolver.helpResolve(sql, (QueryMetadataInterface)tm);
        Assert.assertEquals((Object)"EXEC proc(1)", (Object)sp.toString());
        Assert.assertEquals((Object)new Array(DataTypeManager.DefaultDataClasses.INTEGER, new ArrayList(0)), (Object)sp.getParameter(2).getExpression());
        sp = (StoredProcedure)QueryRewriter.evaluateAndRewrite((Command)sp, (Evaluator)new Evaluator(null, null, null), null, (QueryMetadataInterface)tm);
        LanguageBridgeFactory lbf = new LanguageBridgeFactory((QueryMetadataInterface)tm);
        Call call = (Call)lbf.translate((Command)sp);
        Assert.assertEquals((Object)"EXEC proc(1)", (Object)call.toString());
        sql = "call proc (1, (2, 3))";
        sp = (StoredProcedure)TestResolver.helpResolve(sql, (QueryMetadataInterface)tm);
        Assert.assertEquals((Object)"EXEC proc(1, (2, 3))", (Object)sp.toString());
        Assert.assertEquals((Object)new Constant((Object)1), (Object)sp.getParameter(1).getExpression());
        Assert.assertEquals((Object)new Array(DataTypeManager.DefaultDataClasses.INTEGER, Arrays.asList(new Constant((Object)2), new Constant((Object)3))), (Object)sp.getParameter(2).getExpression());
        Assert.assertEquals((long)5L, (long)sp.getParameter(3).getParameterType());
    }

    @Test
    public void testVarArgs1() throws Exception {
        String ddl = "create foreign procedure proc (VARIADIC z integer) returns (x string);\n";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call proc ()";
        StoredProcedure sp = (StoredProcedure)TestResolver.helpResolve(sql, (QueryMetadataInterface)tm);
        Assert.assertEquals((Object)"EXEC proc()", (Object)sp.toString());
        Assert.assertEquals((Object)new Array(DataTypeManager.DefaultDataClasses.INTEGER, new ArrayList(0)), (Object)sp.getParameter(1).getExpression());
        sp = (StoredProcedure)QueryRewriter.evaluateAndRewrite((Command)sp, (Evaluator)new Evaluator(null, null, null), null, (QueryMetadataInterface)tm);
        LanguageBridgeFactory lbf = new LanguageBridgeFactory((QueryMetadataInterface)tm);
        Call call = (Call)lbf.translate((Command)sp);
        Assert.assertEquals((Object)"EXEC proc()", (Object)call.toString());
        Assert.assertEquals((long)0L, (long)call.getArguments().size());
    }

    @Test
    public void testVarArgs2() throws Exception {
        String ddl = "create foreign procedure proc (VARIADIC z object) returns (x string);\n";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call proc ()";
        StoredProcedure sp = (StoredProcedure)TestResolver.helpResolve(sql, (QueryMetadataInterface)tm);
        Assert.assertEquals((Object)"EXEC proc()", (Object)sp.toString());
        Assert.assertEquals((Object)new Array(DataTypeManager.DefaultDataClasses.OBJECT, new ArrayList(0)), (Object)sp.getParameter(1).getExpression());
        sql = "call proc (1, (2, 3))";
        sp = (StoredProcedure)TestResolver.helpResolve(sql, (QueryMetadataInterface)tm);
        Assert.assertEquals((Object)"EXEC proc(1, (2, 3))", (Object)sp.toString());
        ArrayList<Object> expressions = new ArrayList<Object>();
        expressions.add(new Constant((Object)1));
        expressions.add(new Array(DataTypeManager.DefaultDataClasses.INTEGER, Arrays.asList(new Constant((Object)2), new Constant((Object)3))));
        Assert.assertEquals((Object)new Array(DataTypeManager.DefaultDataClasses.OBJECT, expressions), (Object)sp.getParameter(1).getExpression());
    }

    @Test
    public void testAnonBlock() throws Exception {
        String sql = "begin select 1 as something; end";
        CreateProcedureCommand sp = (CreateProcedureCommand)TestResolver.helpResolve(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals((long)1L, (long)sp.getResultSetColumns().size());
        Assert.assertEquals((Object)"something", (Object)Symbol.getName((Expression)((Expression)sp.getResultSetColumns().get(0))));
        Assert.assertEquals((long)1L, (long)sp.getProjectedSymbols().size());
        Assert.assertTrue((boolean)sp.returnsResultSet());
    }

    @Test
    public void testAnonBlockNoResult() throws Exception {
        String sql = "begin select 1 as something without return; end";
        CreateProcedureCommand sp = (CreateProcedureCommand)TestResolver.helpResolve(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals((long)0L, (long)sp.getProjectedSymbols().size());
        Assert.assertFalse((boolean)sp.returnsResultSet());
    }

    @Test
    public void testReturnAndResultSet() throws Exception {
        String ddl = "CREATE FOREIGN PROCEDURE proc (OUT param STRING RESULT) RETURNS TABLE (a INTEGER, b STRING);";
        TransformationMetadata tm = RealMetadataFactory.fromDDL(ddl, "x", "y");
        StoredProcedure sp = (StoredProcedure)TestResolver.helpResolve("exec proc()", (QueryMetadataInterface)tm);
        Assert.assertEquals((long)2L, (long)sp.getProjectedSymbols().size());
        Assert.assertEquals((Object)"y.proc.b", (Object)sp.getProjectedSymbols().get(1).toString());
        Assert.assertTrue((boolean)sp.returnsResultSet());
        sp.setCallableStatement(true);
        Assert.assertEquals((long)3L, (long)sp.getProjectedSymbols().size());
        Assert.assertEquals((Object)"y.proc.param", (Object)sp.getProjectedSymbols().get(2).toString());
        CreateProcedureCommand cpc = (CreateProcedureCommand)TestResolver.helpResolve("begin exec proc(); end", (QueryMetadataInterface)tm);
        Assert.assertEquals((long)2L, (long)cpc.getProjectedSymbols().size());
        Assert.assertEquals((long)2L, (long)((CommandStatement)cpc.getBlock().getStatements().get(0)).getCommand().getProjectedSymbols().size());
        Assert.assertTrue((boolean)cpc.returnsResultSet());
        TestValidator.helpValidate("begin declare string var; var = exec proc(); select var; end", new String[]{"SELECT var;"}, (QueryMetadataInterface)tm);
    }

    @Test
    public void testDotInName() throws Exception {
        String ddl = "CREATE FOREIGN PROCEDURE \"my.proc\" (param STRING) RETURNS TABLE (a INTEGER, b STRING);";
        TransformationMetadata tm = RealMetadataFactory.fromDDL(ddl, "x", "y");
        StoredProcedure sp = (StoredProcedure)TestResolver.helpResolve("exec \"my.proc\"()", (QueryMetadataInterface)tm);
        Assert.assertEquals((long)2L, (long)sp.getProjectedSymbols().size());
        Assert.assertEquals((Object)"y.my.proc.b", (Object)sp.getProjectedSymbols().get(1).toString());
        TestValidator.helpValidate("begin exec proc(); end", new String[0], (QueryMetadataInterface)tm);
    }
}

