/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import javax.resource.spi.work.WorkManager;
import org.jboss.deployers.spi.DeploymentException;
import org.mockito.Mockito;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.DQP;
import org.teiid.client.security.ILogon;
import org.teiid.common.queue.FakeWorkManager;
import org.teiid.deployers.MetadataStoreGroup;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManager;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.impl.FakeTransactionService;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.FakeBufferService;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.TransactionService;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.EmbeddedProfile;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.index.IndexMetadataFactory;
import org.teiid.metadata.index.VDBMetadataFactory;
import org.teiid.net.ServerConnection;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.services.SessionServiceImpl;
import org.teiid.translator.TranslatorException;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LocalServerConnection;
import org.teiid.transport.LogonImpl;

public class FakeServer
extends ClientServiceRegistryImpl {
    SessionServiceImpl sessionService = new SessionServiceImpl();
    LogonImpl logon;
    DQPCore dqp = new DQPCore();
    VDBRepository repo = new VDBRepository();
    MetadataStore systemStore;

    public FakeServer() {
        this.logon = new LogonImpl((SessionService)this.sessionService, null);
        this.systemStore = VDBMetadataFactory.getSystemVDBMetadataStore();
        this.repo.setSystemStore(this.systemStore);
        this.sessionService.setVDBRepository(this.repo);
        this.dqp.setWorkManager((WorkManager)new FakeWorkManager());
        this.dqp.setBufferService((BufferService)new FakeBufferService());
        this.dqp.setTransactionService((TransactionService)new FakeTransactionService());
        ConnectorManagerRepository cmr = (ConnectorManagerRepository)Mockito.mock(ConnectorManagerRepository.class);
        Mockito.stub((Object)cmr.getConnectorManager("source")).toReturn((Object)new ConnectorManager("x", "x"){

            public SourceCapabilities getCapabilities() throws TranslatorException {
                return new BasicSourceCapabilities();
            }
        });
        this.dqp.setConnectorManagerRepository(cmr);
        this.dqp.start(new DQPConfiguration());
        this.sessionService.setDqp(this.dqp);
        this.registerClientService(ILogon.class, this.logon, null);
        this.registerClientService(DQP.class, this.dqp, null);
    }

    public void deployVDB(String vdbName, String vdbPath) throws Exception {
        ModelMetaData model;
        IndexMetadataFactory imf = VDBMetadataFactory.loadMetadata((URL)new File(vdbPath).toURI().toURL());
        MetadataStore metadata = imf.getMetadataStore();
        VDBMetaData vdbMetaData = new VDBMetaData();
        vdbMetaData.setName(vdbName);
        vdbMetaData.setStatus(VDB.Status.ACTIVE);
        for (Schema schema : this.systemStore.getSchemas().values()) {
            model = new ModelMetaData();
            model.setName(schema.getName());
            vdbMetaData.addModel(model);
            model.addSourceMapping("source", "translator", "jndi:source");
        }
        for (Schema schema : metadata.getSchemas().values()) {
            model = new ModelMetaData();
            model.setName(schema.getName());
            vdbMetaData.addModel(model);
            model.addSourceMapping("source", "translator", "jndi:source");
        }
        try {
            MetadataStoreGroup stores = new MetadataStoreGroup();
            stores.addStore(metadata);
            this.repo.addVDB(vdbMetaData, stores, imf.getEntriesPlusVisibilities(), null);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    public void undeployVDB(String vdbName) {
        this.repo.removeVDB(vdbName, 1);
    }

    public void mergeVDBS(String sourceVDB, String targetVDB) throws AdminException {
        this.repo.mergeVDBs(sourceVDB, 1, targetVDB, 1);
    }

    public ConnectionImpl createConnection(String embeddedURL) throws Exception {
        Properties p = new Properties();
        EmbeddedProfile.parseURL((String)embeddedURL, (Properties)p);
        return new ConnectionImpl((ServerConnection)new LocalServerConnection(p){

            protected ClientServiceRegistry getClientServiceRegistry() {
                return FakeServer.this;
            }
        }, p, embeddedURL);
    }
}

