/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TeiidStatement;

public class TestQueryPlans {
    private Connection conn;

    @Before
    public void setUp() throws Exception {
        FakeServer server = new FakeServer();
        server.deployVDB("test", UnitTestUtil.getTestDataPath() + "/TestCase3473/test.vdb");
        this.conn = server.createConnection("jdbc:teiid:test");
    }

    @Test
    public void testNoExec() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("set noexec on");
        ResultSet rs = s.executeQuery("select * from all_tables");
        Assert.assertFalse((boolean)rs.next());
        s.execute("SET NOEXEC off");
        rs = s.executeQuery("select * from all_tables");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testShowPlan() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("set showplan on");
        ResultSet rs = s.executeQuery("select * from all_tables");
        Assert.assertNotNull((Object)s.unwrap(TeiidStatement.class).getPlanDescription());
        Assert.assertNull((Object)s.unwrap(TeiidStatement.class).getDebugLog());
        s.execute("SET showplan debug");
        rs = s.executeQuery("select * from all_tables");
        Assert.assertNotNull((Object)s.unwrap(TeiidStatement.class).getDebugLog());
        s.execute("SET showplan off");
        rs = s.executeQuery("select * from all_tables");
        Assert.assertNull((Object)s.unwrap(TeiidStatement.class).getPlanDescription());
        Assert.assertTrue((boolean)rs.next());
    }
}

