/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;

public class TestVDBMerge
extends AbstractMMQueryTestCase {
    private static final String VDB1 = "PartsSupplier";
    private static final String VDB2 = "QT_Ora9DS";
    FakeServer server = new FakeServer();

    @Test
    public void testMerge() throws Throwable {
        this.server.deployVDB(VDB1, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        this.internalConnection = this.server.createConnection("jdbc:teiid:PartsSupplier");
        String[] expected = new String[]{"VDBName[string]    SchemaName[string]    Name[string]    Type[string]    NameInSource[string]    IsPhysical[boolean]    SupportsUpdates[boolean]    UID[string]    Cardinality[integer]    Description[string]    IsSystem[boolean]    IsMaterialized[boolean]", "PartsSupplier    PartsSupplier    PARTSSUPPLIER.PARTS    Table    PARTS    true    true    mmuuid:f6276601-73fe-1edc-a81c-ecf397b10590    16    null    false    false", "PartsSupplier    PartsSupplier    PARTSSUPPLIER.SHIP_VIA    Table    SHIP_VIA    true    true    mmuuid:0f4e9b80-73ff-1edc-a81c-ecf397b10590    4    null    false    false", "PartsSupplier    PartsSupplier    PARTSSUPPLIER.STATUS    Table    STATUS    true    true    mmuuid:1f297200-73ff-1edc-a81c-ecf397b10590    3    null    false    false", "PartsSupplier    PartsSupplier    PARTSSUPPLIER.SUPPLIER_PARTS    Table    SUPPLIER_PARTS    true    true    mmuuid:3deafb00-73ff-1edc-a81c-ecf397b10590    227    null    false    false", "PartsSupplier    PartsSupplier    PARTSSUPPLIER.SUPPLIER    Table    SUPPLIER    true    true    mmuuid:2c371ec0-73ff-1edc-a81c-ecf397b10590    16    null    false    false"};
        this.executeTest("select * from tables where schemaname ='PartsSupplier'", expected);
        String[] expectedBefore = new String[]{"VDBName[string]    SchemaName[string]    Name[string]    Type[string]    NameInSource[string]    IsPhysical[boolean]    SupportsUpdates[boolean]    UID[string]    Cardinality[integer]    Description[string]    IsSystem[boolean]    IsMaterialized[boolean]"};
        String[] expectedAfter = new String[]{"VDBName[string]    SchemaName[string]    Name[string]    Type[string]    NameInSource[string]    IsPhysical[boolean]    SupportsUpdates[boolean]    UID[string]    Cardinality[integer]    Description[string]    IsSystem[boolean]    IsMaterialized[boolean]", "PartsSupplier    BQT1    HugeA    Table    null    true    false    mmuuid:7c66fc80-33d2-1dfa-9931-e83d04ce10a0    500000    null    false    false", "PartsSupplier    BQT1    HugeB    Table    null    true    false    mmuuid:b0369400-33f8-1dfa-9931-e83d04ce10a0    500000    null    false    false", "PartsSupplier    BQT1    LargeA    Table    null    true    false    mmuuid:3976a800-33b2-1dfa-9931-e83d04ce10a0    10000    null    false    false", "PartsSupplier    BQT1    LargeB    Table    null    true    false    mmuuid:5fb40600-33c3-1dfa-9931-e83d04ce10a0    10000    null    false    false", "PartsSupplier    BQT1    MediumA    Table    null    true    false    mmuuid:61074980-338d-1dfa-9931-e83d04ce10a0    1000    null    false    false", "PartsSupplier    BQT1    MediumB    Table    null    true    false    mmuuid:e24bd1c0-33a4-1dfa-9931-e83d04ce10a0    1000    null    false    false", "PartsSupplier    BQT1    SmallA    Table    null    true    false    mmuuid:0968424f-e6a0-1df9-ac06-b890ff96f710    50    null    false    false", "PartsSupplier    BQT1    SmallB    Table    null    true    false    mmuuid:06fb8980-3377-1dfa-9931-e83d04ce10a0    50    null    false    false"};
        this.executeTest("select * from tables where schemaname='BQT1'", expectedBefore);
        this.internalConnection.close();
        this.server.deployVDB(VDB2, UnitTestUtil.getTestDataPath() + "/QT_Ora9DS_1.vdb");
        this.server.mergeVDBS(VDB2, VDB1);
        this.internalConnection = this.server.createConnection("jdbc:teiid:PartsSupplier");
        this.executeTest("select * from tables where schemaname='BQT1'", expectedAfter);
        this.server.undeployVDB(VDB2);
        this.executeTest("select * from tables where schemaname='BQT1'", expectedAfter);
        this.internalConnection.close();
        this.internalConnection = this.server.createConnection("jdbc:teiid:PartsSupplier");
        this.executeTest("select * from tables where schemaname='BQT1'", expectedBefore);
        this.executeTest("select * from tables where schemaname ='PartsSupplier'", expected);
    }

    private void executeTest(String sql, String[] expected) {
        this.execute(sql);
        this.assertResults(expected);
    }
}

