/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;

public class TestResultSetMetadata
extends AbstractMMQueryTestCase {
    private static final String VDB = "PartsSupplier";

    public TestResultSetMetadata() {
        this.DELIMITER = "\t";
    }

    @Before
    public void setUp() throws Exception {
        FakeServer server = new FakeServer();
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        this.internalConnection = server.createConnection("jdbc:teiid:PartsSupplier");
    }

    @Override
    @After
    public void tearDown() throws SQLException {
        this.closeConnection();
    }

    private void executeTest(String sql, String[] expected) throws Exception {
        this.execute(sql);
        ResultSet rs = this.internalResultSet;
        this.assertResultsSetMetadataEquals(rs.getMetaData(), expected);
    }

    private void executePreparedTest(String sql, String[] expected) throws Exception {
        this.execute(sql, new Object[0]);
        ResultSet rs = this.internalResultSet;
        this.assertResultsSetMetadataEquals(rs.getMetaData(), expected);
    }

    @Test
    public void testCount() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "count\t4\tinteger\tjava.lang.Integer\t1\tnull\tnull\tPartsSupplier"};
        this.executeTest("select count(*) from parts where 1=0", expected);
    }

    @Test
    public void testStar() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "PART_ID\t12\tstring\tjava.lang.String\t0\tPARTSSUPPLIER.PARTS\tPartsSupplier\tPartsSupplier", "PART_NAME\t12\tstring\tjava.lang.String\t1\tPARTSSUPPLIER.PARTS\tPartsSupplier\tPartsSupplier", "PART_COLOR\t12\tstring\tjava.lang.String\t1\tPARTSSUPPLIER.PARTS\tPartsSupplier\tPartsSupplier", "PART_WEIGHT\t12\tstring\tjava.lang.String\t1\tPARTSSUPPLIER.PARTS\tPartsSupplier\tPartsSupplier"};
        this.executeTest("select * from parts where 1=0", expected);
    }

    @Test
    public void testTempGroupStar() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "PART_ID\t12\tstring\tjava.lang.String\t0\tFOO\tnull\tPartsSupplier", "PART_NAME\t12\tstring\tjava.lang.String\t1\tFOO\tnull\tPartsSupplier", "PART_COLOR\t12\tstring\tjava.lang.String\t1\tFOO\tnull\tPartsSupplier", "PART_WEIGHT\t12\tstring\tjava.lang.String\t1\tFOO\tnull\tPartsSupplier"};
        this.executeTest("select * from (select * from parts) foo where 1=0", expected);
    }

    @Test
    public void testCountAndElement() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "count\t4\tinteger\tjava.lang.Integer\t1\tnull\tnull\tPartsSupplier", "part_name\t12\tstring\tjava.lang.String\t1\tPARTSSUPPLIER.PARTS\tPartsSupplier\tPartsSupplier"};
        this.executeTest("select count(*), part_name from parts where 1=0 group by part_name", expected);
    }

    @Test
    public void testStar_PreparedStatement() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "PART_ID\t12\tstring\tjava.lang.String\t0\tPARTSSUPPLIER.PARTS\tPartsSupplier\tPartsSupplier", "PART_NAME\t12\tstring\tjava.lang.String\t1\tPARTSSUPPLIER.PARTS\tPartsSupplier\tPartsSupplier", "PART_COLOR\t12\tstring\tjava.lang.String\t1\tPARTSSUPPLIER.PARTS\tPartsSupplier\tPartsSupplier", "PART_WEIGHT\t12\tstring\tjava.lang.String\t1\tPARTSSUPPLIER.PARTS\tPartsSupplier\tPartsSupplier"};
        this.executePreparedTest("select * from parts where 1=0", expected);
    }

    @Test
    public void testCount_PreparedStatement() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "count\t4\tinteger\tjava.lang.Integer\t1\tnull\tnull\tPartsSupplier"};
        this.executePreparedTest("select count(*) from parts where 1=0", expected);
    }

    @Test
    public void testCountAndElement_PreparedStatement() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "count\t4\tinteger\tjava.lang.Integer\t1\tnull\tnull\tPartsSupplier", "part_name\t12\tstring\tjava.lang.String\t1\tPARTSSUPPLIER.PARTS\tPartsSupplier\tPartsSupplier"};
        this.executePreparedTest("select count(*), part_name from parts where 1=0 group by part_name", expected);
    }
}

