/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TestMMDatabaseMetaData;

public class TestSystemVirtualModel
extends AbstractMMQueryTestCase {
    private static final String VDB = "PartsSupplier";

    public TestSystemVirtualModel() {
        this.DELIMITER = "\t";
    }

    @Before
    public void setUp() throws Exception {
        FakeServer server = new FakeServer();
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        this.internalConnection = server.createConnection("jdbc:teiid:PartsSupplier");
    }

    protected void checkResult(String testName, String query) throws Exception {
        this.execute(query);
        TestMMDatabaseMetaData.compareResultSet("TestSystemVirtualModel/" + testName, this.internalResultSet);
    }

    @Test
    public void testModels() throws Exception {
        this.checkResult("testSchemas", "select* from SYS.Schemas order by Name");
    }

    @Test
    public void testKeys() throws Exception {
        this.checkResult("testKeys", "select* from SYS.Keys order by Name");
    }

    @Test
    public void testGroups() throws Exception {
        this.checkResult("testTables", "select* from SYS.Tables order by Name");
    }

    @Test
    public void testDataTypes() throws Exception {
        this.checkResult("testDataTypes", "select * from SYS.DataTypes order by name");
    }

    @Test
    public void testProcedureParams() throws Exception {
        this.checkResult("testProcedureParams", "select * from SYS.ProcedureParams order by Name");
    }

    @Test
    public void testProcedures() throws Exception {
        this.checkResult("testProcedures", "select* from SYS.Procedures order by Name");
    }

    @Test
    public void testProperties() {
        String[] expected = new String[]{"Name[string]\tValue[string]\tUID[string]\tOID[integer]"};
        this.executeAndAssertResults("select* from SYS.Properties", expected);
    }

    @Test
    public void testVirtualDatabase() {
        String[] expected = new String[]{"Name[string]\tVersion[string]\t", "PartsSupplier\t1"};
        this.executeAndAssertResults("select* from SYS.VirtualDatabases", expected);
    }

    @Test
    public void testKeyColumns() throws Exception {
        this.checkResult("testKeyColumns", "select* from SYS.KeyColumns order by Name, KeyName");
    }

    @Test
    public void testVDBResourcePathsProcedure() {
        String[] expected = new String[]{"ResourcePath[string]\tisBinary[boolean]", "/parts/partsmd/PartsSupplier.xmi\tfalse", "/ConfigurationInfo.def\tfalse", "/MetaMatrix-VdbManifestModel.xmi\tfalse"};
        this.execute("exec getVDBResourcePaths()", new Object[0]);
        this.assertResults(expected);
    }

    @Test
    public void testColumns() throws Exception {
        this.checkResult("testColumns", "select* from SYS.Columns order by Name");
    }

    @Test
    public void testTableType() {
        String[] expected = new String[]{"Type[string]\t", "Table"};
        this.executeAndAssertResults("select distinct Type from SYS.Tables order by Type", expected);
    }

    @Test
    public void testTableIsSystem() throws Exception {
        this.checkResult("testTableIsSystem", "select Name from SYS.Tables where IsSystem = 'false' order by Name");
    }

    @Test
    public void testDefect12064() {
        String[] expected = new String[]{"KeyName[string]\tRefKeyUID[string]\t", "PK_PARTS\tnull", "PK_SHIP_VIA\tnull", "PK_STATUS\tnull", "PK_SUPPLIER\tnull", "PK_SUPPLIER_PARTS\tnull", "PK_SUPPLIER_PARTS\tnull", "pk_pg_attr\tnull", "pk_pg_class\tnull", "pk_pg_index\tnull", "pk_pg_proc\tnull"};
        this.executeAndAssertResults("select KeyName, RefKeyUID FROM SYS.KeyColumns WHERE RefKeyUID IS NULL order by KeyName", expected);
    }

    @Test
    public void testReferenceKeyColumns() throws Exception {
        this.checkResult("testReferenceKeyColumns", "select* FROM SYS.ReferenceKeyColumns order by PKTABLE_NAME");
    }

    @Test
    public void test_UID_OID_are_Equal() throws Exception {
        this.execute("select distinct(UID) FROM SYS.Schemas");
        int uidCount = this.getRowCount();
        this.execute("select distinct(OID) FROM SYS.Schemas");
        int oidCount = this.getRowCount();
        Assert.assertEquals((long)uidCount, (long)oidCount);
        this.execute("select distinct(UID) FROM SYS.DataTypes");
        uidCount = this.getRowCount();
        this.execute("select distinct(OID) FROM SYS.DataTypes");
        oidCount = this.getRowCount();
        Assert.assertEquals((long)uidCount, (long)oidCount);
    }
}

