/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TestMMDatabaseMetaData;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;

public class TestJDBCSocketTransport {
    static InetSocketAddress addr;
    static SocketListener jdbcTransport;
    Connection conn;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        SocketConfiguration config = new SocketConfiguration();
        config.setSSLConfiguration(new SSLConfiguration());
        addr = new InetSocketAddress(0);
        config.setBindAddress(addr.getHostName());
        config.setPortNumber(0);
        DQPConfiguration dqpConfig = new DQPConfiguration();
        dqpConfig.setMaxActivePlans(2);
        FakeServer server = new FakeServer(dqpConfig);
        server.setUseCallingThread(false);
        server.deployVDB("parts", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        jdbcTransport = new SocketListener(config, (ClientServiceRegistryImpl)server, (StorageManager)BufferManagerFactory.getStandaloneBufferManager(), 0);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        if (jdbcTransport != null) {
            jdbcTransport.stop();
        }
    }

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        this.conn = TeiidDriver.getInstance().connect("jdbc:teiid:parts@mm://" + addr.getHostName() + ":" + jdbcTransport.getPort(), p);
    }

    @After
    public void tearDown() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Test
    public void testSelect() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables order by name"));
        TestMMDatabaseMetaData.compareResultSet(s.getResultSet());
    }

    @Test
    public void testLobStreaming() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select xmlelement(name \"root\") from tables"));
        s.getResultSet().next();
        Assert.assertEquals((Object)"<root></root>", (Object)s.getResultSet().getString(1));
    }

    @Test
    public void testXmlTableScrollable() throws Exception {
        Statement s = this.conn.createStatement(1004, 1007);
        Assert.assertTrue((boolean)s.execute("select * from xmltable('/root/row' passing (select xmlelement(name \"root\", xmlagg(xmlelement(name \"row\", xmlforest(t.name)) order by t.name)) from tables as t, columns as t1) columns \"Name\" string) as x"));
        ResultSet rs = s.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((long)7812L, (long)count);
        rs.beforeFirst();
        while (rs.next()) {
            --count;
        }
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testSimultaneousLargeSelects() throws Exception {
        for (int j = 0; j < 3; ++j) {
            Statement s = this.conn.createStatement();
            Assert.assertTrue((boolean)s.execute("select * from columns c1, columns c2"));
        }
    }
}

