/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TestMMDatabaseMetaData;

public class TestPartsDatabaseMetadata {
    static DatabaseMetaData dbMetadata;
    static Connection connection;
    static final String VDB = "PartsSupplier";

    @BeforeClass
    public static void setUp() throws Exception {
        FakeServer server = new FakeServer();
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        connection = server.createConnection("jdbc:teiid:PartsSupplier");
        dbMetadata = connection.getMetaData();
    }

    @AfterClass
    public static void tearDown() throws SQLException {
        connection.close();
    }

    @Test
    public void testExportedKeys() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(dbMetadata.getExportedKeys(VDB, null, "%"));
    }

    @Test
    public void testImportedKeys() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(dbMetadata.getImportedKeys(VDB, null, "%"));
    }

    @Test
    public void testPrimaryKeys() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(dbMetadata.getPrimaryKeys(VDB, null, "%"));
    }

    @Test
    public void testProcedures() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(dbMetadata.getProcedures(VDB, null, "%"));
    }

    @Test
    public void testProcedureColumns() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(dbMetadata.getProcedureColumns(VDB, null, "%", "%"));
    }

    @Test
    public void testUDTs() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(dbMetadata.getUDTs(VDB, null, "%", null));
    }

    @Test
    public void testIndexInfo() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(dbMetadata.getIndexInfo(VDB, null, "%", true, true));
    }

    @Test
    public void testCrossReference() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(dbMetadata.getCrossReference(VDB, null, "%", VDB, null, "%"));
    }

    @Test
    public void testTypeInfo() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(dbMetadata.getTypeInfo());
    }

    @Test
    public void testCatalogs() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(dbMetadata.getCatalogs());
    }

    @Test
    public void testSchemas() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(dbMetadata.getSchemas());
    }

    @Test
    public void testTables() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(dbMetadata.getTables(VDB, null, "%", null));
    }

    @Test
    public void testColumns() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(dbMetadata.getColumns(VDB, null, "%", "%"));
    }
}

