/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.index.VDBMetadataFactory;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.teiid.TeiidExecutionFactory;

public class TestDymamicImportedMetaData {
    FakeServer server;

    @Before
    public void setup() {
        this.server = new FakeServer();
    }

    @After
    public void teardown() {
        this.server.stop();
    }

    private MetadataFactory getMetadata(Properties importProperties, Connection conn) throws TranslatorException {
        MetadataFactory mf = this.createMetadataFactory("test", importProperties);
        TeiidExecutionFactory tef = new TeiidExecutionFactory();
        tef.getMetadata(mf, conn);
        return mf;
    }

    private MetadataFactory createMetadataFactory(String schema, Properties importProperties) {
        VDBRepository vdbRepository = new VDBRepository();
        vdbRepository.setSystemStore(VDBMetadataFactory.getSystem());
        return new MetadataFactory(schema, vdbRepository.getBuiltinDatatypes(), importProperties);
    }

    @Test
    public void testProcImport() throws Exception {
        this.server.deployVDB("vdb", UnitTestUtil.getTestDataPath() + "/TestCase3473/test.vdb");
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:vdb");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.importProcedures", Boolean.TRUE.toString());
        MetadataFactory mf = this.getMetadata(importProperties, (Connection)conn);
        Procedure p = (Procedure)((Schema)mf.getMetadataStore().getSchemas().get("TEST")).getProcedures().get("VDB.SYS.GETXMLSCHEMAS");
        Assert.assertEquals((long)29L, (long)((Schema)mf.getMetadataStore().getSchemas().get("TEST")).getTables().size());
        Assert.assertEquals((long)8L, (long)((Schema)mf.getMetadataStore().getSchemas().get("TEST")).getProcedures().size());
        Assert.assertEquals((long)1L, (long)p.getResultSet().getColumns().size());
    }

    @Test
    public void testExcludes() throws Exception {
        this.server.deployVDB("vdb", UnitTestUtil.getTestDataPath() + "/TestCase3473/test.vdb");
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:vdb");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.importProcedures", Boolean.TRUE.toString());
        importProperties.setProperty("importer.excludeTables", "VDB\\.SYS\\..*");
        importProperties.setProperty("importer.excludeProcedures", "VDB\\..*");
        MetadataFactory mf = this.getMetadata(importProperties, (Connection)conn);
        Assert.assertEquals((long)18L, (long)((Schema)mf.getMetadataStore().getSchemas().get("TEST")).getTables().size());
        Assert.assertEquals((long)0L, (long)((Schema)mf.getMetadataStore().getSchemas().get("TEST")).getProcedures().size());
    }

    @Test
    public void testDuplicateException() throws Exception {
        MetadataFactory mf = this.createMetadataFactory("x", new Properties());
        MetadataFactory mf1 = this.createMetadataFactory("y", new Properties());
        Table dup = mf.addTable("dup");
        Table dup1 = mf1.addTable("dup");
        mf.addColumn("x", "string", (ColumnSet)dup);
        mf1.addColumn("x", "string", (ColumnSet)dup1);
        MetadataStore ms = mf.getMetadataStore();
        ms.addSchema((Schema)mf1.getMetadataStore().getSchemas().values().iterator().next());
        this.server.deployVDB("test", ms, new LinkedHashMap<String, TransformationMetadata.Resource>());
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:test");
        Properties importProperties = new Properties();
        mf = this.getMetadata(importProperties, (Connection)conn);
        Table t = (Table)((Schema)mf.getMetadataStore().getSchemas().get("TEST")).getTables().get("TEST.X.DUP");
        Assert.assertEquals((Object)"\"test\".\"x\".\"dup\"", (Object)t.getNameInSource());
        importProperties.setProperty("importer.useFullSchemaName", Boolean.FALSE.toString());
        try {
            this.getMetadata(importProperties, (Connection)conn);
            Assert.fail();
        }
        catch (TranslatorException e) {
            // empty catch block
        }
    }

    @Test
    public void testUseCatalog() throws Exception {
        MetadataFactory mf = this.createMetadataFactory("x", new Properties());
        Table dup = mf.addTable("dup");
        mf.addColumn("x", "string", (ColumnSet)dup);
        MetadataStore ms = mf.getMetadataStore();
        this.server.deployVDB("test", ms, new LinkedHashMap<String, TransformationMetadata.Resource>());
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:test");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.useCatalogName", Boolean.FALSE.toString());
        mf = this.getMetadata(importProperties, (Connection)conn);
        Table t = (Table)((Schema)mf.getMetadataStore().getSchemas().get("TEST")).getTables().get("X.DUP");
        Assert.assertEquals((Object)"\"x\".\"dup\"", (Object)t.getNameInSource());
    }
}

