/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminFactory;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.arquillian.SampleExecutionFactory;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestDeployment {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9999, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() {
        this.admin.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVDBDeployment() throws Exception {
        try {
            Collection vdbs = this.admin.getVDBs();
            Assert.assertTrue((boolean)vdbs.isEmpty());
            Collection dsNames = this.admin.getDataSourceNames();
            if (dsNames.contains("Oracle11_PushDS")) {
                this.admin.deleteDataSource("Oracle11_PushDS");
            }
            this.admin.deploy("bqt.vdb", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"bqt.vdb")));
            vdbs = this.admin.getVDBs();
            Assert.assertFalse((boolean)vdbs.isEmpty());
            VDB vdb = this.admin.getVDB("bqt", 1);
            Assert.assertFalse((boolean)vdb.isValid());
            Assert.assertTrue((boolean)vdb.getStatus().equals((Object)VDB.Status.INACTIVE));
            Properties props = new Properties();
            props.setProperty("connection-url", "jdbc:h2:mem:test;DB_CLOSE_DELAY=-1");
            props.setProperty("user-name", "sa");
            props.setProperty("password", "sa");
            this.admin.createDataSource("Oracle11_PushDS", "h2", props);
            Thread.sleep(2000L);
            vdb = this.admin.getVDB("bqt", 1);
            Assert.assertTrue((boolean)vdb.isValid());
            Assert.assertTrue((boolean)vdb.getStatus().equals((Object)VDB.Status.ACTIVE));
            dsNames = this.admin.getDataSourceNames();
            Assert.assertTrue((boolean)dsNames.contains("Oracle11_PushDS"));
            this.admin.deleteDataSource("Oracle11_PushDS");
            vdb = this.admin.getVDB("bqt", 1);
            Assert.assertFalse((boolean)vdb.isValid());
            Assert.assertTrue((boolean)vdb.getStatus().equals((Object)VDB.Status.INACTIVE));
        }
        finally {
            this.undeploy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTraslators() throws Exception {
        VDBTranslatorMetaData t;
        Collection translators = this.admin.getTranslators();
        System.out.println(translators);
        Assert.assertEquals((long)30L, (long)translators.size());
        JavaArchive jar = this.getLoopyArchive();
        try {
            this.admin.deploy("loopy.jar", ((ZipExporter)jar.as(ZipExporter.class)).exportAsInputStream());
            t = (VDBTranslatorMetaData)this.admin.getTranslator("loopy");
            Assert.assertNotNull((Object)t);
            Assert.assertEquals((Object)"ANY", (Object)t.getPropertyValue("SupportedJoinCriteria"));
            Assert.assertEquals((Object)"true", (Object)t.getPropertyValue("supportsSelectDistinct"));
        }
        finally {
            this.admin.undeploy("loopy.jar");
        }
        t = (VDBTranslatorMetaData)this.admin.getTranslator("orcl");
        Assert.assertNull((Object)t);
    }

    private JavaArchive getLoopyArchive() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"loopy.jar")).addClasses(new Class[]{SampleExecutionFactory.class})).addAsManifestResource((Asset)new ByteArrayAsset(SampleExecutionFactory.class.getName().getBytes()), ArchivePaths.create((String)"services/org.teiid.translator.ExecutionFactory"));
        jar.addAsManifestResource((Asset)new ByteArrayAsset("Dependencies: org.jboss.teiid.translator.loopback\n".getBytes()), ArchivePaths.create((String)"MANIFEST.MF"));
        return jar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVDBConnectionType() throws Exception {
        try {
            Connection conn;
            this.admin.deploy("bqt.vdb", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"bqt.vdb")));
            VDB vdb = this.admin.getVDB("bqt", 1);
            Model model = (Model)vdb.getModels().get(0);
            this.admin.assignToModel("bqt", 1, model.getName(), "Source", "h2", "java:jboss/datasources/ExampleDS");
            Assert.assertEquals((Object)VDB.ConnectionType.BY_VERSION, (Object)vdb.getConnectionType());
            try {
                conn = TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user", null);
                conn.close();
            }
            catch (Exception e) {
                Assert.fail((String)"must have succeeded in connection");
            }
            this.admin.changeVDBConnectionType("bqt", 1, VDB.ConnectionType.NONE);
            try {
                TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user", null);
                Assert.fail((String)"should have failed to connect as no new connections allowed");
            }
            catch (Exception e) {
                // empty catch block
            }
            this.admin.deploy("bqt2.vdb", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"bqt2.vdb")));
            this.admin.assignToModel("bqt", 2, model.getName(), "Source", "h2", "java:jboss/datasources/ExampleDS");
            try {
                conn = TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user", null);
                conn.close();
            }
            catch (Exception e) {
                Assert.fail((String)"should not have failed to connect");
            }
            this.admin.changeVDBConnectionType("bqt", 2, VDB.ConnectionType.ANY);
            try {
                conn = TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user", null);
                conn.close();
            }
            catch (Exception e) {
                Assert.fail((String)"should have connected to the second vdb");
            }
            vdb = this.admin.getVDB("bqt", 2);
            model = (Model)vdb.getModels().get(0);
            Assert.assertEquals((Object)model.getSourceConnectionJndiName("Source"), (Object)"java:jboss/datasources/ExampleDS");
            Assert.assertEquals((Object)model.getSourceTranslatorName("Source"), (Object)"h2");
            Assert.assertEquals((Object)VDB.ConnectionType.ANY, (Object)vdb.getConnectionType());
        }
        finally {
            this.undeploy();
            if (this.admin.getVDB("bqt", 2) != null) {
                this.admin.undeploy("bqt2.vdb");
            }
        }
    }

    @Test
    public void testCacheTypes() throws Exception {
        Object[] array = new String[]{Admin.Cache.PREPARED_PLAN_CACHE.toString(), Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE.toString()};
        Collection types = this.admin.getCacheTypes();
        Assert.assertArrayEquals((Object[])array, (Object[])types.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessions() throws Exception {
        try {
            Session s;
            Connection conn;
            this.deployVdb();
            Collection sessions = this.admin.getSessions();
            Assert.assertEquals((long)0L, (long)sessions.size());
            try {
                conn = TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user;ApplicationName=test", null);
                sessions = this.admin.getSessions();
                Assert.assertEquals((long)1L, (long)sessions.size());
                s = (Session)sessions.iterator().next();
                Assert.assertEquals((Object)"user@teiid-security", (Object)s.getUserName());
                Assert.assertEquals((Object)"test", (Object)s.getApplicationName());
                Assert.assertEquals((Object)"bqt", (Object)s.getVDBName());
                Assert.assertEquals((long)1L, (long)s.getVDBVersion());
                Assert.assertNotNull((Object)s.getSessionId());
                conn.close();
            }
            catch (Exception e) {
                Assert.fail((String)"should have connected to the vdb");
            }
            try {
                conn = TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user;ApplicationName=test", null);
                sessions = this.admin.getSessions();
                Assert.assertEquals((long)1L, (long)sessions.size());
                s = (Session)sessions.iterator().next();
                this.admin.terminateSession(s.getSessionId());
                sessions = this.admin.getSessions();
                Assert.assertEquals((long)0L, (long)sessions.size());
                conn.close();
            }
            catch (Exception e) {
                Assert.fail((String)"should have connected to the vdb");
            }
        }
        finally {
            this.undeploy();
        }
    }

    private boolean deployVdb() throws AdminException, FileNotFoundException {
        this.admin.deploy("bqt.vdb", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"bqt.vdb")));
        boolean vdbOneDeployed = true;
        VDB vdb = this.admin.getVDB("bqt", 1);
        Model model = (Model)vdb.getModels().get(0);
        this.admin.assignToModel("bqt", 1, model.getName(), "Source", "h2", "java:jboss/datasources/ExampleDS");
        return vdbOneDeployed;
    }

    private void undeploy() throws Exception {
        VDB vdb = this.admin.getVDB("bqt", 1);
        if (vdb != null) {
            this.admin.undeploy("bqt.vdb");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRequests() throws Exception {
        JavaArchive jar = this.getLoopyArchive();
        try {
            this.admin.deploy("loopy.jar", ((ZipExporter)jar.as(ZipExporter.class)).exportAsInputStream());
            this.deployVdb();
            VDB vdb = this.admin.getVDB("bqt", 1);
            Model model = (Model)vdb.getModels().get(0);
            Translator t = this.admin.getTranslator("loopy");
            Assert.assertNotNull((Object)t);
            this.admin.assignToModel("bqt", 1, model.getName(), "Source", "loopy", "java:jboss/datasources/ExampleDS");
            Connection conn = TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user", null);
            Collection sessions = this.admin.getSessions();
            Assert.assertEquals((long)1L, (long)sessions.size());
            Session s = (Session)sessions.iterator().next();
            Statement stmt = conn.createStatement();
            Collection requests = this.admin.getRequests();
            Assert.assertEquals((long)0L, (long)requests.size());
            stmt.execute("select * from source.smalla");
            requests = this.admin.getRequests();
            Assert.assertEquals((long)1L, (long)requests.size());
            Request r = (Request)requests.iterator().next();
            Assert.assertEquals((Object)"select * from source.smalla", (Object)r.getCommand());
            Assert.assertNotNull((Object)r.getExecutionId());
            Assert.assertNotNull((Object)r.getSessionId());
            stmt.execute("select * from source.smalla");
            Collection requests2 = this.admin.getRequestsForSession(s.getSessionId());
            Assert.assertEquals((long)1L, (long)requests2.size());
            Request r2 = (Request)requests.iterator().next();
            Assert.assertEquals((Object)"select * from source.smalla", (Object)r2.getCommand());
            Assert.assertEquals((Object)s.getSessionId(), (Object)r2.getSessionId());
            stmt.close();
            conn.close();
            requests = this.admin.getRequests();
            Assert.assertEquals((long)0L, (long)requests.size());
        }
        finally {
            this.admin.undeploy("loopy.jar");
            this.undeploy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getDatasourceTemplateNames() throws Exception {
        Object[] array = new String[]{"teiid-connector-file.rar", "teiid-local", "teiid", "teiid-connector-salesforce.rar", "teiid-connector-ldap.rar", "teiid-connector-ws.rar", "h2"};
        try {
            this.deployVdb();
            Set templates = this.admin.getDataSourceTemplateNames();
            System.out.println(templates);
            Assert.assertArrayEquals((Object[])array, (Object[])templates.toArray(new String[templates.size()]));
        }
        finally {
            this.undeploy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getTemplatePropertyDefinitions() throws Exception {
        try {
            HashSet<String> props = new HashSet<String>();
            this.deployVdb();
            Collection pds = this.admin.getTemplatePropertyDefinitions("h2");
            for (PropertyDefinition pd : pds) {
                props.add(pd.getName());
            }
            Assert.assertTrue((boolean)props.contains("connection-url"));
            Assert.assertTrue((boolean)props.contains("user-name"));
            Assert.assertTrue((boolean)props.contains("password"));
            Assert.assertTrue((boolean)props.contains("check-valid-connection-sql"));
            HashSet<String> rar_props = new HashSet<String>();
            pds = this.admin.getTemplatePropertyDefinitions("teiid-connector-file.rar");
            for (PropertyDefinition pd : pds) {
                rar_props.add(pd.getName());
            }
            Assert.assertTrue((boolean)rar_props.contains("ParentDirectory"));
            Assert.assertTrue((boolean)rar_props.contains("FileMapping"));
            Assert.assertTrue((boolean)rar_props.contains("AllowParentPaths"));
        }
        finally {
            this.undeploy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getWorkerPoolStats() throws Exception {
        try {
            this.deployVdb();
            Assert.assertNotNull((Object)this.admin.getWorkerPoolStats());
        }
        finally {
            this.undeploy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataRoleMapping() throws Exception {
        try {
            this.admin.deploy("bqt2.vdb", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"bqt2.vdb")));
            VDB vdb = this.admin.getVDB("bqt", 2);
            Model model = (Model)vdb.getModels().get(0);
            this.admin.assignToModel("bqt", 2, model.getName(), "Source", "h2", "java:jboss/datasources/ExampleDS");
            vdb = this.admin.getVDB("bqt", 2);
            Assert.assertTrue((boolean)vdb.isValid());
            List policies = vdb.getDataPolicies();
            Assert.assertEquals((long)1L, (long)policies.size());
            DataPolicy dp = (DataPolicy)policies.get(0);
            Assert.assertEquals((Object)"roleOne", (Object)dp.getName());
            Assert.assertEquals((long)2L, (long)dp.getPermissions().size());
            Assert.assertTrue((boolean)dp.isAllowCreateTemporaryTables());
            Assert.assertTrue((boolean)dp.isAnyAuthenticated());
            List roleNames = dp.getMappedRoleNames();
            Assert.assertArrayEquals((Object[])new String[]{"ROLE1", "ROLE2"}, (Object[])roleNames.toArray());
            this.admin.removeDataRoleMapping("bqt", 2, "roleOne", "ROLE1");
            vdb = this.admin.getVDB("bqt", 2);
            policies = vdb.getDataPolicies();
            dp = (DataPolicy)policies.get(0);
            roleNames = dp.getMappedRoleNames();
            Assert.assertArrayEquals((Object[])new String[]{"ROLE2"}, (Object[])roleNames.toArray());
            this.admin.addDataRoleMapping("bqt", 2, "roleOne", "ROLE3");
            vdb = this.admin.getVDB("bqt", 2);
            policies = vdb.getDataPolicies();
            dp = (DataPolicy)policies.get(0);
            roleNames = dp.getMappedRoleNames();
            Assert.assertArrayEquals((Object[])new String[]{"ROLE2", "ROLE3"}, (Object[])roleNames.toArray());
            this.admin.setAnyAuthenticatedForDataRole("bqt", 2, "roleOne", false);
            vdb = this.admin.getVDB("bqt", 2);
            policies = vdb.getDataPolicies();
            dp = (DataPolicy)policies.get(0);
            Assert.assertFalse((boolean)dp.isAnyAuthenticated());
        }
        finally {
            if (this.admin.getVDB("bqt", 2) != null) {
                this.admin.undeploy("bqt2.vdb");
            }
        }
    }

    @Test
    public void testCreateConnectionFactory() throws Exception {
        String deployedName = "wsOne";
        Assert.assertFalse((boolean)this.admin.getDataSourceNames().contains(deployedName));
        Properties p = new Properties();
        p.setProperty("class-name", "org.teiid.resource.adapter.ws.WSManagedConnectionFactory");
        p.setProperty("EndPoint", "{endpoint}");
        this.admin.createDataSource(deployedName, "teiid-connector-ws.rar", p);
        Assert.assertTrue((boolean)this.admin.getDataSourceNames().contains(deployedName));
        this.admin.deleteDataSource(deployedName);
        Assert.assertFalse((boolean)this.admin.getDataSourceNames().contains(deployedName));
        this.admin.createDataSource(deployedName, "teiid-connector-ws.rar", p);
        Assert.assertTrue((boolean)this.admin.getDataSourceNames().contains(deployedName));
        this.admin.deleteDataSource(deployedName);
    }
}

