/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.index.VDBMetadataFactory;
import org.teiid.query.parser.QueryParser;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.teiid.TeiidExecutionFactory;

public class TestDynamicImportedMetaData {
    private FakeServer server;

    @Before
    public void setup() {
        this.server = new FakeServer();
    }

    @After
    public void tearDown() {
        this.server.stop();
    }

    private MetadataFactory getMetadata(Properties importProperties, Connection conn) throws TranslatorException {
        MetadataFactory mf = this.createMetadataFactory("test", importProperties);
        TeiidExecutionFactory tef = new TeiidExecutionFactory();
        tef.getMetadata(mf, conn);
        return mf;
    }

    private MetadataFactory createMetadataFactory(String schema, Properties importProperties) {
        VDBRepository vdbRepository = new VDBRepository();
        vdbRepository.setSystemStore(VDBMetadataFactory.getSystem());
        return new MetadataFactory("vdb", 1, schema, vdbRepository.getBuiltinDatatypes(), importProperties, null);
    }

    @Test
    public void testUniqueReferencedKey() throws Exception {
        this.server.deployVDB("vdb", UnitTestUtil.getTestDataPath() + "/keys.vdb");
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:vdb");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.importKeys", "true");
        importProperties.setProperty("importer.schemaPattern", "x");
        MetadataFactory mf = this.getMetadata(importProperties, (Connection)conn);
        Table t = (Table)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getTables().get("VDB.X.A");
        List fks = t.getForeignKeys();
        Assert.assertEquals((long)1L, (long)fks.size());
        Assert.assertNotNull((Object)((ForeignKey)fks.get(0)).getPrimaryKey());
    }

    @Test
    public void testProcImport() throws Exception {
        this.server.deployVDB("vdb", UnitTestUtil.getTestDataPath() + "/TestCase3473/test.vdb");
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:vdb");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.importProcedures", Boolean.TRUE.toString());
        MetadataFactory mf = this.getMetadata(importProperties, (Connection)conn);
        Procedure p = (Procedure)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getProcedures().get("VDB.SYS.GETXMLSCHEMAS");
        Assert.assertEquals((long)1L, (long)p.getResultSet().getColumns().size());
    }

    @Test
    public void testExcludes() throws Exception {
        this.server.deployVDB("vdb", UnitTestUtil.getTestDataPath() + "/TestCase3473/test.vdb");
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:vdb");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.importProcedures", Boolean.TRUE.toString());
        importProperties.setProperty("importer.excludeTables", "VDB\\.SYS\\..*");
        importProperties.setProperty("importer.excludeProcedures", "VDB\\..*");
        MetadataFactory mf = this.getMetadata(importProperties, (Connection)conn);
        Assert.assertEquals((long)17L, (long)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getTables().size());
        Assert.assertEquals((long)0L, (long)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getProcedures().size());
    }

    @Test
    public void testDuplicateException() throws Exception {
        MetadataFactory mf = this.createMetadataFactory("x", new Properties());
        MetadataFactory mf1 = this.createMetadataFactory("y", new Properties());
        Table dup = mf.addTable("dup");
        Table dup1 = mf1.addTable("dup");
        mf.addColumn("x", "string", (ColumnSet)dup);
        mf1.addColumn("x", "string", (ColumnSet)dup1);
        MetadataStore ms = mf.asMetadataStore();
        ms.addSchema((Schema)mf1.asMetadataStore().getSchemas().values().iterator().next());
        this.server.deployVDB("test", ms);
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:test");
        Properties importProperties = new Properties();
        mf = this.getMetadata(importProperties, (Connection)conn);
        Table t = (Table)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getTables().get("TEST.X.DUP");
        Assert.assertEquals((Object)"\"test\".\"x\".\"dup\"", (Object)t.getNameInSource());
        importProperties.setProperty("importer.useFullSchemaName", Boolean.FALSE.toString());
        try {
            this.getMetadata(importProperties, (Connection)conn);
            Assert.fail();
        }
        catch (TranslatorException e) {
            // empty catch block
        }
    }

    @Test
    public void testUseCatalog() throws Exception {
        MetadataFactory mf = this.createMetadataFactory("x", new Properties());
        Table dup = mf.addTable("dup");
        mf.addColumn("x", "string", (ColumnSet)dup);
        MetadataStore ms = mf.asMetadataStore();
        this.server.deployVDB("test", ms);
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:test");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.useCatalogName", Boolean.FALSE.toString());
        mf = this.getMetadata(importProperties, (Connection)conn);
        Table t = (Table)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getTables().get("X.DUP");
        Assert.assertEquals((Object)"\"x\".\"dup\"", (Object)t.getNameInSource());
    }

    @Test
    public void testDDLMetadata() throws Exception {
        String ddl = "CREATE FOREIGN PROCEDURE getTextFiles(IN pathAndPattern varchar) RETURNS (file clob, filpath string) OPTIONS(UUID 'uuid')";
        MetadataFactory mf = this.createMetadataFactory("MarketData", new Properties());
        QueryParser.getQueryParser().parseDDL(mf, ddl);
        MetadataStore ms = mf.asMetadataStore();
        String ddl2 = "CREATE VIEW stock (symbol string, price bigdecimal) AS select stock.* from (call MarketData.getTextFiles('*.txt')) f, TEXTTABLE(f.file COLUMNS symbol string, price bigdecimal HEADER) stock OPTIONS (UUID 'uuid')";
        MetadataFactory m2 = this.createMetadataFactory("portfolio", new Properties());
        QueryParser.getQueryParser().parseDDL(m2, ddl2);
        m2.mergeInto(ms);
        this.server.deployVDB("test", ms);
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:test");
        Properties props = new Properties();
        props.setProperty("importer.importProcedures", Boolean.TRUE.toString());
        MetadataStore store = this.getMetadata(props, (Connection)conn).asMetadataStore();
        Procedure p = store.getSchema("test").getProcedure("test.MarketData.getTextFiles");
        Assert.assertNotNull((Object)p);
        ProcedureParameter pp = (ProcedureParameter)p.getParameters().get(0);
        Assert.assertEquals((Object)"pathAndPattern", (Object)pp.getName());
        Assert.assertEquals((Object)ProcedureParameter.Type.In, (Object)pp.getType());
        Table t = store.getSchema("test").getTable("test.portfolio.stock");
        Assert.assertNotNull((Object)t);
        List columns = t.getColumns();
        Assert.assertEquals((long)2L, (long)columns.size());
        Assert.assertEquals((Object)"symbol", (Object)((Column)columns.get(0)).getName());
        Assert.assertEquals((Object)"price", (Object)((Column)columns.get(1)).getName());
    }
}

