/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.postgresql.Driver;
import org.teiid.client.security.ILogon;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.ConnectionProfile;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TestMMDatabaseMetaData;
import org.teiid.net.socket.SocketUtil;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.ODBCSocketListener;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;

public class TestODBCSocketTransport {
    private static FakeOdbcServer odbcServer = new FakeOdbcServer();
    Connection conn;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        odbcServer.start();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        odbcServer.stop();
    }

    @Before
    public void setUp() throws Exception {
        Driver d = new Driver();
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        this.conn = d.connect("jdbc:postgresql://" + TestODBCSocketTransport.odbcServer.addr.getHostName() + ":" + TestODBCSocketTransport.odbcServer.odbcTransport.getPort() + "/parts", p);
    }

    @After
    public void tearDown() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Test
    public void testSelect() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables order by name"));
        TestMMDatabaseMetaData.compareResultSet(s.getResultSet());
    }

    @Test
    public void testTransactionalMultibatch() throws Exception {
        Statement s = this.conn.createStatement();
        this.conn.setAutoCommit(false);
        Assert.assertTrue((boolean)s.execute("select tables.name from tables, columns limit 1025"));
        int count = 0;
        while (s.getResultSet().next()) {
            ++count;
        }
        Assert.assertEquals((long)1025L, (long)count);
        this.conn.setAutoCommit(true);
    }

    @Test
    public void testMultibatchSelect() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables, columns limit 7000"));
        ResultSet rs = s.getResultSet();
        int i = 0;
        while (rs.next()) {
            ++i;
            rs.getString(1);
        }
        Assert.assertEquals((long)7000L, (long)i);
    }

    @Test
    public void testBlob() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select to_bytes('abc', 'UTF-16')"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        byte[] bytes = rs.getBytes(1);
        Assert.assertEquals((Object)"abc", (Object)new String(bytes, Charset.forName("UTF-16")));
    }

    @Test
    public void testClob() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select cast('abc' as clob)"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String clob = rs.getString(1);
        Assert.assertEquals((Object)"abc", (Object)clob);
    }

    @Test
    public void testLargeClob() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select cast(repeat('_', 3000) as clob)"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String clob = rs.getString(1);
        Assert.assertEquals((long)3000L, (long)clob.length());
    }

    @Test
    public void testMultiRowBuffering() throws Exception {
        Statement s = this.conn.createStatement();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 11; ++i) {
            sb.append("select '' union all ");
        }
        sb.append("select ''");
        Assert.assertTrue((boolean)s.execute(sb.toString()));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String str = rs.getString(1);
        Assert.assertEquals((long)0L, (long)str.length());
    }

    @Test
    public void testTransactionCycle() throws Exception {
        this.conn.setAutoCommit(false);
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables order by name"));
        this.conn.setAutoCommit(true);
    }

    @Test
    public void testPk() throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select ta.attname, ia.attnum, ic.relname, n.nspname, tc.relname from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class tc, pg_catalog.pg_index i, pg_catalog.pg_namespace n, pg_catalog.pg_class ic where tc.relname = E'pg_attribute' AND n.nspname = E'pg_catalog'");
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testPkPrepared() throws Exception {
        PreparedStatement stmt = this.conn.prepareStatement("select ta.attname, ia.attnum, ic.relname, n.nspname, tc.relname from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class tc, pg_catalog.pg_index i, pg_catalog.pg_namespace n, pg_catalog.pg_class ic where tc.relname = E'pg_attribute' AND n.nspname = E'pg_catalog'");
        ResultSet rs = stmt.executeQuery();
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testColumnMetadataWithAlias() throws Exception {
        PreparedStatement stmt = this.conn.prepareStatement("select ta.attname as x from pg_catalog.pg_attribute ta limit 1");
        ResultSet rs = stmt.executeQuery();
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testPreparedError() throws Exception {
        PreparedStatement stmt = this.conn.prepareStatement("select cast(? as integer)");
        stmt.setString(1, "a");
        try {
            stmt.executeQuery();
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Error converting"));
        }
    }

    @Test
    public void testPreparedError1() throws Exception {
        PreparedStatement stmt = this.conn.prepareStatement("select");
        try {
            stmt.executeQuery();
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Parsing error"));
        }
    }

    @Test
    public void testEscapedLiteral() throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select E'\\n\\thello pg'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"\n\thello pg", (Object)rs.getString(1));
    }

    @Test
    public void testPgProc() throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select * from pg_proc");
        rs.next();
        Assert.assertEquals((Object)"oid", (Object)rs.getArray("proargtypes").getBaseTypeName());
    }

    public void testPgDeclareCursor() throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("begin;declare \"foo\" cursor for select * from pg_proc;fetch 10 in \"foo\"; close \"foo\"");
        rs.next();
    }

    @Test
    public void testPgProcedure() throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select has_function_privilege(100, 'foo')");
        rs.next();
    }

    @Test
    public void testPreparedUpdate() throws Exception {
        Statement stmt = this.conn.createStatement();
        Assert.assertFalse((boolean)stmt.execute("create local temporary table x (y string)"));
        PreparedStatement ps = this.conn.prepareStatement("delete from x");
        Assert.assertFalse((boolean)ps.execute());
        Assert.assertNull((Object)ps.getMetaData());
    }

    @Test
    public void testSelectSsl() throws Exception {
        this.conn.close();
        Driver d = new Driver();
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        p.setProperty("ssl", "true");
        p.setProperty("sslfactory", AnonSSLSocketFactory.class.getName());
        this.conn = d.connect("jdbc:postgresql://" + TestODBCSocketTransport.odbcServer.addr.getHostName() + ":" + TestODBCSocketTransport.odbcServer.odbcTransport.getPort() + "/parts", p);
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables order by name"));
        TestMMDatabaseMetaData.compareResultSet("TestODBCSocketTransport/testSelect", s.getResultSet());
    }

    @Test
    public void testPayload() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertFalse((boolean)s.execute("SET PAYLOAD x y"));
        Assert.assertTrue((boolean)s.execute("SELECT commandpayload('x')"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String str = rs.getString(1);
        Assert.assertEquals((Object)"y", (Object)str);
    }

    @Test
    public void testShowPlan() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertFalse((boolean)s.execute("SET SHOWPLAN ON"));
        Assert.assertTrue((boolean)s.execute("SELECT 1"));
        Assert.assertTrue((boolean)s.execute("SHOW PLAN"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String str = rs.getString(1);
        Assert.assertTrue((boolean)str.startsWith("ProjectNode\n  + Output Columns:expr1 (integer)\n  + Statistics:\n    0: Node Output Rows: 1"));
    }

    static class FakeOdbcServer {
        InetSocketAddress addr;
        ODBCSocketListener odbcTransport;

        FakeOdbcServer() {
        }

        public void start() throws Exception {
            SocketConfiguration config = new SocketConfiguration();
            SSLConfiguration sslConfig = new SSLConfiguration();
            sslConfig.setMode("enabled");
            sslConfig.setAuthenticationMode("anonymous");
            config.setSSLConfiguration(sslConfig);
            this.addr = new InetSocketAddress(0);
            config.setBindAddress(this.addr.getHostName());
            config.setPortNumber(this.addr.getPort());
            this.odbcTransport = new ODBCSocketListener(this.addr, config, (ClientServiceRegistryImpl)Mockito.mock(ClientServiceRegistryImpl.class), (StorageManager)BufferManagerFactory.getStandaloneBufferManager(), 100000, (ILogon)Mockito.mock(ILogon.class));
            this.odbcTransport.setMaxBufferSize(1000);
            FakeServer server = new FakeServer();
            server.setUseCallingThread(false);
            server.deployVDB("parts", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
            TeiidDriver driver = new TeiidDriver();
            driver.setEmbeddedProfile((ConnectionProfile)server);
            this.odbcTransport.setDriver(driver);
        }

        public void stop() {
            this.odbcTransport.stop();
        }
    }

    public static class AnonSSLSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory sslSocketFactory;

        public AnonSSLSocketFactory() {
            try {
                this.sslSocketFactory = SSLContext.getDefault().getSocketFactory();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException();
            }
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.sslSocketFactory.createSocket();
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.sslSocketFactory.createSocket(address, port, localAddress, localPort);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.sslSocketFactory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(s, host, port, autoClose);
            SocketUtil.addCipherSuite((SSLSocket)socket, (String)"TLS_DH_anon_WITH_AES_128_CBC_SHA");
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.sslSocketFactory.createSocket(host, port, localHost, localPort);
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.sslSocketFactory.createSocket(host, port);
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.sslSocketFactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.sslSocketFactory.getSupportedCipherSuites();
        }
    }
}

