/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;

public class TestODBCProceduresSchema
extends AbstractMMQueryTestCase {
    private static final String VDB = "bqt";
    private static FakeServer server;

    public TestODBCProceduresSchema() {
        this.DELIMITER = "\t";
    }

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        server = new FakeServer(true);
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/bqt.vdb");
    }

    @AfterClass
    public static void oneTimeTeardown() throws Exception {
        server.stop();
    }

    @Before
    public void setUp() throws Exception {
        this.internalConnection = server.createConnection("jdbc:teiid:bqt");
    }

    @Test
    public void test_Pg_Proc_alltypes() throws Exception {
        this.execute("select oid, proname, proretset,prorettype, pronargs, proargtypes, proargnames, proargmodes, proallargtypes, pronamespace FROM pg_proc where proname='bigProcedure'");
        Assert.assertTrue((boolean)this.internalResultSet.next());
        Assert.assertEquals((long)1L, (long)this.internalResultSet.getInt(1));
        Assert.assertEquals((Object)"bigProcedure", (Object)this.internalResultSet.getString(2));
        Assert.assertEquals((Object)true, (Object)this.internalResultSet.getBoolean(3));
        Assert.assertEquals((long)2249L, (long)this.internalResultSet.getInt(4));
        Assert.assertEquals((long)14L, (long)this.internalResultSet.getInt(5));
        Assert.assertArrayEquals((Object[])new Object[]{1700, 1043, 700, 20, 701, 21, 1082, 1083, 1114, 16, 1043, 21, 1700, 1700}, (Object[])((Object[])this.internalResultSet.getObject(6)));
        Assert.assertArrayEquals((Object[])new Object[]{"intNum", "stringNum", "floatNum", "longNum", "doubleNum", "byteNum", "dateValue", "timeValue", "timestampValue", "booValue", "charValue", "shortNum", "bigIntNum", "bigdecimalNum", "col", "col2"}, (Object[])((Object[])this.internalResultSet.getObject(7)));
        Assert.assertArrayEquals((Object[])new Object[]{"i", "i", "i", "i", "i", "i", "i", "i", "i", "i", "i", "i", "i", "i", "t", "t"}, (Object[])((Object[])this.internalResultSet.getObject(8)));
        Assert.assertArrayEquals((Object[])new Object[]{1700, 1043, 700, 20, 701, 21, 1082, 1083, 1114, 16, 1043, 21, 1700, 1700, 1043, 1700}, (Object[])((Object[])this.internalResultSet.getObject(9)));
        Assert.assertEquals((long)1L, (long)this.internalResultSet.getInt(10));
    }

    @Test
    public void test_Pg_Proc_void() throws Exception {
        this.execute("select oid, proname, proretset,prorettype, pronargs, proargtypes, proargnames, proargmodes, proallargtypes, pronamespace FROM pg_proc where proname='VoidProcedure'");
        Assert.assertTrue((boolean)this.internalResultSet.next());
        Assert.assertEquals((long)4L, (long)this.internalResultSet.getInt(1));
        Assert.assertEquals((Object)"VoidProcedure", (Object)this.internalResultSet.getString(2));
        Assert.assertEquals((Object)false, (Object)this.internalResultSet.getBoolean(3));
        Assert.assertEquals((long)2278L, (long)this.internalResultSet.getInt(4));
        Assert.assertEquals((long)2L, (long)this.internalResultSet.getInt(5));
        Assert.assertArrayEquals((Object[])new Object[]{1700, 1043}, (Object[])((Object[])this.internalResultSet.getObject(6)));
        Assert.assertArrayEquals((Object[])new Object[]{"intNum", "stringNum"}, (Object[])((Object[])this.internalResultSet.getObject(7)));
        Assert.assertArrayEquals(null, (Object[])((Object[])this.internalResultSet.getObject(8)));
        Assert.assertArrayEquals((Object[])new Object[]{1700, 1043}, (Object[])((Object[])this.internalResultSet.getObject(9)));
        Assert.assertEquals((long)1L, (long)this.internalResultSet.getInt(10));
    }

    @Test
    public void test_Pg_Proc_with_return() throws Exception {
        this.execute("select oid, proname, proretset,prorettype, pronargs, proargtypes, proargnames, proargmodes, proallargtypes, pronamespace FROM pg_proc where proname='ProcedureWithReturn'");
        Assert.assertTrue((boolean)this.internalResultSet.next());
        Assert.assertEquals((long)3L, (long)this.internalResultSet.getInt(1));
        Assert.assertEquals((Object)"ProcedureWithReturn", (Object)this.internalResultSet.getString(2));
        Assert.assertEquals((Object)false, (Object)this.internalResultSet.getBoolean(3));
        Assert.assertEquals((long)20L, (long)this.internalResultSet.getInt(4));
        Assert.assertEquals((long)3L, (long)this.internalResultSet.getInt(5));
        Assert.assertArrayEquals((Object[])new Object[]{1700, 1043, 700}, (Object[])((Object[])this.internalResultSet.getObject(6)));
        Assert.assertArrayEquals((Object[])new Object[]{"intNum", "stringNum", "floatNum"}, (Object[])((Object[])this.internalResultSet.getObject(7)));
        Assert.assertArrayEquals(null, (Object[])((Object[])this.internalResultSet.getObject(8)));
        Assert.assertArrayEquals((Object[])new Object[]{1700, 1043, 700}, (Object[])((Object[])this.internalResultSet.getObject(9)));
        Assert.assertEquals((long)1L, (long)this.internalResultSet.getInt(10));
    }

    @Test
    public void test_Pg_Proc_with_return_table() throws Exception {
        this.execute("select oid, proname, proretset,prorettype, pronargs, proargtypes, proargnames, proargmodes, proallargtypes, pronamespace FROM pg_proc where proname='ProcedureReturnTable'");
        Assert.assertTrue((boolean)this.internalResultSet.next());
        Assert.assertEquals((long)2L, (long)this.internalResultSet.getInt(1));
        Assert.assertEquals((Object)"ProcedureReturnTable", (Object)this.internalResultSet.getString(2));
        Assert.assertEquals((Object)true, (Object)this.internalResultSet.getBoolean(3));
        Assert.assertEquals((long)2249L, (long)this.internalResultSet.getInt(4));
        Assert.assertEquals((long)2L, (long)this.internalResultSet.getInt(5));
        Assert.assertArrayEquals((Object[])new Object[]{1700, 1700}, (Object[])((Object[])this.internalResultSet.getObject(6)));
        Assert.assertArrayEquals((Object[])new Object[]{"intNum", "bigDecimalNum", "col1", "col2"}, (Object[])((Object[])this.internalResultSet.getObject(7)));
        Assert.assertArrayEquals((Object[])new Object[]{"i", "i", "t", "t"}, (Object[])((Object[])this.internalResultSet.getObject(8)));
        Assert.assertArrayEquals((Object[])new Object[]{1700, 1700, 1043, 1114}, (Object[])((Object[])this.internalResultSet.getObject(9)));
        Assert.assertEquals((long)1L, (long)this.internalResultSet.getInt(10));
    }
}

