/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Stack;
import org.teiid.jdbc.AbstractQueryTest;
import org.teiid.jdbc.TeiidDriver;

public class AbstractMMQueryTestCase
extends AbstractQueryTest {
    private Stack<Connection> contexts = new Stack();

    public void pushConnection() {
        this.contexts.push(this.internalConnection);
        this.internalConnection = null;
    }

    public void popConnection() {
        this.internalConnection = this.contexts.pop();
    }

    public Connection getConnection(String vdb, String propsFile) {
        return this.getConnection(vdb, propsFile, "");
    }

    public Connection getConnection(String vdb, String propsFile, String addtionalStuff) {
        this.closeResultSet();
        this.closeStatement();
        this.closeConnection();
        try {
            this.internalConnection = AbstractMMQueryTestCase.createConnection(vdb, propsFile, addtionalStuff);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return this.internalConnection;
    }

    public static Connection createConnection(String vdb, String propsFile, String addtionalStuff) throws SQLException {
        String url = "jdbc:teiid:" + vdb + "@" + propsFile + addtionalStuff;
        return DriverManager.getConnection(url);
    }

    protected void helpTest(String query, String[] expected, String vdb, String props, String urlProperties) throws SQLException {
        this.getConnection(vdb, props, urlProperties);
        this.executeAndAssertResults(query, expected);
        this.closeConnection();
    }

    static {
        new TeiidDriver();
    }
}

