/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.teiid.script.io.StringLineReader;

public class MetadataReader
extends StringLineReader {
    ResultSetMetaData source;
    String delimiter = "    ";
    boolean firsttime = true;
    int currentColumn = 0;

    public MetadataReader(ResultSetMetaData metadata, String delimiter) {
        this.source = metadata;
        this.delimiter = delimiter;
    }

    protected String nextLine() throws IOException {
        if (this.firsttime) {
            this.firsttime = false;
            return this.firstLine();
        }
        try {
            int count = this.source.getColumnCount();
            if (this.currentColumn < count) {
                ++this.currentColumn;
                return this.getNextRow();
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    String firstLine() {
        StringBuffer sb = new StringBuffer();
        sb.append("ColumnName").append(this.delimiter);
        sb.append("ColumnType").append(this.delimiter);
        sb.append("ColumnTypeName").append(this.delimiter);
        sb.append("ColumnClassName").append(this.delimiter);
        sb.append("isNullable").append(this.delimiter);
        sb.append("TableName").append(this.delimiter);
        sb.append("SchemaName").append(this.delimiter);
        sb.append("CatalogName").append(this.delimiter);
        sb.append("\n");
        return sb.toString();
    }

    String getNextRow() throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.source.getColumnName(this.currentColumn)).append(this.delimiter);
        sb.append(this.source.getColumnType(this.currentColumn)).append(this.delimiter);
        sb.append(this.source.getColumnTypeName(this.currentColumn)).append(this.delimiter);
        sb.append(this.source.getColumnClassName(this.currentColumn)).append(this.delimiter);
        sb.append(this.source.isNullable(this.currentColumn)).append(this.delimiter);
        sb.append(this.source.getTableName(this.currentColumn)).append(this.delimiter);
        sb.append(this.source.getSchemaName(this.currentColumn)).append(this.delimiter);
        sb.append(this.source.getCatalogName(this.currentColumn)).append(this.delimiter);
        sb.append("\n");
        return sb.toString();
    }
}

