/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.jboss.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.core.util.Base64;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestOData
extends AbstractMMQueryTestCase {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9990, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testOdata() throws Exception {
        String vdb = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<vdb name=\"Loopy\" version=\"1\">\n    <model name=\"MarketData\">\n        <source name=\"text-connector2\" translator-name=\"loopback\" />\n         <metadata type=\"DDL\"><![CDATA[\n                CREATE FOREIGN TABLE G1 (e1 string, e2 integer PRIMARY KEY);\n                CREATE FOREIGN TABLE G2 (e1 string, e2 integer PRIMARY KEY) OPTIONS (UPDATABLE 'true');\n        ]]> </metadata>\n    </model>\n</vdb>";
        this.admin.deploy("loopy-vdb.xml", (InputStream)new ReaderInputStream((Reader)new StringReader(vdb), Charset.forName("UTF-8")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "Loopy", 1, 3));
        WebClient client = WebClient.create((String)"http://localhost:8080/odata/loopy.1/$metadata");
        client.header("Authorization", new Object[]{"Basic " + Base64.encodeBytes((byte[])"user:user".getBytes())});
        Response response = client.invoke("GET", null);
        int statusCode = response.getStatus();
        Assert.assertEquals((long)200L, (long)statusCode);
        ConnectionImpl conn = TeiidDriver.getInstance().connect("jdbc:teiid:loopy@mm://localhost:31000;user=user;password=user", null);
        CallableStatement ps = conn.prepareCall("select t.* from xmltable('/*:Edmx/*:DataServices/*:Schema[@Namespace=\"MarketData\"]' passing xmlparse(document cast(? as clob))) as t");
        ps.setAsciiStream(1, (InputStream)response.getEntity());
        ResultSet rs = ps.executeQuery();
        rs.next();
        Assert.assertEquals((Object)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"loopy-metadata-results.txt")), (Object)rs.getString(1));
        conn.close();
        client = WebClient.create((String)"http://localhost:8080/odata/loopy.1/G1?$filter=e1%20eq%20datetime'2000-01-01T01:01:01'");
        client.header("Authorization", new Object[]{"Basic " + Base64.encodeBytes((byte[])"user:user".getBytes())});
        response = client.invoke("GET", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.admin.undeploy("loopy-vdb.xml");
    }

    @Test
    public void testReadOdataMetadata() throws Exception {
        String vdb = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<vdb name=\"Loopy\" version=\"1\">\n    <model name=\"MarketData\">\n        <source name=\"text-connector2\" translator-name=\"loopback\" />\n         <metadata type=\"DDL\"><![CDATA[\n                CREATE FOREIGN TABLE G1 (e1 string[], e2 integer PRIMARY KEY);\n                CREATE FOREIGN TABLE G2 (e1 string, e2 integer PRIMARY KEY) OPTIONS (UPDATABLE 'true');\n        ]]> </metadata>\n    </model>\n</vdb>";
        this.admin.deploy("loopy-vdb.xml", (InputStream)new ReaderInputStream((Reader)new StringReader(vdb), Charset.forName("UTF-8")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "Loopy", 1, 3));
        String vdb2 = "<?xml version='1.0' encoding='UTF-8'?>\n<vdb name=\"TestOData\" version=\"1\">\n    <model name=\"TestOData\" type=\"PHYSICAL\" visible=\"true\">\n     <property name=\"importer.entityContainer\" value=\"MarketData\"/>\n     <property name=\"importer.schemaNamespace\" value=\"MarketData\"/>\n     <source name=\"TestOData\" translator-name=\"odata\" connection-jndi-name=\"java:/TestOData\"/>\n    </model>\n</vdb>";
        Properties p = new Properties();
        p.setProperty("class-name", "org.teiid.resource.adapter.ws.WSManagedConnectionFactory");
        p.setProperty("EndPoint", "http://localhost:8080/odata/Loopy.1");
        p.setProperty("SecurityType", "HTTPBasic");
        p.setProperty("AuthUserName", "user");
        p.setProperty("AuthPassword", "user");
        this.admin.createDataSource("TestOData", "webservice", p);
        this.admin.deploy("test-vdb.xml", (InputStream)new ReaderInputStream((Reader)new StringReader(vdb2), Charset.forName("UTF-8")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "TestOData", 1, 30000));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:TestOData@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT Name FROM Sys.Tables Where name='G1'");
        this.assertResultsSetEquals("Name[string]\nG1");
        this.admin.undeploy("loopy-vdb.xml");
        this.admin.undeploy("test-vdb.xml");
    }
}

