/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.transaction.TransactionManager;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.systemmodel.TestMatViews;
import org.teiid.translator.TranslatorException;

public class TestReplication {
    private static final String MATVIEWS = "matviews";
    private static final boolean DEBUG = false;
    private FakeServer server1;
    private FakeServer server2;

    @BeforeClass
    public static void oneTimeSetup() {
        System.setProperty("jgroups.bind_addr", "127.0.0.1");
    }

    @After
    public void tearDown() {
        if (this.server1 != null) {
            this.server1.stop();
        }
        if (this.server2 != null) {
            this.server2.stop();
        }
    }

    @Test
    public void testReplication() throws Exception {
        this.server1 = this.createServer("infinispan-replicated-config.xml", "tcp-shared.xml");
        this.deployMatViewVDB(this.server1);
        ConnectionImpl c1 = this.server1.createConnection("jdbc:teiid:matviews");
        Statement stmt = c1.createStatement();
        stmt.execute("select * from TEST.RANDOMVIEW");
        ResultSet rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        double d1 = rs.getDouble(1);
        double d2 = rs.getDouble(2);
        this.server2 = this.createServer("infinispan-replicated-config-1.xml", "tcp-shared.xml");
        this.deployMatViewVDB(this.server2);
        ConnectionImpl c2 = this.server2.createConnection("jdbc:teiid:matviews");
        Statement stmt2 = c2.createStatement();
        ResultSet rs2 = stmt2.executeQuery("select * from matviews where name = 'RandomView'");
        Assert.assertTrue((boolean)rs2.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs2.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs2.getBoolean("valid"));
        stmt2.execute("select * from TEST.RANDOMVIEW");
        rs2 = stmt2.getResultSet();
        Assert.assertTrue((boolean)rs2.next());
        Assert.assertEquals((double)d1, (double)rs2.getDouble(1), (double)0.0);
        Assert.assertEquals((double)d2, (double)rs2.getDouble(2), (double)0.0);
        rs2 = stmt2.executeQuery("select * from (call refreshMatView('TEST.RANDOMVIEW', false)) p");
        Thread.sleep(1000L);
        stmt.execute("select * from TEST.RANDOMVIEW");
        rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        d1 = rs.getDouble(1);
        d2 = rs.getDouble(2);
        stmt2.execute("select * from TEST.RANDOMVIEW");
        rs2 = stmt2.getResultSet();
        Assert.assertTrue((boolean)rs2.next());
        Assert.assertEquals((double)d1, (double)rs2.getDouble(1), (double)0.0);
        Assert.assertEquals((double)d2, (double)rs2.getDouble(2), (double)0.0);
        rs2 = stmt2.executeQuery("select lookup('sys.schemas', 'VDBName', 'name', 'SYS')");
        Thread.sleep(1000L);
        rs = stmt.executeQuery("select lookup('sys.schemas', 'VDBName', 'name', 'SYS')");
        rs.next();
        Assert.assertEquals((Object)MATVIEWS, (Object)rs.getString(1));
        rs = stmt.executeQuery("/*+ cache(scope:vdb) */ select rand()");
        Assert.assertTrue((boolean)rs.next());
        d1 = rs.getDouble(1);
        rs2 = stmt2.executeQuery("/*+ cache(scope:vdb) */ select rand()");
        Assert.assertTrue((boolean)rs2.next());
        d2 = rs2.getDouble(1);
        Assert.assertEquals((double)d1, (double)d2, (double)0.0);
    }

    @Test
    public void testLargeReplication() throws Exception {
        this.server1 = this.createServer("infinispan-replicated-config.xml", "tcp-shared.xml");
        this.deployLargeVDB(this.server1);
        ConnectionImpl c1 = this.server1.createConnection("jdbc:teiid:large");
        Statement stmt = c1.createStatement();
        stmt.execute("select * from c");
        ResultSet rs = stmt.getResultSet();
        int rowCount = 0;
        while (rs.next()) {
            ++rowCount;
        }
        Thread.sleep(1000L);
        this.server2 = this.createServer("infinispan-replicated-config-1.xml", "tcp-shared.xml");
        this.deployLargeVDB(this.server2);
        ConnectionImpl c2 = this.server2.createConnection("jdbc:teiid:large");
        Statement stmt2 = c2.createStatement();
        ResultSet rs2 = stmt2.executeQuery("select * from matviews where name = 'c'");
        Assert.assertTrue((boolean)rs2.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs2.getString("loadstate"));
        stmt2 = c2.createStatement();
        rs2 = stmt2.executeQuery("select * from c");
        int rowCount2 = 0;
        while (rs2.next()) {
            ++rowCount2;
        }
        Assert.assertEquals((long)rowCount, (long)rowCount2);
    }

    private FakeServer createServer(String ispn, String jgroups) throws Exception {
        FakeServer server = new FakeServer(false);
        EmbeddedConfiguration config = new EmbeddedConfiguration();
        config.setInfinispanConfigFile(ispn);
        config.setJgroupsConfigFile(jgroups);
        config.setTransactionManager((TransactionManager)new DummyTransactionManager());
        server.start(config, true);
        return server;
    }

    private void deployLargeVDB(FakeServer server) throws ConnectorManagerRepository.ConnectorManagerException, VirtualDatabaseException, TranslatorException {
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("mv");
        mmd.setModelType(Model.Type.VIRTUAL);
        mmd.addSourceMetadata("ddl", "create view c options (materialized true) as WITH t(n) AS ( VALUES (1) UNION ALL SELECT n+1 FROM t WHERE n < 10000 ) SELECT n, n || 'a', n + n FROM t");
        server.deployVDB("large", new ModelMetaData[]{mmd});
    }

    private void deployMatViewVDB(FakeServer server) throws Exception {
        HashMap<String, Collection<FunctionMethod>> udfs = new HashMap<String, Collection<FunctionMethod>>();
        udfs.put("funcs", Arrays.asList(new FunctionMethod("pause", null, null, FunctionMethod.PushDown.CANNOT_PUSHDOWN, TestMatViews.class.getName(), "pause", null, new FunctionParameter("return", "integer"), true, FunctionMethod.Determinism.NONDETERMINISTIC)));
        server.deployVDB(MATVIEWS, UnitTestUtil.getTestDataPath() + "/matviews.vdb", new FakeServer.DeployVDBParameter(udfs, null));
    }
}

