/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.runtime.EmbeddedConfiguration;

public class TestTempOrdering {
    private static final String VDB = "PartsSupplier";
    private static FakeServer server;

    @BeforeClass
    public static void setup() throws Exception {
        server = new FakeServer(false);
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        Properties p = new Properties();
        p.setProperty("org.teiid.defaultNullOrder", "HIGH");
        ec.setProperties(p);
        server.start(ec, false);
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
    }

    @AfterClass
    public static void teardown() throws Exception {
        server.stop();
    }

    @Test
    public void testNullOrder() throws Exception {
        ConnectionImpl c = server.createConnection("jdbc:teiid:PartsSupplier");
        Statement s = c.createStatement();
        s.execute("insert into #temp (a) values (null),(1)");
        ResultSet rs = s.executeQuery("select * from #temp order by a");
        rs.next();
        Assert.assertNotNull((Object)rs.getObject(1));
        rs = s.executeQuery("select * from #temp order by a nulls first");
        rs.next();
        Assert.assertNull((Object)rs.getObject(1));
    }
}

