/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestDynamicViewDefinition
extends AbstractMMQueryTestCase {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9999, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testViewDefinition() throws Exception {
        this.admin.deploy("dynamicview-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"dynamicview-vdb.xml")));
        Properties props = new Properties();
        props.setProperty("ParentDirectory", "../docs/teiid/examples/dynamicvdb-portfolio/data");
        props.setProperty("AllowParentPaths", "true");
        props.setProperty("class-name", "org.teiid.resource.adapter.file.FileManagedConnectionFactory");
        AdminUtil.createDataSource(this.admin, "marketdata-file", "teiid-connector-file.rar", props);
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "dynamic", 1, 3));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:dynamic@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT * FROM Sys.Columns WHERE tablename='stock'");
    }
}

