/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TestMMDatabaseMetaData;

public class TestODBCSchema
extends AbstractMMQueryTestCase {
    private static final String VDB = "PartsSupplier";
    private static FakeServer server;

    public TestODBCSchema() {
        this.DELIMITER = "\t";
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        server = new FakeServer(true);
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
    }

    @AfterClass
    public static void oneTimeTearDown() {
        server.stop();
    }

    @Before
    public void setUp() throws Exception {
        this.internalConnection = server.createConnection("jdbc:teiid:PartsSupplier");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.internalConnection != null) {
            this.internalConnection.close();
        }
    }

    @Test
    public void test_PG_AM() throws Exception {
        this.execute("select * FROM pg_am");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_ATTRDEF() throws Exception {
        this.execute("select * FROM pg_attrdef");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_ATTRIBUTE() throws Exception {
        this.execute("select * FROM pg_attribute");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_CLASS() throws Exception {
        this.execute("select * FROM pg_class");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_INDEX() throws Exception {
        this.execute("select * FROM pg_index");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_NAMESPACE() throws Exception {
        this.execute("select * FROM pg_namespace");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_TRIGGER() throws Exception {
        this.execute("select * FROM pg_trigger");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_TYPE() throws Exception {
        this.execute("select * FROM pg_type");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_DATABASE() throws Exception {
        this.execute("select* FROM pg_database");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_USER() throws Exception {
        this.execute("select * FROM pg_user");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void testOBIEEColumnQuery() throws Exception {
        this.execute("select ta.attname, ia.attnum, ic.relname, n.nspname, tc.relname from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class tc, pg_catalog.pg_index i, pg_catalog.pg_namespace n, pg_catalog.pg_class ic where tc.oid = i.indrelid AND n.oid = tc.relnamespace AND i.indisprimary = 't' AND ia.attrelid = i.indexrelid AND ta.attrelid = i.indrelid AND ta.attnum = i.indkey[ia.attnum-1] AND (NOT ta.attisdropped) AND (NOT ia.attisdropped) AND ic.oid = i.indexrelid order by ia.attnum");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void testOIDUniquness() throws Exception {
        for (String table : new String[]{"Tables", "Columns", "Schemas", "DataTypes", "Keys", "Procedures", "ProcedureParams", "Properties"}) {
            this.execute("select count(distinct oid), count(*) from SYS." + table);
            this.internalResultSet.next();
            Assert.assertEquals((long)this.internalResultSet.getInt(2), (long)this.internalResultSet.getInt(1));
        }
    }
}

