/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.visitor.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.cdk.unittest.FakeTranslationFactory;
import org.teiid.dqp.internal.datamgr.TestAggregateImpl;
import org.teiid.dqp.internal.datamgr.TestCompareCriteriaImpl;
import org.teiid.dqp.internal.datamgr.TestDeleteImpl;
import org.teiid.dqp.internal.datamgr.TestElementImpl;
import org.teiid.dqp.internal.datamgr.TestExistsCriteriaImpl;
import org.teiid.dqp.internal.datamgr.TestFunctionImpl;
import org.teiid.dqp.internal.datamgr.TestGroupByImpl;
import org.teiid.dqp.internal.datamgr.TestGroupImpl;
import org.teiid.dqp.internal.datamgr.TestInCriteriaImpl;
import org.teiid.dqp.internal.datamgr.TestInsertImpl;
import org.teiid.dqp.internal.datamgr.TestIsNullCriteriaImpl;
import org.teiid.dqp.internal.datamgr.TestJoinImpl;
import org.teiid.dqp.internal.datamgr.TestLikeCriteriaImpl;
import org.teiid.dqp.internal.datamgr.TestLiteralImpl;
import org.teiid.dqp.internal.datamgr.TestNotCriteriaImpl;
import org.teiid.dqp.internal.datamgr.TestOrderByImpl;
import org.teiid.dqp.internal.datamgr.TestProcedureImpl;
import org.teiid.dqp.internal.datamgr.TestQueryImpl;
import org.teiid.dqp.internal.datamgr.TestScalarSubqueryImpl;
import org.teiid.dqp.internal.datamgr.TestSearchedCaseExpressionImpl;
import org.teiid.dqp.internal.datamgr.TestSelectSymbolImpl;
import org.teiid.dqp.internal.datamgr.TestSetQueryImpl;
import org.teiid.dqp.internal.datamgr.TestSubqueryCompareCriteriaImpl;
import org.teiid.dqp.internal.datamgr.TestSubqueryInCriteriaImpl;
import org.teiid.dqp.internal.datamgr.TestUpdateImpl;
import org.teiid.dqp.internal.datamgr.TstLanguageBridgeFactory;
import org.teiid.language.AggregateFunction;
import org.teiid.language.Argument;
import org.teiid.language.BaseLanguageObject;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Function;
import org.teiid.language.Insert;
import org.teiid.language.InsertValueSource;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.Select;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.query.sql.lang.JoinType;

public class TestSQLStringVisitor {
    public static final RuntimeMetadata metadata = TstLanguageBridgeFactory.metadataFactory;

    private String getString(LanguageObject obj) {
        return SQLStringVisitor.getSQLString((LanguageObject)obj);
    }

    @Test
    public void testVisitIAggregate() throws Exception {
        String expected = "COUNT(42)";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestAggregateImpl.example((String)"COUNT", (String)"COUNT", (boolean)false, (int)42)));
    }

    @Test
    public void testVisitIAggregateDistinct() throws Exception {
        String expected = "COUNT(DISTINCT *)";
        AggregateFunction impl = new AggregateFunction("COUNT", true, null, Integer.class);
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)impl));
    }

    @Test
    public void testVisitICompareCriteria() throws Exception {
        String expected = "200 = 100";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestCompareCriteriaImpl.example((int)1, (int)200, (int)100)));
    }

    @Test
    public void testVisitICompoundCriteria() throws Exception {
        String expected = "200 = 100";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestCompareCriteriaImpl.example((int)1, (int)200, (int)100)));
        expected = "200 >= 100";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestCompareCriteriaImpl.example((int)6, (int)200, (int)100)));
        expected = "200 > 100";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestCompareCriteriaImpl.example((int)4, (int)200, (int)100)));
        expected = "200 <= 100";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestCompareCriteriaImpl.example((int)5, (int)200, (int)100)));
        expected = "200 < 100";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestCompareCriteriaImpl.example((int)3, (int)200, (int)100)));
        expected = "200 <> 100";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestCompareCriteriaImpl.example((int)2, (int)200, (int)100)));
    }

    @Test
    public void testVisitIDelete() throws Exception {
        String expected = "DELETE FROM g1 WHERE 100 >= 200 AND 500 < 600";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestDeleteImpl.example()));
    }

    @Test
    public void testVisitIElement() throws Exception {
        String expected = "g1.e1";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestElementImpl.example((String)"vm1.g1", (String)"e1")));
    }

    @Test
    public void testVisitIExistsCriteria() throws Exception {
        String expected = "EXISTS (SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE 100 >= 200 AND 500 < 600 GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING 100 >= 200 AND 500 < 600 ORDER BY g1.e1, g1.e2 DESC, g1.e3, g1.e4 DESC)";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestExistsCriteriaImpl.example()));
    }

    @Test
    public void testVisitIFunction() throws Exception {
        String expected = "testName(100, 200)";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestFunctionImpl.example((String)"testName")));
    }

    @Test
    public void testVisitConvertFunctionOracleStyle() throws Exception {
        String expected = "convert(columnA, integer)";
        List<BaseLanguageObject> params = Arrays.asList(new ColumnReference(null, "columnA", null, String.class), new Literal((Object)"integer", String.class));
        Function test = new Function("convert", params, Integer.class);
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)test));
    }

    @Test
    public void testVisitIGroup() throws Exception {
        String expected = "g1 AS alias";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestGroupImpl.example((String)"alias", (String)"vm1.g1")));
        expected = "g1";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestGroupImpl.example((String)"vm1.g1")));
    }

    @Test
    public void testVisitIGroupBy() throws Exception {
        String expected = "GROUP BY g1.e1, g1.e2, g1.e3, g1.e4";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestGroupByImpl.example()));
    }

    @Test
    public void testVisitIInCriteria() throws Exception {
        String expected = "300 IN (100, 200, 300, 400)";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestInCriteriaImpl.example((boolean)false)));
        expected = "300 NOT IN (100, 200, 300, 400)";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestInCriteriaImpl.example((boolean)true)));
    }

    @Test
    public void testVisitIInsert() throws Exception {
        String expected = "INSERT INTO g1 (e1, e2, e3, e4) VALUES (1, 2, 3, 4)";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestInsertImpl.example((String)"g1")));
    }

    @Test
    public void testVisitIIsNullCriteria() throws Exception {
        String expected = "g1.e1 IS NULL";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestIsNullCriteriaImpl.example((boolean)false)));
        expected = "g1.e1 IS NOT NULL";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestIsNullCriteriaImpl.example((boolean)true)));
    }

    @Test
    public void testVisitIJoin() throws Exception {
        String expected = "g1 CROSS JOIN g2 ON g1.e1 = g2.e1";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestJoinImpl.example((JoinType)JoinType.JOIN_CROSS)));
        expected = "g1 FULL OUTER JOIN g2 ON g1.e1 = g2.e1";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestJoinImpl.example((JoinType)JoinType.JOIN_FULL_OUTER)));
        expected = "g1 INNER JOIN g2 ON g1.e1 = g2.e1";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestJoinImpl.example((JoinType)JoinType.JOIN_INNER)));
        expected = "g1 LEFT OUTER JOIN g2 ON g1.e1 = g2.e1";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestJoinImpl.example((JoinType)JoinType.JOIN_LEFT_OUTER)));
        expected = "g1 RIGHT OUTER JOIN g2 ON g1.e1 = g2.e1";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestJoinImpl.example((JoinType)JoinType.JOIN_RIGHT_OUTER)));
    }

    @Test
    public void testVisitILikeCriteria() throws Exception {
        String expected = "g1.e1 LIKE 'likeString' ESCAPE '\\'";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestLikeCriteriaImpl.example((String)"likeString", (char)'\\', (boolean)false)));
        expected = "g1.e1 NOT LIKE 'likeString' ESCAPE '\\'";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestLikeCriteriaImpl.example((String)"likeString", (char)'\\', (boolean)true)));
    }

    @Test
    public void testVisitILiteral() throws Exception {
        String expected = "'string''Literal'";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestLiteralImpl.example((Object)"string'Literal")));
        expected = "1000";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestLiteralImpl.example((Object)new Integer(1000))));
        expected = "TRUE";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestLiteralImpl.example((Object)Boolean.TRUE)));
        long now = System.currentTimeMillis();
        Date date = new Date(now);
        expected = "{d '" + date.toString() + "'}";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestLiteralImpl.example((Object)date)));
        Timestamp ts = new Timestamp(now);
        expected = "{ts '" + ts.toString() + "'}";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestLiteralImpl.example((Object)ts)));
        Time t = new Time(now);
        expected = "{t '" + t.toString() + "'}";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestLiteralImpl.example((Object)t)));
    }

    @Test
    public void testVisitINotCriteria() throws Exception {
        String expected = "NOT (100 >= 200)";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestNotCriteriaImpl.example()));
    }

    @Test
    public void testVisitIOrderBy() throws Exception {
        String expected = "ORDER BY g1.e1, g1.e2 DESC, g1.e3, g1.e4 DESC";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestOrderByImpl.example()));
    }

    @Test
    public void testVisitIQuery() throws Exception {
        String expected = "SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE 100 >= 200 AND 500 < 600 GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING 100 >= 200 AND 500 < 600 ORDER BY g1.e1, g1.e2 DESC, g1.e3, g1.e4 DESC";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestQueryImpl.example((boolean)true)));
    }

    @Test
    public void testVisitIScalarSubquery() throws Exception {
        String expected = "(SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE 100 >= 200 AND 500 < 600 GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING 100 >= 200 AND 500 < 600 ORDER BY g1.e1, g1.e2 DESC, g1.e3, g1.e4 DESC)";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestScalarSubqueryImpl.example()));
    }

    @Test
    public void testVisitISearchedCaseExpression() throws Exception {
        String expected = "CASE WHEN g1.e1 = 0 THEN 0 WHEN g1.e1 = 1 THEN 1 WHEN g1.e1 = 2 THEN 2 ELSE 9999 END";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestSearchedCaseExpressionImpl.example()));
    }

    @Test
    public void testVisitISelect() throws Exception {
        String expected = "SELECT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE 100 >= 200 AND 500 < 600 GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING 100 >= 200 AND 500 < 600 ORDER BY g1.e1, g1.e2 DESC, g1.e3, g1.e4 DESC";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestQueryImpl.example((boolean)false)));
        expected = "SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE 100 >= 200 AND 500 < 600 GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING 100 >= 200 AND 500 < 600 ORDER BY g1.e1, g1.e2 DESC, g1.e3, g1.e4 DESC";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestQueryImpl.example((boolean)true)));
    }

    @Test
    public void testVisitISelectSymbol() throws Exception {
        String expected = "e1";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestSelectSymbolImpl.example((String)"e1", null)));
        expected = "e1 AS alias";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestSelectSymbolImpl.example((String)"e1", (String)"alias")));
    }

    @Test
    public void testVisitISubqueryCompareCriteria() throws Exception {
        String expected = "g1.e1 > SOME (SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE 100 >= 200 AND 500 < 600 GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING 100 >= 200 AND 500 < 600 ORDER BY g1.e1, g1.e2 DESC, g1.e3, g1.e4 DESC)";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestSubqueryCompareCriteriaImpl.example()));
    }

    @Test
    public void testVisitISubqueryInCriteria() throws Exception {
        String expected = "g1.e1 NOT IN (SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE 100 >= 200 AND 500 < 600 GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING 100 >= 200 AND 500 < 600 ORDER BY g1.e1, g1.e2 DESC, g1.e3, g1.e4 DESC)";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestSubqueryInCriteriaImpl.example()));
    }

    @Test
    public void testVisitIUnion1() throws Exception {
        String expected = "(SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE 100 >= 200 AND 500 < 600 GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING 100 >= 200 AND 500 < 600 ORDER BY g1.e1, g1.e2 DESC, g1.e3, g1.e4 DESC) UNION (SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE 100 >= 200 AND 500 < 600 GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING 100 >= 200 AND 500 < 600 ORDER BY g1.e1, g1.e2 DESC, g1.e3, g1.e4 DESC) ORDER BY e1, e2 DESC, e3, e4 DESC";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestSetQueryImpl.example()));
    }

    @Test
    public void testVisitIUnion2() throws Exception {
        String expected = "SELECT ted.nugent FROM ted UNION ALL SELECT dave.barry FROM dave";
        String actual = this.getString((LanguageObject)TestSetQueryImpl.example2());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testVisitIUnion3() throws Exception {
        String expected = "SELECT ted.nugent FROM ted UNION ALL SELECT dave.barry FROM dave ORDER BY nugent";
        String actual = this.getString((LanguageObject)TestSetQueryImpl.example3());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testVisitIUpdate() throws Exception {
        String expected = "UPDATE g1 SET e1 = 1, e2 = 1, e3 = 1, e4 = 1 WHERE 1 = 1";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestUpdateImpl.example()));
    }

    @Test
    public void testVisitProcedure() throws Exception {
        String expected = "EXEC sq3('x', 1)";
        Assert.assertEquals((Object)expected, (Object)this.getString((LanguageObject)TestProcedureImpl.example()));
    }

    @Test
    public void testTimestampAddFunction() throws Exception {
        String sql = "select timestampadd(SQL_TSI_DAY, 2, timestampvalue) from bqt1.smalla";
        Command command = FakeTranslationFactory.getInstance().getBQTTranslationUtility().parseCommand(sql);
        Assert.assertEquals((Object)"SELECT timestampadd(SQL_TSI_DAY, 2, SmallA.TimestampValue) FROM SmallA", (Object)command.toString());
    }

    @Test
    public void testInsertWithQuery() throws Exception {
        String sql = "insert into pm1.g1 values (null, null, null, null)";
        Insert insert = (Insert)FakeTranslationFactory.getInstance().getExampleTranslationUtility().parseCommand(sql);
        Select command = (Select)FakeTranslationFactory.getInstance().getExampleTranslationUtility().parseCommand("select * from pm1.g2");
        insert.setValueSource((InsertValueSource)command);
        Assert.assertEquals((Object)"INSERT INTO g1 (e1, e2, e3, e4) SELECT g2.e1, g2.e2, g2.e3, g2.e4 FROM g2", (Object)insert.toString());
    }

    @Test
    public void testUnrelatedOrderBy() throws Exception {
        String sql = "select intkey from bqt1.smalla order by stringkey";
        Command command = FakeTranslationFactory.getInstance().getBQTTranslationUtility().parseCommand(sql, true, true);
        Assert.assertEquals((Object)"SELECT g_0.IntKey AS c_0 FROM SmallA AS g_0 ORDER BY g_0.StringKey", (Object)command.toString());
    }

    @Test
    public void testOrderByDerivedColumn() throws Exception {
        String sql = "select intkey as x from bqt1.smalla order by intkey";
        Command command = FakeTranslationFactory.getInstance().getBQTTranslationUtility().parseCommand(sql, true, true);
        Assert.assertEquals((Object)"SELECT g_0.IntKey AS c_0 FROM SmallA AS g_0 ORDER BY c_0", (Object)command.toString());
    }

    @Test
    public void testOrderByAlias() throws Exception {
        String sql = "select intkey as x from bqt1.smalla order by x";
        Command command = FakeTranslationFactory.getInstance().getBQTTranslationUtility().parseCommand(sql, true, true);
        Assert.assertEquals((Object)"SELECT g_0.IntKey AS c_0 FROM SmallA AS g_0 ORDER BY c_0", (Object)command.toString());
    }

    @Test
    public void testOrderByNullOrdering() throws Exception {
        String sql = "select intkey as x from bqt1.smalla order by x nulls first";
        Command command = FakeTranslationFactory.getInstance().getBQTTranslationUtility().parseCommand(sql, true, true);
        Assert.assertEquals((Object)"SELECT g_0.IntKey AS c_0 FROM SmallA AS g_0 ORDER BY c_0 NULLS FIRST", (Object)command.toString());
    }

    @Test
    public void testWindowFunction() throws Exception {
        String sql = "select max(intnum) over (order by intkey nulls first) from bqt1.smalla";
        Command command = FakeTranslationFactory.getInstance().getBQTTranslationUtility().parseCommand(sql, true, true);
        Assert.assertEquals((Object)"SELECT MAX(g_0.IntNum) OVER (ORDER BY g_0.IntKey NULLS FIRST) FROM SmallA AS g_0", (Object)command.toString());
    }

    @Test
    public void testTrim() throws Exception {
        String sql = "select trim(both 'x' from stringkey) from bqt1.smalla";
        Command command = FakeTranslationFactory.getInstance().getBQTTranslationUtility().parseCommand(sql, true, true);
        Assert.assertEquals((Object)"SELECT trim('x' FROM g_0.StringKey) FROM SmallA AS g_0", (Object)command.toString());
    }

    @Test
    public void testNativeParsing() throws Exception {
        String sql = "select $1 from $2";
        String expected = "select *0 from *1";
        this.helpTestNativeParsing(sql, expected);
    }

    private void helpTestNativeParsing(String sql, String expected) {
        StringBuilder sb = new StringBuilder();
        SQLStringVisitor.Substitutor sub = new SQLStringVisitor.Substitutor(){

            public void substitute(Argument arg, StringBuilder builder, int index) {
                builder.append("*").append(index);
            }
        };
        SQLStringVisitor.parseNativeQueryParts((String)sql, Arrays.asList(new Argument(Argument.Direction.IN, null, String.class, null), new Argument(Argument.Direction.IN, null, String.class, null)), (StringBuilder)sb, (SQLStringVisitor.Substitutor)sub);
        Assert.assertEquals((Object)expected, (Object)sb.toString());
    }

    @Test
    public void testNativeParsing1() throws Exception {
        String sql = "select $$1 from $$$2";
        String expected = "select $1 from $*1";
        this.helpTestNativeParsing(sql, expected);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNativeParsing2() throws Exception {
        String sql = "select $$1 from $$$3";
        String expected = "select $1 from $*1";
        this.helpTestNativeParsing(sql, expected);
    }
}

