/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.service.AutoGenDataService;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.ConnectionProfile;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.jdbc.TestMMDatabaseMetaData;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.ServerConnection;
import org.teiid.net.socket.SocketServerConnectionFactory;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.translator.TranslatorException;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;

public class TestJDBCSocketTransport {
    static InetSocketAddress addr;
    static SocketListener jdbcTransport;
    static FakeServer server;
    Connection conn;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        SocketConfiguration config = new SocketConfiguration();
        config.setSSLConfiguration(new SSLConfiguration());
        addr = new InetSocketAddress(0);
        config.setBindAddress(addr.getHostName());
        config.setPortNumber(0);
        EmbeddedConfiguration dqpConfig = new EmbeddedConfiguration();
        dqpConfig.setMaxActivePlans(2);
        server = new FakeServer(false);
        server.start(dqpConfig, false);
        server.setUseCallingThread(false);
        server.deployVDB("parts", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        jdbcTransport = new SocketListener(addr, config, server.getClientServiceRegistry(), (StorageManager)BufferManagerFactory.getStandaloneBufferManager());
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        if (jdbcTransport != null) {
            jdbcTransport.stop();
        }
        server.stop();
    }

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        this.conn = TeiidDriver.getInstance().connect("jdbc:teiid:parts@mm://" + addr.getHostName() + ":" + jdbcTransport.getPort(), p);
    }

    @After
    public void tearDown() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Test
    public void testSelect() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables order by name"));
        TestMMDatabaseMetaData.compareResultSet(s.getResultSet());
    }

    @Test
    public void testLobStreaming() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select xmlelement(name \"root\") from tables"));
        s.getResultSet().next();
        Assert.assertEquals((Object)"<root></root>", (Object)s.getResultSet().getString(1));
    }

    @Test
    public void testLobStreaming1() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select cast('' as clob) from tables"));
        s.getResultSet().next();
        Assert.assertEquals((Object)"", (Object)s.getResultSet().getString(1));
    }

    @Test
    public void testVarbinary() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select X'aab1'"));
        s.getResultSet().next();
        byte[] bytes = s.getResultSet().getBytes(1);
        Assert.assertArrayEquals((byte[])new byte[]{-86, -79}, (byte[])bytes);
        Assert.assertArrayEquals((byte[])bytes, (byte[])s.getResultSet().getBlob(1).getBytes(1L, 2));
    }

    @Test
    public void testVarbinaryPrepared() throws Exception {
        PreparedStatement s = this.conn.prepareStatement("select cast(? as varbinary)");
        s.setBytes(1, "hello".getBytes());
        Assert.assertTrue((boolean)s.execute());
        s.getResultSet().next();
        byte[] bytes = s.getResultSet().getBytes(1);
        Assert.assertEquals((Object)"hello", (Object)new String(bytes));
    }

    @Test
    public void testXmlTableScrollable() throws Exception {
        Statement s = this.conn.createStatement(1004, 1007);
        Assert.assertTrue((boolean)s.execute("select * from xmltable('/root/row' passing (select xmlelement(name \"root\", xmlagg(xmlelement(name \"row\", xmlforest(t.name)) order by t.name)) from (select t.* from tables as t, columns as t1 limit 7000) as t) columns \"Name\" string) as x"));
        ResultSet rs = s.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((long)7000L, (long)count);
        rs.beforeFirst();
        while (rs.next()) {
            --count;
        }
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testGeneratedKeys() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("create local temporary table x (y serial, z integer, primary key (y))");
        Assert.assertFalse((boolean)s.execute("insert into x (z) values (1)", 1));
        ResultSet rs = s.getGeneratedKeys();
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
    }

    @Test
    public void testSimultaneousLargeSelects() throws Exception {
        for (int j = 0; j < 3; ++j) {
            Statement s = this.conn.createStatement();
            Assert.assertTrue((boolean)s.execute("select * from columns c1, columns c2"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyncTimeout() throws Exception {
        TeiidDriver td = new TeiidDriver();
        td.setSocketProfile(new ConnectionProfile(){

            public ConnectionImpl connect(String url, Properties info) throws TeiidSQLException {
                SocketServerConnectionFactory sscf = new SocketServerConnectionFactory();
                sscf.initialize(info);
                try {
                    return new ConnectionImpl((ServerConnection)sscf.getConnection(info), info, url);
                }
                catch (CommunicationException e) {
                    throw TeiidSQLException.create((Throwable)e);
                }
                catch (ConnectionException e) {
                    throw TeiidSQLException.create((Throwable)e);
                }
            }
        });
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        p.setProperty("org.teiid.sockets.soTimeout", "200");
        p.setProperty("org.teiid.sockets.SynchronousTtl", "100");
        ConnectorManagerRepository cmr = server.getConnectorManagerRepository();
        AutoGenDataService agds = new AutoGenDataService(){

            public Object getConnectionFactory() throws TranslatorException {
                return null;
            }
        };
        agds.setSleep(500);
        cmr.addConnectorManager("source", (ConnectorManager)agds);
        try {
            this.conn = td.connect("jdbc:teiid:parts@mm://" + addr.getHostName() + ":" + jdbcTransport.getPort(), p);
            Statement s = this.conn.createStatement();
            Assert.assertTrue((boolean)s.execute("select * from parts"));
        }
        finally {
            server.setConnectorManagerRepository(cmr);
        }
    }
}

