/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.AsynchPositioningException;
import org.teiid.jdbc.ContinuousStatementCallback;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.RequestOptions;
import org.teiid.jdbc.StatementCallback;
import org.teiid.jdbc.TeiidResultSet;
import org.teiid.jdbc.TeiidStatement;
import org.teiid.jdbc.TestMMDatabaseMetaData;

public class TestSystemVirtualModel
extends AbstractMMQueryTestCase {
    private static final String VDB = "PartsSupplier";
    private static FakeServer server;

    @BeforeClass
    public static void setup() throws Exception {
        server = new FakeServer(true);
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
    }

    @AfterClass
    public static void teardown() throws Exception {
        server.stop();
    }

    public TestSystemVirtualModel() {
        this.DELIMITER = "\t";
    }

    @Before
    public void setUp() throws Exception {
        this.internalConnection = server.createConnection("jdbc:teiid:PartsSupplier");
    }

    protected void checkResult(String testName, String query) throws Exception {
        this.execute(query);
        TestMMDatabaseMetaData.compareResultSet("TestSystemVirtualModel/" + testName, this.internalResultSet);
    }

    @Test
    public void testModels() throws Exception {
        this.checkResult("testSchemas", "select* from SYS.Schemas order by Name");
    }

    @Test
    public void testKeys() throws Exception {
        this.checkResult("testKeys", "select* from SYS.Keys order by Name");
    }

    @Test
    public void testGroups() throws Exception {
        this.checkResult("testTables", "select* from SYS.Tables order by Name");
    }

    @Test
    public void testDataTypes() throws Exception {
        this.checkResult("testDataTypes", "select * from SYS.DataTypes order by name");
    }

    @Test
    public void testProcedureParams() throws Exception {
        this.checkResult("testProcedureParams", "select * from SYS.ProcedureParams order by Name");
    }

    @Test
    public void testProcedures() throws Exception {
        this.checkResult("testProcedures", "select* from SYS.Procedures order by Name");
    }

    @Test
    public void testProperties() throws Exception {
        this.checkResult("testProperties", "select* from SYS.Properties");
    }

    @Test
    public void testVirtualDatabase() throws Exception {
        String[] expected = new String[]{"Name[string]\tVersion[string]\t", "PartsSupplier\t1"};
        this.executeAndAssertResults("select* from SYS.VirtualDatabases", expected);
    }

    @Test
    public void testKeyColumns() throws Exception {
        this.checkResult("testKeyColumns", "select* from SYS.KeyColumns order by Name, KeyName");
    }

    @Test
    public void testVDBResources() throws IOException, SQLException {
        this.execute("select * from vdbresources", new Object[0]);
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void testColumns() throws Exception {
        this.checkResult("testColumns", "select* from SYS.Columns order by Name");
    }

    @Test
    public void testTableType() throws Exception {
        String[] expected = new String[]{"Type[string]\t", "Table"};
        this.executeAndAssertResults("select distinct Type from SYS.Tables order by Type", expected);
    }

    @Test
    public void testTableIsSystem() throws Exception {
        this.checkResult("testTableIsSystem", "select Name from SYS.Tables where IsSystem = 'false' order by Name");
    }

    @Test
    public void testDefect12064() throws Exception {
        this.checkResult("testDefect12064", "select KeyName, RefKeyUID FROM SYS.KeyColumns WHERE RefKeyUID IS NULL order by KeyName");
    }

    @Test
    public void testReferenceKeyColumns() throws Exception {
        this.checkResult("testReferenceKeyColumns", "select* FROM SYS.ReferenceKeyColumns order by PKTABLE_NAME");
    }

    @Test
    public void testLogMsg() throws Exception {
        this.execute("call logMsg(level=>'DEBUG', context=>'org.teiid.foo', msg=>'hello world')");
    }

    @Test(expected=SQLException.class)
    public void testLogMsg1() throws Exception {
        this.execute("call logMsg(level=>'foo', context=>'org.teiid.foo', msg=>'hello world')");
    }

    @Test
    public void testAsynch() throws Exception {
        Statement stmt = this.internalConnection.createStatement();
        TeiidStatement ts = stmt.unwrap(TeiidStatement.class);
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("select * from SYS.columns a, sys.tables b", new StatementCallback(){
            int rowCount;

            public void onRow(Statement s, ResultSet rs) {
                ++this.rowCount;
                try {
                    if (!rs.isLast()) {
                        Assert.assertTrue((rs.unwrap(TeiidResultSet.class).available() > 0 ? 1 : 0) != 0);
                    }
                }
                catch (AsynchPositioningException e) {
                    try {
                        Assert.assertEquals((long)0L, (long)rs.unwrap(TeiidResultSet.class).available());
                    }
                    catch (SQLException e1) {
                        result.getResultsReceiver().exceptionOccurred((Throwable)e1);
                    }
                }
                catch (SQLException e) {
                    result.getResultsReceiver().exceptionOccurred((Throwable)e);
                }
            }

            public void onException(Statement s, Exception e) {
                result.getResultsReceiver().exceptionOccurred((Throwable)e);
            }

            public void onComplete(Statement s) {
                result.getResultsReceiver().receiveResults((Object)this.rowCount);
            }
        }, new RequestOptions());
        Assert.assertEquals((long)8288L, (long)((Integer)result.get()).intValue());
    }

    @Test
    public void testAsynchContinuousEmpty() throws Exception {
        Statement stmt = this.internalConnection.createStatement();
        TeiidStatement ts = stmt.unwrap(TeiidStatement.class);
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("select * from SYS.Schemas where 1 = 0", (StatementCallback)new ContinuousStatementCallback(){
            int execCount;

            public void onRow(Statement s, ResultSet rs) throws SQLException {
                Assert.fail();
            }

            public void onException(Statement s, Exception e) {
                result.getResultsReceiver().exceptionOccurred((Throwable)e);
            }

            public void onComplete(Statement s) {
                result.getResultsReceiver().receiveResults((Object)this.execCount);
            }

            public void beforeNextExecution(Statement s) throws SQLException {
                ++this.execCount;
                Assert.assertEquals((long)-1L, (long)s.getResultSet().unwrap(TeiidResultSet.class).available());
                if (this.execCount == 1024) {
                    s.close();
                }
            }
        }, new RequestOptions().continuous(true));
        Assert.assertEquals((long)1024L, (long)((Integer)result.get()).intValue());
    }

    @Test
    public void testAsynchContinuousNonEmpty() throws Exception {
        Statement stmt = this.internalConnection.createStatement();
        TeiidStatement ts = stmt.unwrap(TeiidStatement.class);
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("select 1", (StatementCallback)new ContinuousStatementCallback(){
            int execCount;

            public void onRow(Statement s, ResultSet rs) throws SQLException {
                Assert.assertEquals((long)0L, (long)rs.unwrap(TeiidResultSet.class).available());
                s.close();
            }

            public void onException(Statement s, Exception e) {
                result.getResultsReceiver().exceptionOccurred((Throwable)e);
            }

            public void onComplete(Statement s) {
                result.getResultsReceiver().receiveResults((Object)this.execCount);
            }

            public void beforeNextExecution(Statement s) throws SQLException {
                ++this.execCount;
            }
        }, new RequestOptions().continuous(true));
        Assert.assertEquals((long)0L, (long)((Integer)result.get()).intValue());
    }

    @Test
    public void testAsynchContinuous() throws Exception {
        Statement stmt = this.internalConnection.createStatement();
        TeiidStatement ts = stmt.unwrap(TeiidStatement.class);
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("select xmlelement(name x) from SYS.Schemas", new StatementCallback(){
            int rowCount;

            public void onRow(Statement s, ResultSet rs) throws SQLException {
                ++this.rowCount;
                if (this.rowCount == 1024) {
                    s.close();
                }
            }

            public void onException(Statement s, Exception e) {
                result.getResultsReceiver().exceptionOccurred((Throwable)e);
            }

            public void onComplete(Statement s) {
                result.getResultsReceiver().receiveResults((Object)this.rowCount);
            }
        }, new RequestOptions().continuous(true));
        Assert.assertEquals((long)1024L, (long)((Integer)result.get()).intValue());
    }

    @Test
    public void testCallableParametersByName() throws Exception {
        CallableStatement cs = this.internalConnection.prepareCall("{? = call logMsg(?, ?, ?)}");
        ParameterMetaData pmd = cs.getParameterMetaData();
        Assert.assertEquals((long)3L, (long)pmd.getParameterCount());
        cs.registerOutParameter("logged", 16);
        cs.setString("LEVEL", "DEBUG");
        try {
            cs.setString("n", "");
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        cs.setString("context", "org.teiid.foo");
        cs.setString("msg", "hello world");
        cs.execute();
        Assert.assertEquals((Object)cs.getBoolean(1), (Object)cs.getBoolean("logged"));
    }

    @Test
    public void testArrayAggType() throws Exception {
        String sql = "SELECT array_agg(name) from tables";
        this.checkResult("testArrayAggType", sql);
    }
}

