/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.FakeServer;

public class TestStats {
    static Connection connection;
    static final String VDB = "PartsSupplier";

    @BeforeClass
    public static void setUp() throws Exception {
        FakeServer server = new FakeServer(true);
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        connection = server.createConnection("jdbc:teiid:PartsSupplier");
    }

    @AfterClass
    public static void tearDown() throws SQLException {
        connection.close();
    }

    @Test
    public void testSetTableStats() throws Exception {
        Statement s = connection.createStatement();
        ResultSet rs = s.executeQuery("select cardinality from tables where name = 'PARTSSUPPLIER.PARTS'");
        rs.next();
        Assert.assertEquals((long)16L, (long)rs.getInt(1));
        s.execute("call setTableStats(tableName=>'partssupplier.partssupplier.parts', cardinality=>32)");
        rs = s.executeQuery("select cardinality from tables where name = 'PARTSSUPPLIER.PARTS'");
        rs.next();
        Assert.assertEquals((long)32L, (long)rs.getInt(1));
    }

    @Test
    public void testSetColumnStats() throws Exception {
        Statement s = connection.createStatement();
        ResultSet rs = s.executeQuery("select MinRange, MaxRange, DistinctCount, NullCount from columns where name = 'PART_ID'");
        rs.next();
        Assert.assertEquals(null, (Object)rs.getString(1));
        Assert.assertEquals(null, (Object)rs.getString(2));
        Assert.assertEquals((long)-1L, (long)rs.getInt(3));
        Assert.assertEquals((long)-1L, (long)rs.getInt(4));
        s.execute("call setColumnStats(tableName=>'partssupplier.partssupplier.parts', columnName=>'PART_ID', max=>32, nullcount=>0)");
        rs = s.executeQuery("select MinRange, MaxRange, DistinctCount, NullCount from columns where name = 'PART_ID'");
        rs.next();
        Assert.assertEquals(null, (Object)rs.getString(1));
        Assert.assertEquals((Object)"32", (Object)rs.getString(2));
        Assert.assertEquals((long)-1L, (long)rs.getInt(3));
        Assert.assertEquals((long)0L, (long)rs.getInt(4));
    }

    @Test(expected=SQLException.class)
    public void testSetColumnStatsInvalidColumn() throws Exception {
        Statement s = connection.createStatement();
        s.execute("call setColumnStats(tableName=>'partssupplier.partssupplier.parts', columnName=>'foo', max=>32, nullcount=>0)");
    }
}

