/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.HardCodedExecutionFactory;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.translator.loopback.LoopbackExecutionFactory;

public class TestMatViews {
    private static final String MATVIEWS = "matviews";
    private Connection conn;
    private FakeServer server;
    private static int count = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int pause() throws InterruptedException {
        Class<TestMatViews> clazz = TestMatViews.class;
        synchronized (TestMatViews.class) {
            ++count;
            TestMatViews.class.notify();
            while (count < 2) {
                TestMatViews.class.wait();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return 1;
        }
    }

    @Before
    public void setUp() throws Exception {
        this.server = new FakeServer(true);
        HashMap<String, Collection<FunctionMethod>> udfs = new HashMap<String, Collection<FunctionMethod>>();
        udfs.put("funcs", Arrays.asList(new FunctionMethod("pause", null, null, FunctionMethod.PushDown.CANNOT_PUSHDOWN, TestMatViews.class.getName(), "pause", null, new FunctionParameter("return", "integer"), true, FunctionMethod.Determinism.NONDETERMINISTIC)));
        this.server.deployVDB(MATVIEWS, UnitTestUtil.getTestDataPath() + "/matviews.vdb", new FakeServer.DeployVDBParameter(udfs, null));
        this.conn = this.server.createConnection("jdbc:teiid:matviews");
    }

    @After
    public void tearDown() throws Exception {
        this.conn.close();
        this.server.stop();
    }

    @Test
    public void testSystemMatViewsWithImplicitLoad() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select * from MatViews order by name");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"NEEDS_LOADING", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)"#MAT_TEST.ERRORVIEW", (Object)rs.getString("targetName"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"NEEDS_LOADING", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)"#MAT_TEST.MATVIEW", (Object)rs.getString("targetName"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean("valid"));
        Assert.assertEquals((Object)"#MAT_TEST.RANDOMVIEW", (Object)rs.getString("targetName"));
        rs = s.executeQuery("select * from MatView");
        Assert.assertTrue((boolean)rs.next());
        rs = s.executeQuery("select * from MatViews where name = 'MatView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        try {
            s.executeQuery("select * from ErrorView");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        rs = s.executeQuery("select * from MatViews where name = 'ErrorView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"FAILED_LOAD", (Object)rs.getString("loadstate"));
    }

    @Test
    public void testSystemMatViewsWithExplicitRefresh() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select * from (call refreshMatView('TEST.RANDOMVIEW', false)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from MatViews where name = 'RandomView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
        rs = s.executeQuery("select x from TEST.RANDOMVIEW");
        Assert.assertTrue((boolean)rs.next());
        double key = rs.getDouble(1);
        rs = s.executeQuery("select * from (call refreshMatView('TEST.RANDOMVIEW', false)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from MatViews where name = 'RandomView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
        rs = s.executeQuery("select x from TEST.RANDOMVIEW");
        Assert.assertTrue((boolean)rs.next());
        double key1 = rs.getDouble(1);
        Assert.assertTrue((key1 != key ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemManViewsWithExplictRefreshAndInvalidate() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select * from (call refreshMatView('TEST.MATVIEW', false)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from MatViews where name = 'MatView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
        count = 0;
        s.execute("alter view TEST.MATVIEW as select pause() as x");
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Statement s1 = TestMatViews.this.conn.createStatement();
                    ResultSet rs = s1.executeQuery("select * from (call refreshMatView('TEST.MATVIEW', true)) p");
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt(1));
                }
                catch (Exception e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
        };
        t.start();
        Class<TestMatViews> clazz = TestMatViews.class;
        synchronized (TestMatViews.class) {
            while (count < 1) {
                TestMatViews.class.wait();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            rs = s.executeQuery("select * from MatViews where name = 'MatView'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"NEEDS_LOADING", (Object)rs.getString("loadstate"));
            Assert.assertEquals((Object)false, (Object)rs.getBoolean("valid"));
            clazz = TestMatViews.class;
            synchronized (TestMatViews.class) {
                ++count;
                TestMatViews.class.notify();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                t.join();
                rs = s.executeQuery("select * from MatViews where name = 'MatView'");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
                Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
                return;
            }
        }
    }

    @Test(expected=TeiidSQLException.class)
    public void testSystemMatViewsInvalidView() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("call refreshMatView('TEST.NotMat', false)");
    }

    @Test(expected=TeiidSQLException.class)
    public void testSystemMatViewsInvalidView1() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("call refreshMatView('foo', false)");
    }

    @Test(expected=TeiidSQLException.class)
    public void testSystemMatViewsWithRowRefreshNotAllowed() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("alter view test.randomview as select rand() as x, rand() as y");
        ResultSet rs = s.executeQuery("select * from (call refreshMatView('TEST.RANDOMVIEW', false)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from MatViews where name = 'RandomView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
        rs = s.executeQuery("select x from TEST.RANDOMVIEW");
        Assert.assertTrue((boolean)rs.next());
        double key = rs.getDouble(1);
        rs = s.executeQuery("select * from (call refreshMatViewRow('TEST.RANDOMVIEW', " + key + ")) p");
    }

    @Test
    public void testSystemMatViewsWithRowRefresh() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("alter view test.randomview as /*+ cache(updatable) */ select rand() as x, rand() as y");
        ResultSet rs = s.executeQuery("select * from (call refreshMatViewRow('TEST.RANDOMVIEW', 0)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)-1L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from (call refreshMatView('TEST.RANDOMVIEW', false)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from MatViews where name = 'RandomView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
        rs = s.executeQuery("select x from TEST.RANDOMVIEW");
        Assert.assertTrue((boolean)rs.next());
        double key = rs.getDouble(1);
        rs = s.executeQuery("select * from (call refreshMatViewRow('TEST.RANDOMVIEW', " + key + ")) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from TEST.RANDOMVIEW");
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from (call refreshMatViewRow('TEST.RANDOMVIEW', " + key + ")) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
    }

    @Test(expected=TeiidSQLException.class)
    public void testSystemMatViewsWithRowRefreshNoPk() throws Exception {
        Statement s = this.conn.createStatement();
        s.executeQuery("select * from (call refreshMatView('TEST.MATVIEW', false)) p");
        s.executeQuery("select * from (call refreshMatViewRow('TEST.MATVIEW', 0)) p");
    }

    @Test
    public void testMatViewWithImportedVDB() throws Exception {
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("phy");
        mmd.setSchemaSourceType("DDL");
        mmd.setSchemaText("CREATE FOREIGN TABLE t1 ( col1 string, col2 integer )");
        mmd.addSourceMapping("phy", "loopback", null);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("phy_mv");
        mmd1.setSchemaSourceType("DDL");
        mmd1.setSchemaText("CREATE FOREIGN TABLE t1_mv ( col1 string, col2 integer )");
        mmd1.addSourceMapping("phy_mv", "loopback", null);
        ModelMetaData mmd2 = new ModelMetaData();
        mmd2.setName("view1");
        mmd2.setModelType(Model.Type.VIRTUAL);
        mmd2.setSchemaSourceType("DDL");
        mmd2.setSchemaText("CREATE VIEW v1 ( col1 string, col2 integer ) OPTIONS (MATERIALIZED true, MATERIALIZED_TABLE 'phy_mv.t1_mv') AS select t1.col1, t1.col2 FROM t1");
        this.server.addTranslator(LoopbackExecutionFactory.class);
        this.server.deployVDB("base", new ModelMetaData[]{mmd, mmd1, mmd2});
        VDBMetaData vdbMetaData = new VDBMetaData();
        vdbMetaData.setXmlDeployment(true);
        VDBImportMetadata importVDB = new VDBImportMetadata();
        importVDB.setName("base");
        importVDB.setVersion(1);
        vdbMetaData.getVDBImports().add(importVDB);
        vdbMetaData.setName("importing");
        this.server.deployVDB(vdbMetaData);
    }

    @Test
    public void testImportedMatView() throws Exception {
        ModelMetaData mmd2 = new ModelMetaData();
        mmd2.setName("view1");
        mmd2.setModelType(Model.Type.PHYSICAL);
        mmd2.setSchemaSourceType("DDL");
        mmd2.setSchemaText("create foreign table x (col integer); CREATE VIEW v1 ( col1 string ) OPTIONS (MATERIALIZED true) AS select current_database() from x");
        mmd2.addSourceMapping("a", "a", null);
        HardCodedExecutionFactory hcef = new HardCodedExecutionFactory();
        hcef.addData("SELECT x.col FROM x", Arrays.asList(Collections.singletonList(1)));
        this.server.addTranslator("a", hcef);
        this.server.deployVDB("base", new ModelMetaData[]{mmd2});
        VDBMetaData vdbMetaData = new VDBMetaData();
        vdbMetaData.setXmlDeployment(true);
        VDBImportMetadata importVDB = new VDBImportMetadata();
        importVDB.setName("base");
        importVDB.setVersion(1);
        vdbMetaData.getVDBImports().add(importVDB);
        vdbMetaData.setName("importing");
        this.server.deployVDB(vdbMetaData);
        ConnectionImpl c = this.server.getDriver().connect("jdbc:teiid:importing", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from v1");
        rs.next();
        Assert.assertEquals((Object)"base", (Object)rs.getString(1));
    }

    @Test
    public void testSessionScoping() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("alter view test.randomview as /*+ cache(scope:session) */ select rand() as x, rand() as y");
        ResultSet rs = s.executeQuery("select * from MatViews where name = 'MatView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"NEEDS_LOADING", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)false, (Object)rs.getBoolean("valid"));
        rs = s.executeQuery("select * from randomview");
        rs.next();
        double d = rs.getDouble(1);
        rs = s.executeQuery("select * from randomview");
        rs.next();
        Assert.assertEquals((double)d, (double)rs.getDouble(1), (double)0.0);
        rs = s.executeQuery("select * from MatViews where name = 'RandomView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
        ConnectionImpl c = this.server.getDriver().connect("jdbc:teiid:matviews", null);
        rs = s.executeQuery("select * from MatViews where name = 'MatView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"NEEDS_LOADING", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)false, (Object)rs.getBoolean("valid"));
        s = c.createStatement();
        rs = s.executeQuery("select * from randomview");
        rs.next();
        Assert.assertFalse((d == rs.getDouble(1) ? 1 : 0) != 0);
        s.execute("call refreshMatView('TEST.RANDOMVIEW', false)");
        rs = s.executeQuery("select * from randomview");
        rs.next();
        Assert.assertFalse((d == rs.getDouble(1) ? 1 : 0) != 0);
    }
}

