/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.client.util.ResultsFuture;
import org.teiid.jdbc.AsynchPositioningException;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.ContinuousStatementCallback;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.HardCodedExecutionFactory;
import org.teiid.jdbc.RequestOptions;
import org.teiid.jdbc.StatementCallback;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TeiidResultSet;
import org.teiid.jdbc.TeiidStatement;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;

public class TestAsynch {
    private static FakeServer server;
    private ConnectionImpl internalConnection;
    private static HardCodedExecutionFactory ef;
    private static List<String> partIds;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        server = new FakeServer(true);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("v");
        mmd.setModelType(Model.Type.PHYSICAL);
        mmd.setSchemaSourceType("ddl");
        mmd.addSourceMapping("z", "z", null);
        mmd.setSchemaText("create view test (col integer) as select 1; create foreign table someTable (col integer);");
        ef = new HardCodedExecutionFactory(){

            @Override
            public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                partIds.add(executionContext.getPartIdentifier());
                return super.createResultSetExecution(command, executionContext, metadata, connection);
            }
        };
        server.addTranslator("z", ef);
        server.deployVDB("x", new ModelMetaData[]{mmd});
    }

    @AfterClass
    public static void oneTimeTeardown() throws Exception {
        partIds.clear();
        server.stop();
    }

    @Before
    public void setUp() throws Exception {
        this.internalConnection = server.createConnection("jdbc:teiid:x");
    }

    @Test
    public void testAsynch() throws Exception {
        StatementImpl stmt = this.internalConnection.createStatement();
        TeiidStatement ts = stmt.unwrap(TeiidStatement.class);
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("select * from sys.tables a, sys.tables b, sys.tables c", new StatementCallback(){
            int rowCount;

            public void onRow(Statement s, ResultSet rs) {
                ++this.rowCount;
                try {
                    if (!rs.isLast()) {
                        Assert.assertTrue((rs.unwrap(TeiidResultSet.class).available() > 0 ? 1 : 0) != 0);
                    }
                    if (this.rowCount == 10000) {
                        s.close();
                    }
                }
                catch (AsynchPositioningException e) {
                    try {
                        Assert.assertEquals((long)0L, (long)rs.unwrap(TeiidResultSet.class).available());
                    }
                    catch (SQLException e1) {
                        result.getResultsReceiver().exceptionOccurred((Throwable)e1);
                    }
                }
                catch (SQLException e) {
                    result.getResultsReceiver().exceptionOccurred((Throwable)e);
                }
            }

            public void onException(Statement s, Exception e) {
                result.getResultsReceiver().exceptionOccurred((Throwable)e);
            }

            public void onComplete(Statement s) {
                result.getResultsReceiver().receiveResults((Object)this.rowCount);
            }
        }, new RequestOptions());
        Assert.assertEquals((long)10000L, (long)((Integer)result.get()).intValue());
    }

    @Test
    public void testAsynchContinuousEmpty() throws Exception {
        StatementImpl stmt = this.internalConnection.createStatement();
        TeiidStatement ts = stmt.unwrap(TeiidStatement.class);
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("select * from SYS.Schemas where 1 = 0", (StatementCallback)new ContinuousStatementCallback(){
            int execCount;

            public void onRow(Statement s, ResultSet rs) throws SQLException {
                Assert.fail();
            }

            public void onException(Statement s, Exception e) {
                result.getResultsReceiver().exceptionOccurred((Throwable)e);
            }

            public void onComplete(Statement s) {
                result.getResultsReceiver().receiveResults((Object)this.execCount);
            }

            public void beforeNextExecution(Statement s) throws SQLException {
                ++this.execCount;
                Assert.assertEquals((long)-1L, (long)s.getResultSet().unwrap(TeiidResultSet.class).available());
                if (this.execCount == 1024) {
                    s.close();
                }
            }
        }, new RequestOptions().continuous(true));
        Assert.assertEquals((long)1024L, (long)((Integer)result.get()).intValue());
    }

    @Test
    public void testAsynchContinuousNonEmpty() throws Exception {
        StatementImpl stmt = this.internalConnection.createStatement();
        TeiidStatement ts = stmt.unwrap(TeiidStatement.class);
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("select 1", (StatementCallback)new ContinuousStatementCallback(){
            int execCount;

            public void onRow(Statement s, ResultSet rs) throws SQLException {
                Assert.assertEquals((long)0L, (long)rs.unwrap(TeiidResultSet.class).available());
                s.close();
            }

            public void onException(Statement s, Exception e) {
                result.getResultsReceiver().exceptionOccurred((Throwable)e);
            }

            public void onComplete(Statement s) {
                result.getResultsReceiver().receiveResults((Object)this.execCount);
            }

            public void beforeNextExecution(Statement s) throws SQLException {
                ++this.execCount;
            }
        }, new RequestOptions().continuous(true));
        Assert.assertEquals((long)0L, (long)((Integer)result.get()).intValue());
    }

    @Test
    public void testAsynchContinuous() throws Exception {
        StatementImpl stmt = this.internalConnection.createStatement();
        TeiidStatement ts = stmt.unwrap(TeiidStatement.class);
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("select xmlelement(name x) from SYS.Schemas", new StatementCallback(){
            int rowCount;

            public void onRow(Statement s, ResultSet rs) throws SQLException {
                ++this.rowCount;
                if (this.rowCount == 1024) {
                    s.close();
                }
            }

            public void onException(Statement s, Exception e) {
                result.getResultsReceiver().exceptionOccurred((Throwable)e);
            }

            public void onComplete(Statement s) {
                result.getResultsReceiver().receiveResults((Object)this.rowCount);
            }
        }, new RequestOptions().continuous(true));
        Assert.assertEquals((long)1024L, (long)((Integer)result.get()).intValue());
    }

    @Test
    public void testAsynchContinuousMergeBlock() throws Exception {
        StatementImpl stmt = this.internalConnection.createStatement();
        stmt.execute("create temporary table t (c string, primary key (c))");
        stmt.execute("set autoCommitTxn off");
        TeiidStatement ts = stmt.unwrap(TeiidStatement.class);
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("begin merge into t select name from schemas limit 2; select rowcount; end", new StatementCallback(){
            int rowCount;

            public void onRow(Statement s, ResultSet rs) throws SQLException {
                ++this.rowCount;
                if (this.rowCount == 10) {
                    s.close();
                }
            }

            public void onException(Statement s, Exception e) {
                result.getResultsReceiver().exceptionOccurred((Throwable)e);
            }

            public void onComplete(Statement s) {
                result.getResultsReceiver().receiveResults((Object)this.rowCount);
            }
        }, new RequestOptions().continuous(true));
        Assert.assertEquals((long)10L, (long)((Integer)result.get()).intValue());
        stmt = this.internalConnection.createStatement();
        ResultSet rs = stmt.executeQuery("select count(*) from t");
        rs.next();
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
    }

    @Test
    public void testAsynchContinuousWithAlter() throws Exception {
        StatementImpl stmt = this.internalConnection.createStatement();
        TeiidStatement ts = stmt.unwrap(TeiidStatement.class);
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("select * from test", new StatementCallback(){
            int rowCount;

            public void onRow(Statement s, ResultSet rs) {
                try {
                    ++this.rowCount;
                    if (this.rowCount < 3) {
                        Assert.assertEquals((long)1L, (long)rs.getInt(1));
                        if (this.rowCount == 2) {
                            StatementImpl st = TestAsynch.this.internalConnection.createStatement();
                            st.execute("alter view v.test as select 2");
                            st.close();
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                result.getResultsReceiver().exceptionOccurred((Throwable)e);
                            }
                        }
                    } else {
                        Assert.assertEquals((long)2L, (long)rs.getInt(1));
                        s.close();
                    }
                }
                catch (SQLException e) {
                    result.getResultsReceiver().exceptionOccurred((Throwable)e);
                    throw new RuntimeException(e);
                }
            }

            public void onException(Statement s, Exception e) {
                result.getResultsReceiver().exceptionOccurred((Throwable)e);
            }

            public void onComplete(Statement s) {
                result.getResultsReceiver().receiveResults((Object)this.rowCount);
            }
        }, new RequestOptions().continuous(true));
        Assert.assertEquals((long)3L, (long)((Integer)result.get()).intValue());
    }

    @Test
    public void testAsynchPlaning() throws Exception {
        StatementImpl stmt = this.internalConnection.createStatement();
        TeiidStatement ts = stmt.unwrap(TeiidStatement.class);
        ef.addData("SELECT someTable.col FROM someTable", Arrays.asList(Arrays.asList(1)));
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("select * from someTable", new StatementCallback(){
            int rowCount;

            public void onRow(Statement s, ResultSet rs) {
                try {
                    ++this.rowCount;
                    if (this.rowCount == 3) {
                        s.close();
                    }
                }
                catch (SQLException e) {
                    result.getResultsReceiver().exceptionOccurred((Throwable)e);
                    throw new RuntimeException(e);
                }
            }

            public void onException(Statement s, Exception e) {
                result.getResultsReceiver().exceptionOccurred((Throwable)e);
            }

            public void onComplete(Statement s) {
                result.getResultsReceiver().receiveResults((Object)this.rowCount);
            }
        }, new RequestOptions().continuous(true));
        Assert.assertEquals((long)3L, (long)((Integer)result.get()).intValue());
        Assert.assertEquals((long)3L, (long)partIds.size());
        Assert.assertEquals((Object)partIds.get(0), (Object)partIds.get(1));
        Assert.assertEquals((Object)partIds.get(1), (Object)partIds.get(2));
    }

    static {
        partIds = new ArrayList<String>();
    }
}

