/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestVDBReuse
extends AbstractMMQueryTestCase {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9999, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testReuse() throws Exception {
        this.admin.deploy("dynamicview-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"dynamicview-vdb.xml")));
        Properties props = new Properties();
        props.setProperty("ParentDirectory", ".");
        props.setProperty("AllowParentPaths", "true");
        props.setProperty("class-name", "org.teiid.resource.adapter.file.FileManagedConnectionFactory");
        AdminUtil.createDataSource(this.admin, "marketdata-file", "file", props);
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "dynamic", 1, 3));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:dynamic@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT * FROM Stock");
        this.execute("SELECT count(*) FROM Sys.Columns");
        this.internalResultSet.next();
        int cols = this.internalResultSet.getInt(1);
        this.admin.deploy("reuse-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"reuse-vdb.xml")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "reuse", 1, 3));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:reuse@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT count(*) FROM Sys.Columns");
        this.internalResultSet.next();
        Assert.assertTrue((this.internalResultSet.getInt(1) > cols ? 1 : 0) != 0);
        this.admin.deploy("reuse1-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"reuse1-vdb.xml")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "reuse1", 1, 3));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:reuse1@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT * FROM Stock2");
    }
}

