/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.FakeServer;

public class TestResultsCache {
    private Connection conn;
    private static FakeServer server;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        server = new FakeServer(true);
        server.deployVDB("test", UnitTestUtil.getTestDataPath() + "/TestCase3473/test.vdb");
    }

    @AfterClass
    public static void oneTimeTeardown() {
        server.stop();
    }

    @Before
    public void setUp() throws Exception {
        this.conn = server.createConnection("jdbc:teiid:test");
    }

    @After
    public void teardown() throws SQLException {
        this.conn.close();
    }

    @Test
    public void testCacheHint() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("set showplan on");
        ResultSet rs = s.executeQuery("/* cache */ select 1");
        Assert.assertTrue((boolean)rs.next());
        s.execute("set noexec on");
        rs = s.executeQuery("/* cache */ select 1");
        Assert.assertTrue((boolean)rs.next());
        rs = s.executeQuery("select 1");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testCacheHintWithMaxRows() throws Exception {
        Statement s = this.conn.createStatement();
        s.setMaxRows(1);
        ResultSet rs = s.executeQuery("/* cache */ select 1 union all select 2");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        s.setMaxRows(2);
        rs = s.executeQuery("/* cache */ select 1 union all select 2");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testCacheHintTtl() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("set showplan on");
        ResultSet rs = s.executeQuery("/*+ cache(ttl:50) */ select 1");
        Assert.assertTrue((boolean)rs.next());
        s.execute("set noexec on");
        Thread.sleep(60L);
        rs = s.executeQuery("/*+ cache(ttl:50) */ select 1");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testExecutionProperty() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("set showplan on");
        s.execute("set resultSetCacheMode true");
        ResultSet rs = s.executeQuery("select 1");
        Assert.assertTrue((boolean)rs.next());
        s.execute("set noexec on");
        rs = s.executeQuery("select 1");
        Assert.assertTrue((boolean)rs.next());
        s.execute("set resultSetCacheMode false");
        rs = s.executeQuery("select 1");
        Assert.assertFalse((boolean)rs.next());
    }
}

