/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.CommandContext;
import org.teiid.jdbc.TeiidConnection;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.WireProtocol;

public class TestInternalConnection {
    private static final String vdb = "<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE VIEW helloworld as SELECT 'HELLO WORLD';CREATE function func (val integer) returns string options (JAVA_CLASS '" + TestInternalConnection.class.getName() + "',  JAVA_METHOD 'doSomething');]]> </metadata></model></vdb>";
    EmbeddedServer es;

    @Before
    public void setup() {
        this.es = new EmbeddedServer();
    }

    @After
    public void teardown() {
        this.es.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doSomething(CommandContext cc, Integer val) throws SQLException {
        TeiidConnection tc = cc.getConnection();
        try {
            Statement s = tc.createStatement();
            ResultSet rs = s.executeQuery("select user(), expr1 from helloworld");
            rs.next();
            String string = rs.getString(1) + rs.getString(2) + val;
            return string;
        }
        finally {
            tc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInternalRemote() throws Exception {
        SocketConfiguration s = new SocketConfiguration();
        InetSocketAddress addr = new InetSocketAddress(0);
        s.setBindAddress(addr.getHostName());
        s.setPortNumber(addr.getPort());
        s.setProtocol(WireProtocol.teiid);
        EmbeddedConfiguration config = new EmbeddedConfiguration();
        config.addTransport(s);
        this.es.start(config);
        this.es.deployVDB((InputStream)new ByteArrayInputStream(vdb.getBytes()));
        Connection conn = null;
        try {
            TeiidDriver driver = new TeiidDriver();
            Properties p = new Properties();
            p.setProperty("user", "me");
            conn = driver.connect("jdbc:teiid:test@mm://" + addr.getHostName() + ":" + this.es.getPort(0), p);
            ResultSet rs = conn.createStatement().executeQuery("select func(1)");
            rs.next();
            Assert.assertEquals((Object)"me@teiid-securityHELLO WORLD1", (Object)rs.getString(1));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInternalLocal() throws Exception {
        EmbeddedConfiguration config = new EmbeddedConfiguration();
        this.es.start(config);
        this.es.deployVDB((InputStream)new ByteArrayInputStream(vdb.getBytes()));
        Connection conn = null;
        try {
            TeiidDriver driver = this.es.getDriver();
            conn = driver.connect("jdbc:teiid:test", null);
            ResultSet rs = conn.createStatement().executeQuery("select func(2)");
            rs.next();
            Assert.assertEquals((Object)"anonymous@teiid-securityHELLO WORLD2", (Object)rs.getString(1));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

