/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.util.Map;
import junit.framework.TestCase;
import org.teiid.dqp.internal.process.MetaDataProcessor;
import org.teiid.jdbc.MetadataProvider;
import org.teiid.jdbc.ResultSetMetaDataImpl;

public class TestResultsMetadataWithProvider
extends TestCase {
    public TestResultsMetadataWithProvider(String name) {
        super(name);
    }

    public MetadataProvider exampleProvider() throws Exception {
        MetaDataProcessor processor = new MetaDataProcessor(null, null, "vdb", 1);
        Map col1 = processor.getDefaultColumn("table", "col1", "col1Label", String.class);
        Map col2 = processor.getDefaultColumn("table", "col2", "col2Label", Integer.class);
        Map[] columnMetadata = new Map[]{col1, col2};
        MetadataProvider provider = new MetadataProvider(columnMetadata);
        return provider;
    }

    public void test1() throws Exception {
        ResultSetMetaDataImpl rmd = new ResultSetMetaDataImpl(this.exampleProvider(), null);
        TestResultsMetadataWithProvider.assertEquals((boolean)false, (boolean)rmd.isAutoIncrement(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)false, (boolean)rmd.isCaseSensitive(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)false, (boolean)rmd.isCurrency(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)true, (boolean)rmd.isDefinitelyWritable(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)false, (boolean)rmd.isReadOnly(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)true, (boolean)rmd.isSearchable(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)true, (boolean)rmd.isSigned(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)true, (boolean)rmd.isWritable(1));
        TestResultsMetadataWithProvider.assertEquals((String)"vdb", (String)rmd.getCatalogName(1));
        TestResultsMetadataWithProvider.assertEquals(null, (String)rmd.getSchemaName(1));
        TestResultsMetadataWithProvider.assertEquals((String)"table", (String)rmd.getTableName(1));
        TestResultsMetadataWithProvider.assertEquals((String)"col1", (String)rmd.getColumnName(1));
        TestResultsMetadataWithProvider.assertEquals((String)"col1Label", (String)rmd.getColumnLabel(1));
        TestResultsMetadataWithProvider.assertEquals((String)"string", (String)rmd.getColumnTypeName(1));
    }

    public void test2BackwardCompatibilityTest() throws Exception {
        ResultSetMetaDataImpl rmd = new ResultSetMetaDataImpl(this.exampleProvider(), "false");
        TestResultsMetadataWithProvider.assertEquals((boolean)false, (boolean)rmd.isAutoIncrement(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)false, (boolean)rmd.isCaseSensitive(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)false, (boolean)rmd.isCurrency(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)true, (boolean)rmd.isDefinitelyWritable(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)false, (boolean)rmd.isReadOnly(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)true, (boolean)rmd.isSearchable(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)true, (boolean)rmd.isSigned(1));
        TestResultsMetadataWithProvider.assertEquals((boolean)true, (boolean)rmd.isWritable(1));
        TestResultsMetadataWithProvider.assertEquals((String)"vdb", (String)rmd.getCatalogName(1));
        TestResultsMetadataWithProvider.assertEquals(null, (String)rmd.getSchemaName(1));
        TestResultsMetadataWithProvider.assertEquals((String)"table", (String)rmd.getTableName(1));
        TestResultsMetadataWithProvider.assertEquals((String)"col1Label", (String)rmd.getColumnName(1));
        TestResultsMetadataWithProvider.assertEquals((String)"col1Label", (String)rmd.getColumnLabel(1));
        TestResultsMetadataWithProvider.assertEquals((String)"string", (String)rmd.getColumnTypeName(1));
    }
}

