/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.events;

import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.VDB;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.events.EventListener;
import org.teiid.jdbc.FakeServer;

public class TestEventDistributor {
    private static final String VDB = "PartsSupplier";

    @Test
    public void testEvents() throws Exception {
        FakeServer server = null;
        try {
            server = new FakeServer(true);
            EventListener events = (EventListener)Mockito.mock(EventListener.class);
            server.getEventDistributor().register(events);
            server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
            ((EventListener)Mockito.verify((Object)events)).vdbDeployed(VDB, "1");
            ((EventListener)Mockito.verify((Object)events)).vdbLoaded((VDB)Mockito.any());
            server.undeployVDB(VDB);
            ((EventListener)Mockito.verify((Object)events)).vdbDeployed(VDB, "1");
            ((EventListener)Mockito.verify((Object)events)).vdbLoaded((VDB)Mockito.any());
            ((EventListener)Mockito.verify((Object)events)).vdbUndeployed(VDB, "1");
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }
}

