/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.visitor.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageObject;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.language.visitor.CollectorVisitor;

public class TestCollectorVisitor {
    public Set<String> getStringSet(Collection<? extends Object> objs) {
        HashSet<String> strings = new HashSet<String>();
        for (Object object : objs) {
            if (object == null) {
                strings.add(null);
                continue;
            }
            strings.add(object.toString());
        }
        return strings;
    }

    public void helpTestCollection(LanguageObject obj, Class type, String[] objects) {
        Set<String> actualObjects = this.getStringSet(CollectorVisitor.collectObjects((Class)type, (LanguageObject)obj));
        HashSet<String> expectedObjects = new HashSet<String>(Arrays.asList(objects));
        Assert.assertEquals((String)"Did not get expected objects", expectedObjects, actualObjects);
    }

    public LanguageObject example1() {
        NamedTable g = new NamedTable("g1", null, null);
        ArrayList<Object> symbols = new ArrayList<Object>();
        symbols.add(new ColumnReference(g, "e1", null, String.class));
        Function function = new Function("length", Arrays.asList(new ColumnReference(g, "e2", null, String.class)), Integer.class);
        symbols.add(function);
        ArrayList<NamedTable> groups = new ArrayList<NamedTable>();
        groups.add(g);
        Select q = new Select(symbols, false, groups, null, null, null, null);
        return q;
    }

    @Test
    public void testCollection1() {
        this.helpTestCollection(this.example1(), ColumnReference.class, new String[]{"g1.e1", "g1.e2"});
    }

    @Test
    public void testCollection2() {
        this.helpTestCollection(this.example1(), Function.class, new String[]{"length(g1.e2)"});
    }

    @Test
    public void testCollection3() {
        this.helpTestCollection(this.example1(), Expression.class, new String[]{"g1.e1", "g1.e2", "length(g1.e2)"});
    }

    public void helpTestElementsUsedByGroups(LanguageObject obj, String[] elements, String[] groups) {
        Set<String> actualElements = this.getStringSet(CollectorVisitor.collectElements((LanguageObject)obj));
        Set<String> actualGroups = this.getStringSet(CollectorVisitor.collectGroupsUsedByElements((LanguageObject)obj));
        HashSet<String> expectedElements = new HashSet<String>(Arrays.asList(elements));
        HashSet<String> expectedGroups = new HashSet<String>(Arrays.asList(groups));
        Assert.assertEquals((String)"Did not get expected elements", expectedElements, actualElements);
        Assert.assertEquals((String)"Did not get expected groups", expectedGroups, actualGroups);
    }

    @Test
    public void test1() {
        NamedTable g1 = new NamedTable("g1", null, null);
        ColumnReference e1 = new ColumnReference(g1, "e1", null, String.class);
        this.helpTestElementsUsedByGroups((LanguageObject)e1, new String[]{"g1.e1"}, new String[]{"g1"});
    }

    @Test
    public void test2() {
        NamedTable g1 = new NamedTable("g1", null, null);
        ColumnReference e1 = new ColumnReference(g1, "e1", null, String.class);
        ColumnReference e2 = new ColumnReference(g1, "e2", null, String.class);
        Comparison cc = new Comparison((Expression)e1, (Expression)e2, Comparison.Operator.EQ);
        this.helpTestElementsUsedByGroups((LanguageObject)cc, new String[]{"g1.e1", "g1.e2"}, new String[]{"g1"});
    }
}

