/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Identity;
import java.security.Principal;
import java.security.acl.Group;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Vector;
import javax.security.auth.Subject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.runtime.DoNothingSecurityHelper;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.HardCodedExecutionFactory;
import org.teiid.security.SecurityHelper;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class TestRowBasedSecurity {
    private EmbeddedServer es;

    @After
    public void tearDown() {
        this.es.stop();
    }

    @Test
    public void testSecurity() throws Exception {
        this.es = new EmbeddedServer();
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        Vector<1> v = new Vector<1>();
        v.add(new Identity("myrole"){});
        final Subject subject = new Subject();
        Group g = (Group)Mockito.mock(Group.class);
        Mockito.stub((Object)g.getName()).toReturn((Object)"Roles");
        Mockito.stub((Object)g.members()).toReturn(v.elements());
        subject.getPrincipals().add((Principal)g);
        ec.setSecurityHelper((SecurityHelper)new DoNothingSecurityHelper(){

            public Subject getSubjectInContext(String securityDomain) {
                return subject;
            }

            public Subject getSubjectInContext(Object context) {
                return subject;
            }
        });
        this.es.start(ec);
        HardCodedExecutionFactory hcef = new HardCodedExecutionFactory(){

            public void getMetadata(MetadataFactory metadataFactory, Object conn) throws TranslatorException {
                Table t = metadataFactory.addTable("x");
                Column col = metadataFactory.addColumn("col", "string", (ColumnSet)t);
                metadataFactory.addColumn("col2", "string", (ColumnSet)t);
                metadataFactory.addPermission("y", (AbstractMetadataRecord)t, null, null, Boolean.TRUE, null, null, null, "col = 'a'", null);
                metadataFactory.addColumnPermission("y", col, null, null, null, null, "null", null);
                t = metadataFactory.addTable("y");
                col = metadataFactory.addColumn("col", "string", (ColumnSet)t);
                metadataFactory.addColumn("col2", "string", (ColumnSet)t);
                metadataFactory.addPermission("z", (AbstractMetadataRecord)t, null, null, null, null, null, null, "col = 'e'", null);
                Table v = metadataFactory.addTable("v");
                metadataFactory.addPermission("y", (AbstractMetadataRecord)v, null, null, Boolean.TRUE, null, null, null, null, null);
                col = metadataFactory.addColumn("col", "string", (ColumnSet)v);
                metadataFactory.addColumn("col2", "string", (ColumnSet)v);
                v.setTableType(Table.Type.View);
                v.setVirtual(true);
                v.setSelectTransformation("/*+ cache(scope:session) */ select col, col2 from y");
            }

            public boolean isSourceRequiredForMetadata() {
                return false;
            }
        };
        hcef.addData("SELECT x.col, x.col2 FROM x", Arrays.asList(Arrays.asList("a", "b"), Arrays.asList("c", "d")));
        hcef.addData("SELECT y.col, y.col2 FROM y", Arrays.asList(Arrays.asList("e", "f"), Arrays.asList("h", "g")));
        this.es.addTranslator("hc", (ExecutionFactory)hcef);
        this.es.deployVDB((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"roles-vdb.xml")));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:z;PassthroughAuthentication=true", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from x");
        rs.next();
        Assert.assertEquals(null, (Object)rs.getString(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        s = c.createStatement();
        rs = s.executeQuery("select lookup('myschema.x', 'col', 'col2', 'b')");
        rs.next();
        Assert.assertEquals(null, (Object)rs.getString(1));
        s = c.createStatement();
        rs = s.executeQuery("select count(col2) from v where col is not null");
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        v.clear();
        c = this.es.getDriver().connect("jdbc:teiid:z;PassthroughAuthentication=true", null);
        s = c.createStatement();
        rs = s.executeQuery("select count(col2) from v where col is not null");
        rs.next();
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
    }
}

