/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.metadata.runtime;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.ColumnReference;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Select;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;

public class TestElement
extends TestCase {
    private static TranslationUtility CONNECTOR_METADATA_UTILITY = TestElement.createTranslationUtility(TestElement.getTestVDBName());
    Map<String, String> props;

    public TestElement(String name) {
        super(name);
    }

    private static String getTestVDBName() {
        return UnitTestUtil.getTestDataPath() + "/ConnectorMetadata.vdb";
    }

    public static TranslationUtility createTranslationUtility(String vdbName) {
        return new TranslationUtility(vdbName);
    }

    public Column getElement(String groupName, String elementName, TranslationUtility transUtil) throws Exception {
        Select query = (Select)transUtil.parseCommand("SELECT " + elementName + " FROM " + groupName);
        DerivedColumn symbol = (DerivedColumn)query.getDerivedColumns().get(0);
        ColumnReference element = (ColumnReference)symbol.getExpression();
        return element.getMetadataObject();
    }

    public void helpTestElement(String fullGroupName, String elementShortName, TranslationUtility transUtil, String nameInSource, Object defaultValue, Object minValue, Object maxValue, Class<?> javaType, int length, BaseColumn.NullType nullable, int position, Column.SearchType searchable, boolean autoIncrement, boolean caseSensitive, Map<String, String> expectedProps) throws Exception {
        Column element = this.getElement(fullGroupName, elementShortName, transUtil);
        TestElement.assertEquals((String)nameInSource, (String)element.getNameInSource());
        TestElement.assertEquals((Object)defaultValue, (Object)element.getDefaultValue());
        TestElement.assertEquals((Object)minValue, (Object)element.getMinimumValue());
        TestElement.assertEquals((Object)maxValue, (Object)element.getMaximumValue());
        TestElement.assertEquals(javaType, (Object)element.getJavaType());
        TestElement.assertEquals((int)length, (int)element.getLength());
        TestElement.assertEquals((Object)nullable, (Object)element.getNullType());
        TestElement.assertEquals((int)(position + 1), (int)element.getPosition());
        TestElement.assertEquals((Object)searchable, (Object)element.getSearchType());
        TestElement.assertEquals((boolean)autoIncrement, (boolean)element.isAutoIncremented());
        TestElement.assertEquals((boolean)caseSensitive, (boolean)element.isCaseSensitive());
        Map extProps = element.getProperties();
        TestElement.assertEquals(expectedProps, (Object)extProps);
    }

    public void testElement1() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestNameInSource", CONNECTOR_METADATA_UTILITY, "the name in source", null, null, null, String.class, 10, BaseColumn.NullType.Nullable, 0, Column.SearchType.Searchable, false, true, this.props);
    }

    public void testElement2() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestDefaultValue", CONNECTOR_METADATA_UTILITY, null, "1000", null, null, Integer.class, 0, BaseColumn.NullType.Nullable, 1, Column.SearchType.Searchable, false, true, this.props);
    }

    public void testElement3() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestMinMaxValue", CONNECTOR_METADATA_UTILITY, null, null, "500", "25000", Integer.class, 0, BaseColumn.NullType.Nullable, 2, Column.SearchType.Searchable, false, true, this.props);
    }

    public void testElement4() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestAutoIncrement", CONNECTOR_METADATA_UTILITY, null, null, null, null, Long.class, 0, BaseColumn.NullType.Nullable, 3, Column.SearchType.Searchable, true, true, this.props);
    }

    public void testElement5() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestCaseSensitive", CONNECTOR_METADATA_UTILITY, null, null, null, null, String.class, 10, BaseColumn.NullType.Nullable, 4, Column.SearchType.Searchable, false, false, this.props);
    }

    public void testElement6() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestExtensionProp", CONNECTOR_METADATA_UTILITY, null, null, null, null, Integer.class, 0, BaseColumn.NullType.Nullable, 5, Column.SearchType.Searchable, false, true, this.props);
    }

    public void testEnterpriseDataTypes() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestDataType", CONNECTOR_METADATA_UTILITY, null, null, null, null, String.class, 0, BaseColumn.NullType.Nullable, 6, Column.SearchType.Searchable, false, true, this.props);
    }

    public void testUnsearchable() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestSearchableColumns", "TestUnsearchable", CONNECTOR_METADATA_UTILITY, null, null, null, null, Integer.class, 0, BaseColumn.NullType.Nullable, 0, Column.SearchType.Unsearchable, false, true, this.props);
    }

    public void testSearchableLike() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestSearchableColumns", "TestSearchableLike", CONNECTOR_METADATA_UTILITY, null, null, null, null, String.class, 10, BaseColumn.NullType.Nullable, 1, Column.SearchType.Like_Only, false, true, this.props);
    }

    public void testSearchableComparable() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestSearchableColumns", "TestSearchableComparable", CONNECTOR_METADATA_UTILITY, null, null, null, null, Integer.class, 0, BaseColumn.NullType.Nullable, 2, Column.SearchType.All_Except_Like, false, true, this.props);
    }

    public void testSearchable() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestSearchableColumns", "TestSearchable", CONNECTOR_METADATA_UTILITY, null, null, null, null, String.class, 10, BaseColumn.NullType.Nullable, 3, Column.SearchType.Searchable, false, true, this.props);
    }

    public void testNullable() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestNullableColumns", "TestNullable", CONNECTOR_METADATA_UTILITY, null, null, null, null, Integer.class, 0, BaseColumn.NullType.Nullable, 0, Column.SearchType.Searchable, false, true, this.props);
    }

    public void testNotNullable() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestNullableColumns", "TestNotNullable", CONNECTOR_METADATA_UTILITY, null, null, null, null, String.class, 10, BaseColumn.NullType.No_Nulls, 1, Column.SearchType.Searchable, false, true, this.props);
    }

    public void testNullableUnknown() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestNullableColumns", "TestNullableUnknown", CONNECTOR_METADATA_UTILITY, null, null, null, null, String.class, 10, BaseColumn.NullType.Unknown, 2, Column.SearchType.Searchable, false, true, this.props);
    }

    public void testElementWithCategories() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestCatalog.TestSchema.TestTable2", "TestCol", CONNECTOR_METADATA_UTILITY, null, null, null, null, Integer.class, 0, BaseColumn.NullType.Nullable, 0, Column.SearchType.Searchable, false, true, this.props);
    }

    protected void setUp() throws Exception {
        this.props = new HashMap<String, String>();
        this.props.put("ColProp", "defaultvalue");
    }
}

