/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.util.Properties;
import javax.security.auth.Subject;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.runtime.DoNothingSecurityHelper;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.security.SecurityHelper;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.SSLAwareChannelHandler;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;

public class TestJDBCSocketAuthentication {
    static InetSocketAddress addr;
    static SocketListener jdbcTransport;
    static FakeServer server;
    static int delay;
    Connection conn;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        SocketConfiguration config = new SocketConfiguration();
        config.setSSLConfiguration(new SSLConfiguration());
        addr = new InetSocketAddress(0);
        config.setBindAddress(addr.getHostName());
        config.setPortNumber(0);
        EmbeddedConfiguration dqpConfig = new EmbeddedConfiguration();
        dqpConfig.setMaxActivePlans(2);
        dqpConfig.setSecurityHelper((SecurityHelper)new DoNothingSecurityHelper(){

            public Subject getSubjectInContext(Object context) {
                return null;
            }

            public Subject getSubjectInContext(String securityDomain) {
                return null;
            }
        });
        server = new FakeServer(false);
        server.start(dqpConfig, false);
        server.deployVDB("parts", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        jdbcTransport = new SocketListener(addr, config, server.getClientServiceRegistry(), (StorageManager)BufferManagerFactory.getStandaloneBufferManager()){

            protected SSLAwareChannelHandler createChannelHandler() {
                SSLAwareChannelHandler result = new SSLAwareChannelHandler((ChannelListener.ChannelListenerFactory)this){

                    public void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
                        if (delay > 0) {
                            Thread.sleep(delay);
                        }
                        super.messageReceived(ctx, msg);
                    }
                };
                return result;
            }
        };
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        if (jdbcTransport != null) {
            jdbcTransport.stop();
        }
        server.stop();
    }

    @After
    public void tearDown() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Test(expected=TeiidSQLException.class)
    public void testTrustLocalFails() throws Exception {
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        p.setProperty("PassthroughAuthentication", "true");
        this.conn = TeiidDriver.getInstance().connect("jdbc:teiid:parts@mm://" + addr.getHostName() + ":" + jdbcTransport.getPort(), p);
    }

    @Test
    public void testTrustLocal() throws Exception {
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        this.conn = TeiidDriver.getInstance().connect("jdbc:teiid:parts@mm://" + addr.getHostName() + ":" + jdbcTransport.getPort(), p);
    }

    @Test
    public void testSetAuthType() throws Exception {
        FakeServer es = new FakeServer(false);
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setAuthenticationType(AuthenticationType.GSS);
        es.start(ec);
        es.deployVDB("parts", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        Assert.assertEquals((Object)AuthenticationType.GSS, (Object)es.getSessionService().getAuthenticationType("parts", null, "testuser"));
        Assert.assertEquals((Object)AuthenticationType.GSS, (Object)es.getClientServiceRegistry().getAuthenticationType());
        es.stop();
    }
}

