/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.jboss.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.Base64;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.core.util.StringUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestRestWebserviceGeneration
extends AbstractMMQueryTestCase {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9990, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testGetOperation() throws Exception {
        Properties p = new Properties();
        p.setProperty("class-name", "org.teiid.resource.adapter.ws.WSManagedConnectionFactory");
        p.setProperty("EndPoint", "http://localhost:8080");
        p.setProperty("RequestTimeout", "20000");
        AdminUtil.createDataSource(this.admin, "sample-ws", "webservice", p);
        this.deployVDB();
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "sample", 1, 3));
        this.admin.deploy("sample-ws-vdb.xml", (InputStream)new ReaderInputStream((Reader)new StringReader("<vdb name=\"sample-ws\" version=\"1\"><model name=\"ws\"><source name=\"ws\" translator-name=\"ws\" connection-jndi-name=\"java:/sample-ws\"/></model></vdb>"), Charset.forName("UTF-8")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "sample-ws", 1, 3));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:sample@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT * FROM Txns.G1");
        this.internalResultSet.next();
        Assert.assertTrue((String)"sample_1.war not found", (boolean)AdminUtil.waitForDeployment(this.admin, "sample_1.war", 5));
        String response = this.httpCall("http://localhost:8080/sample_1/View/g1/123?p2=test", "GET", null);
        String expected = "<rows p1=\"123\" p2=\"test\"><row><e1>ABCDEFGHIJ</e1><e2>0</e2></row></rows>";
        Assert.assertEquals((String)"response did not match expected", (Object)expected, (Object)response);
        this.internalConnection.close();
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:sample-ws@mm://localhost:31000;user=user;password=user", null);
        this.execute("select to_chars(x.result, 'UTF-8') from (call invokeHttp(action=>'GET',endpoint=>'sample_1/View/g1/123?p2=test')) as x");
        this.internalResultSet.next();
        Assert.assertEquals((Object)expected, (Object)this.internalResultSet.getString(1));
        response = this.httpCall("http://localhost:8080/sample_1/View/largedoc", "GET", null);
        Assert.assertEquals((long)327801L, (long)response.length());
        this.execute("select * from xmltable('/rows/row/e1' passing xmlparse(document (select result from (call invokeHttp(action=>'GET',endpoint=>'sample_1/View/g1/123?p2=test')) as d))) as x");
        this.internalResultSet.next();
        Assert.assertEquals((Object)"<e1>ABCDEFGHIJ</e1>", (Object)this.internalResultSet.getString(1));
        this.admin.deploy("sample2-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"sample2-vdb.xml")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "sample2", 1, 3));
        response = this.httpCall("http://localhost:8080/sample_1/swagger.yaml", "GET", null);
        Thread.sleep(2000L);
        String response1 = this.httpCall("http://localhost:8080/sample2_1/swagger.yaml", "GET", null);
        Assert.assertNotEquals((Object)response, (Object)response1);
        this.admin.undeploy("sample-vdb.xml");
        Thread.sleep(2000L);
    }

    @Test
    public void testPostOperation() throws Exception {
        this.deployVDB();
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:sample@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT * FROM Txns.G1");
        this.internalResultSet.next();
        Assert.assertTrue((String)"sample_1.war not found", (boolean)AdminUtil.waitForDeployment(this.admin, "sample_1.war", 5));
        String params = URLEncoder.encode("p1", "UTF-8") + "=" + URLEncoder.encode("456", "UTF-8");
        String response = this.httpCall("http://localhost:8080/sample_1/View/g1simplepost", "POST", params);
        Assert.assertEquals((String)"response did not match expected", (Object)"<rows p1=\"456\" p2=\"1\"><row><e1>ABCDEFGHIJ</e1><e2>0</e2></row></rows>", (Object)response);
        params = params + "&" + URLEncoder.encode("p2", "UTF-8") + "=" + URLEncoder.encode("2", "UTF-8");
        params = params + "&" + URLEncoder.encode("p3", "UTF-8") + "=" + URLEncoder.encode("string value", "UTF-8");
        response = this.httpCall("http://localhost:8080/sample_1/View/g1simplepost", "POST", params);
        Assert.assertEquals((String)"response did not match expected", (Object)"<rows p1=\"456\" p2=\"2\" p3=\"string value\"><row><e1>ABCDEFGHIJ</e1><e2>0</e2></row></rows>", (Object)response);
        params = URLEncoder.encode("sql", "UTF-8") + "=" + URLEncoder.encode("SELECT XMLELEMENT(NAME \"rows\", XMLAGG(XMLELEMENT(NAME \"row\", XMLFOREST(e1, e2)))) AS xml_out FROM Txns.G1", "UTF-8");
        response = this.httpCall("http://localhost:8080/sample_1/View/query", "POST", params);
        Assert.assertEquals((String)"response did not match expected", (Object)"<rows><row><e1>ABCDEFGHIJ</e1><e2>0</e2></row></rows>", (Object)response);
        this.admin.undeploy("sample-vdb.xml");
        Thread.sleep(2000L);
    }

    private void deployVDB() throws AdminException, FileNotFoundException {
        try {
            this.admin.undeploy("sample_1.war");
        }
        catch (AdminException adminException) {
            // empty catch block
        }
        this.admin.deploy("sample-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"sample-vdb.xml")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "sample", 1, 3));
    }

    @Test
    public void testMultipartPostOperation() throws Exception {
        this.deployVDB();
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "sample", 1, 3));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:sample@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT * FROM Txns.G1");
        this.internalResultSet.next();
        Assert.assertTrue((String)"sample_1.war not found", (boolean)AdminUtil.waitForDeployment(this.admin, "sample_1.war", 5));
        String params = URLEncoder.encode("p1", "UTF-8") + "=" + URLEncoder.encode("456", "UTF-8");
        HttpEntity entity = MultipartEntityBuilder.create().addTextBody("p1", "456").build();
        String response = this.httpMultipartPost(entity, "http://localhost:8080/sample_1/View/g1post");
        Assert.assertEquals((String)"response did not match expected", (Object)"<rows p1=\"456\" p2=\"1\"><row><e1>ABCDEFGHIJ</e1><e2>0</e2></row></rows>", (Object)response);
        entity = MultipartEntityBuilder.create().addTextBody("p1", "456").addTextBody("p2", "2").addTextBody("p3", "string value").addBinaryBody("p4", "<root><p4>bar</p4></root>".getBytes("UTF-8"), ContentType.create((String)"application/xml", (String)"UTF-8"), "foo.xml").build();
        response = this.httpMultipartPost(entity, "http://localhost:8080/sample_1/View/g1post");
        Assert.assertEquals((String)"response did not match expected", (Object)"<rows p1=\"456\" p2=\"2\" p3=\"string value\" p4=\"bar\"><row><e1>ABCDEFGHIJ</e1><e2>0</e2></row></rows>", (Object)response);
        params = URLEncoder.encode("sql", "UTF-8") + "=" + URLEncoder.encode("SELECT XMLELEMENT(NAME \"rows\", XMLAGG(XMLELEMENT(NAME \"row\", XMLFOREST(e1, e2)))) AS xml_out FROM Txns.G1", "UTF-8");
        response = this.httpCall("http://localhost:8080/sample_1/View/query", "POST", params);
        Assert.assertEquals((String)"response did not match expected", (Object)"<rows><row><e1>ABCDEFGHIJ</e1><e2>0</e2></row></rows>", (Object)response);
        entity = MultipartEntityBuilder.create().addBinaryBody("p1", "<root><p4>bar</p4></root>".getBytes("UTF-8"), ContentType.create((String)"application/xml", (String)"UTF-8"), "foo.xml").build();
        response = this.httpMultipartPost(entity, "http://localhost:8080/sample_1/View/blobpost");
        Assert.assertEquals((String)"response did not match expected", (Object)"<root><p4>bar</p4></root>", (Object)response);
        entity = MultipartEntityBuilder.create().addBinaryBody("p1", "<root><p4>bar</p4></root>".getBytes("UTF-8"), ContentType.create((String)"application/xml", (String)"UTF-8"), "foo.xml").build();
        response = this.httpMultipartPost(entity, "http://localhost:8080/sample_1/View/clobpost");
        Assert.assertEquals((String)"response did not match expected", (Object)"<root><p4>bar</p4></root>", (Object)response);
        entity = MultipartEntityBuilder.create().addBinaryBody("p1", Base64.encodeBytes((byte[])"<root><p4>bar</p4></root>".getBytes("UTF-8")).getBytes("UTF-8"), ContentType.create((String)"application/xml", (String)"UTF-8"), "foo.xml").build();
        response = this.httpMultipartPost(entity, "http://localhost:8080/sample_1/View/binarypost");
        Assert.assertEquals((String)"response did not match expected", (Object)"", (Object)response);
        params = URLEncoder.encode("p1", "UTF-8") + "=" + URLEncoder.encode(Base64.encodeBytes((byte[])"<root><p4>bar</p4></root>".getBytes("UTF-8")), "UTF-8");
        response = this.httpCall("http://localhost:8080/sample_1/View/binarypost", "POST", params);
        Assert.assertEquals((String)"response did not match expected", (Object)"<root><p4>bar</p4></root>", (Object)response);
        this.admin.undeploy("sample-vdb.xml");
        Thread.sleep(2000L);
    }

    @Test
    public void testSemanticVersion() throws Exception {
        String vdb = ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"sample-vdb.xml"));
        vdb = StringUtil.replace((String)vdb, (String)"name=\"sample\" version=\"1\"", (String)"name=\"sample\" version=\"2.1.1\"");
        this.admin.deploy("sample-vdb.xml", (InputStream)new ByteArrayInputStream(vdb.getBytes("UTF-8")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "sample", "2.1.1", 3));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:sample@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT * FROM Txns.G1");
        this.internalResultSet.next();
        Assert.assertTrue((String)"sample_2.1.1.war not found", (boolean)AdminUtil.waitForDeployment(this.admin, "sample_2.1.1.war", 5));
        HttpEntity entity = MultipartEntityBuilder.create().addTextBody("p1", "456").build();
        String response = this.httpMultipartPost(entity, "http://localhost:8080/sample_2.1.1/View/g1post");
        Assert.assertEquals((String)"response did not match expected", (Object)"<rows p1=\"456\" p2=\"1\"><row><e1>ABCDEFGHIJ</e1><e2>0</e2></row></rows>", (Object)response);
        this.admin.undeploy("sample-vdb.xml");
        Thread.sleep(2000L);
    }

    private String httpMultipartPost(HttpEntity entity, String url) throws ClientProtocolException, IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(entity);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        return ObjectConverterUtil.convertToString((Reader)new InputStreamReader(response.getEntity().getContent(), Charset.forName("UTF-8")));
    }

    private String httpCall(String url, String method, String params) throws Exception {
        int code;
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        if (method.equalsIgnoreCase("post")) {
            OutputStreamWriter wr = new OutputStreamWriter(connection.getOutputStream());
            wr.write(params);
            wr.flush();
        }
        if ((code = connection.getResponseCode()) >= 400) {
            throw new TeiidRuntimeException(String.valueOf(code));
        }
        return ObjectConverterUtil.convertToString((Reader)new InputStreamReader(connection.getInputStream(), Charset.forName("UTF-8")));
    }
}

