/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc;

import com.arjuna.ats.internal.jdbc.ConnectionControl;
import com.arjuna.ats.internal.jdbc.ConnectionManager;
import com.arjuna.ats.internal.jdbc.ConnectionSynchronization;
import com.arjuna.ats.internal.jdbc.DirectRecoverableConnection;
import com.arjuna.ats.internal.jdbc.IndirectRecoverableConnection;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.ConnectionModifier;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.ModifierFactory;
import com.arjuna.ats.jdbc.common.jdbcPropertyManager;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import com.arjuna.ats.jta.xa.RecoverableXAConnection;
import com.arjuna.ats.jta.xa.XAModifier;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public class ConnectionImple
implements Connection {
    private RecoverableXAConnection _recoveryConnection;
    private Object _theModifier;
    private Connection _theConnection;
    private static final int defaultIsolationLevel = 8;
    private static int _currentIsolationLevel = 8;

    public ConnectionImple(String dbName, Properties info) throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(1L, 4L, 1L, "ConnectionImple.ConnectionImple ( " + dbName + " )");
        }
        String user = null;
        String passwd = null;
        String dynamic = null;
        if (info != null) {
            user = info.getProperty("user");
            passwd = info.getProperty("password");
            dynamic = info.getProperty("DYNAMIC_CLASS");
        }
        this._recoveryConnection = dynamic == null || dynamic.equals("") ? new IndirectRecoverableConnection(dbName, user, passwd, this) : new DirectRecoverableConnection(dbName, user, passwd, dynamic, this);
        this._theModifier = null;
        this._theConnection = null;
    }

    public ConnectionImple(String dbName, String user, String passwd) throws SQLException {
        this(dbName, user, passwd, null);
    }

    public ConnectionImple(String dbName, String user, String passwd, String dynamic) throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(1L, 4L, 1L, "ConnectionImple.ConnectionImple ( " + dbName + ", " + user + ", " + passwd + ", " + dynamic + " )");
        }
        this._recoveryConnection = dynamic == null || dynamic.equals("") ? new IndirectRecoverableConnection(dbName, user, passwd, this) : new DirectRecoverableConnection(dbName, user, passwd, dynamic, this);
        this._theModifier = null;
        this._theConnection = null;
    }

    public void finalize() {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(2L, 4L, 1L, "ConnectionImple.finalize ()");
        }
        this._recoveryConnection = null;
        this._theConnection = null;
    }

    public Statement createStatement() throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().createStatement();
    }

    public Statement createStatement(int rs, int rc) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().createStatement(rs, rc);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int rs, int rc) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareStatement(sql, rs, rc);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int rs, int rc) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareCall(sql, rs, rc);
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().nativeSQL(sql);
    }

    public Map getTypeMap() throws SQLException {
        return this.getConnection().getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.getConnection().setTypeMap(map);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.transactionRunning()) {
            if (autoCommit) {
                throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.autocommit"));
            }
        } else {
            this.getConnection().setAutoCommit(autoCommit);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.getConnection().getAutoCommit();
    }

    public void commit() throws SQLException {
        if (this.transactionRunning()) {
            throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.commiterror"));
        }
        this.getConnection().commit();
    }

    public void rollback() throws SQLException {
        if (this.transactionRunning()) {
            throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.aborterror"));
        }
        this.getConnection().rollback();
    }

    public void close() throws SQLException {
        try {
            TransactionManager tm;
            Transaction tx;
            if (!this._recoveryConnection.inuse()) {
                ConnectionManager.remove(this);
            }
            if ((tx = (tm = com.arjuna.ats.jta.TransactionManager.transactionManager()).getTransaction()) != null) {
                if (this._recoveryConnection.validTransaction(tx)) {
                    XAResource xares = this._recoveryConnection.getResource();
                    if (!tx.delistResource(xares, 0x4000000)) {
                        throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.delisterror"));
                    }
                    this.getModifier();
                    if (this._theModifier != null && ((ConnectionModifier)this._theModifier).supportsMultipleConnections()) {
                        tx.registerSynchronization((Synchronization)new ConnectionSynchronization(this._theConnection, this._recoveryConnection));
                        this._theConnection = null;
                    }
                }
            } else {
                this._recoveryConnection.close();
                this._theConnection = null;
            }
        }
        catch (IllegalStateException ex) {
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.closeerror") + e1);
        }
    }

    public boolean isClosed() throws SQLException {
        this.checkTransaction();
        if (this._theConnection == null) {
            return false;
        }
        return this._theConnection.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public void setReadOnly(boolean ro) throws SQLException {
        if (this._recoveryConnection.inuse()) {
            throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.setreadonly"));
        }
        this.getConnection().setReadOnly(ro);
    }

    public boolean isReadOnly() throws SQLException {
        return this.getConnection().isReadOnly();
    }

    public void setCatalog(String cat) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        this.getConnection().setCatalog(cat);
    }

    public String getCatalog() throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().getCatalog();
    }

    public void setTransactionIsolation(int iso) throws SQLException {
        this.checkTransaction();
        this.getConnection().setTransactionIsolation(iso);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.getConnection().getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.getConnection().getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.getConnection().clearWarnings();
    }

    public final RecoverableXAConnection recoveryConnection() {
        return this._recoveryConnection;
    }

    public void setHoldability(int holdability) throws SQLException {
        throw new SQLException("feature not supported");
    }

    public int getHoldability() throws SQLException {
        throw new SQLException("feature not supported");
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("feature not supported");
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("feature not supported");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("feature not supported");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("feature not supported");
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("feature not supported");
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("feature not supported");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("feature not supported");
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("feature not supported");
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("feature not supported");
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("feature not supported");
    }

    protected final XAResource getXAResource() {
        try {
            return this._recoveryConnection.getResource();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void reset() {
        try {
            if (this._theConnection != null) {
                this._theConnection.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this._theConnection = null;
        }
    }

    final Connection getConnection() throws SQLException {
        if (this._theConnection != null) {
            return this._theConnection;
        }
        XAConnection xaConn = this._recoveryConnection.getConnection();
        if (xaConn != null) {
            this._theConnection = xaConn.getConnection();
            try {
                this.getModifier();
                if (this._theModifier != null) {
                    ((ConnectionModifier)this._theModifier).setIsolationLevel(this._theConnection, _currentIsolationLevel);
                }
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception e) {
                if (jdbcLogger.loggerI18N.isWarnEnabled()) {
                    jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.isolationlevelfailset", new Object[]{"ConnectionImple.getConnection", e});
                }
                throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.conniniterror") + ":" + e);
            }
            return this._theConnection;
        }
        return null;
    }

    final ConnectionControl connectionControl() {
        return (ConnectionControl)((Object)this._recoveryConnection);
    }

    protected final boolean transactionRunning() throws SQLException {
        try {
            return com.arjuna.ats.jta.TransactionManager.transactionManager().getTransaction() != null;
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    protected final synchronized void registerDatabase() throws SQLException {
        Connection theConnection;
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(16L, 1L, 1L, "ConnectionImple.registerDatabase ()");
        }
        if ((theConnection = this.getConnection()) != null) {
            XAResource xares = null;
            try {
                TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
                Transaction tx = tm.getTransaction();
                if (tx == null) {
                    return;
                }
                if (!this._recoveryConnection.setTransaction(tx)) {
                    throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.alreadyassociated"));
                }
                Object[] params = this._theModifier != null ? new Object[2] : new Object[]{this._recoveryConnection};
                if (this._theModifier != null) {
                    params[1] = (XAModifier)this._theModifier;
                }
                if (!((com.arjuna.ats.jta.transaction.Transaction)tx).enlistResource(xares = this._recoveryConnection.getResource(), params)) {
                    try {
                        tx.setRollbackOnly();
                    }
                    catch (Exception e) {
                        if (jdbcLogger.loggerI18N.isWarnEnabled()) {
                            jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.rollbackerror", new Object[]{"ConnectionImple.registerDatabase"});
                        }
                        throw new SQLException(e.toString());
                    }
                    throw new SQLException("ConnectionImple.registerDatabase - " + jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.enlistfailed"));
                }
                params = null;
                xares = null;
                tx = null;
                tm = null;
            }
            catch (RollbackException e1) {
                throw new SQLException("ConnectionImple.registerDatabase - " + (Object)((Object)e1));
            }
            catch (SystemException e2) {
                throw new SQLException("ConnectionImple.registerDatabase - " + (Object)((Object)e2));
            }
            catch (SQLException e3) {
                throw e3;
            }
            catch (Exception e4) {
                throw new SQLException(e4.toString());
            }
        }
    }

    protected final void checkTransaction() throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(16L, 1L, 1L, "ConnectionImple.checkTransaction ()");
        }
        try {
            TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
            Transaction tx = tm.getTransaction();
            if (tx == null) {
                return;
            }
            if (!this._recoveryConnection.validTransaction(tx)) {
                throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.alreadyassociatedcheck"));
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception e3) {
            throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.infoerror"));
        }
    }

    private final void getModifier() {
        block3: {
            if (this._theModifier == null) {
                try {
                    DatabaseMetaData md = this._theConnection.getMetaData();
                    String name = md.getDriverName();
                    int major = md.getDriverMajorVersion();
                    int minor = md.getDriverMinorVersion();
                    this._theModifier = ModifierFactory.getModifier(name, major, minor);
                    ((ConnectionControl)((Object)this._recoveryConnection)).setModifier((ConnectionModifier)this._theModifier);
                }
                catch (Exception ex) {
                    if (!jdbcLogger.loggerI18N.isWarnEnabled()) break block3;
                    jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.getmoderror", (Throwable)ex);
                }
            }
        }
    }

    static {
        String isolationLevel = jdbcPropertyManager.propertyManager.getProperty("com.arjuna.ats.jdbc.isolationLevel");
        if (isolationLevel != null) {
            if (isolationLevel.equals("TRANSACTION_READ_COMMITTED")) {
                _currentIsolationLevel = 2;
            } else if (isolationLevel.equals("TRANSACTION_READ_UNCOMMITTED")) {
                _currentIsolationLevel = 1;
            } else if (isolationLevel.equals("TRANSACTION_REPEATABLE_READ")) {
                _currentIsolationLevel = 4;
            } else if (isolationLevel.equals("TRANSACTION_SERIALIZABLE")) {
                _currentIsolationLevel = 8;
            } else {
                if (jdbcLogger.loggerI18N.isWarnEnabled()) {
                    jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.isolationerror", new Object[]{isolationLevel});
                }
                _currentIsolationLevel = 8;
            }
        }
    }
}

